/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import com.backendless.BackendlessInternal;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.async.message.AsyncMessage;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.exceptions.BackendlessException;
import com.backendless.exceptions.BackendlessFault;
import java.util.Collections;
import java.util.Hashtable;
import javax.net.ssl.HostnameVerifier;
import weborb.client.Fault;
import weborb.client.IChainedResponder;
import weborb.client.IResponder;
import weborb.client.WeborbClient;
import weborb.util.ThreadContext;

public class Invoker {
    private static final BackendlessInjector injector = BackendlessInjector.getInstance();
    private static final String DESTINATION = "GenericDestination";
    private static final int DEFAULT_TIMEOUT = 100500;
    private static WeborbClient weborbClient;
    private static HostnameVerifier hostnameVerifier;

    static void reinitialize() {
        String urlEnding = BackendlessInternal.getApplicationUrl() + "/binary";
        weborbClient = new WeborbClient(urlEnding, 100500, DESTINATION);
        weborbClient.setCookiesDateFormat("EEE, dd-MMM-yy HH:mm:ss z");
        if (hostnameVerifier != null) {
            weborbClient.setHostnameVerifier(hostnameVerifier);
        }
    }

    static void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        Invoker.hostnameVerifier = hostnameVerifier;
        if (weborbClient != null) {
            weborbClient.setHostnameVerifier(hostnameVerifier);
        }
    }

    public static <T> void invokeAsync(String className, String methodName, Object[] args, AsyncCallback<T> callback) {
        Invoker.invokeAsync(className, methodName, args, callback, null);
    }

    public static <T> void invokeAsync(final String className, final String methodName, final Object[] args, final AsyncCallback<T> callback, final IChainedResponder responder) {
        injector.getThreadPoolService().getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Object result = Invoker.invokeSync(className, methodName, args, responder);
                    injector.getHandleCarrier().deliverMessage(new AsyncMessage(result, callback));
                }
                catch (BackendlessException e) {
                    injector.getHandleCarrier().deliverMessage(new AsyncMessage(new BackendlessFault(e), callback));
                }
            }
        });
    }

    public static <T> T invokeSync(String className, String methodName, Object[] args, IChainedResponder chainedResponder) throws BackendlessException {
        SyncResponder invokeResponder = new SyncResponder();
        if (chainedResponder == null) {
            chainedResponder = new AdaptingResponder();
        }
        chainedResponder.setNextResponder((IResponder)invokeResponder);
        try {
            ThreadContext.cleanup();
            weborbClient.invoke(className, methodName, args, Collections.emptyMap(), null, new Hashtable<String, String>(injector.getHeadersManager().getHeaders()), (IResponder)chainedResponder);
        }
        catch (Exception e) {
            throw new BackendlessException("Server returned an error.", e.getMessage());
        }
        return (T)invokeResponder.getResult();
    }

    public static <T> T invokeSync(String className, String methodName, Object[] args) throws BackendlessException {
        return Invoker.invokeSync(className, methodName, args, null);
    }

    static class SyncResponder
    implements IResponder {
        private Object result;
        private BackendlessException exception;

        SyncResponder() {
        }

        public void responseHandler(Object o) {
            this.result = o;
        }

        public void errorHandler(Fault fault) {
            this.exception = fault instanceof BackendlessFault ? new BackendlessException((BackendlessFault)fault) : new BackendlessException(new BackendlessFault(fault));
        }

        public Object getResult() throws BackendlessException {
            if (this.exception == null) {
                return this.result;
            }
            throw this.exception;
        }
    }
}

