/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import com.backendless.BackendlessUser;
import com.backendless.DataPermission;
import com.backendless.DataStore;
import com.backendless.Footprint;
import com.backendless.FootprintsManager;
import com.backendless.IDataStore;
import com.backendless.Invoker;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.commons.persistence.GroupResult;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.core.responder.policy.PoJoAdaptingPolicy;
import com.backendless.exceptions.BackendlessException;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.exceptions.ExceptionMessage;
import com.backendless.persistence.BackendlessDataQuery;
import com.backendless.persistence.BackendlessGroupDataQuery;
import com.backendless.persistence.BackendlessSerializer;
import com.backendless.persistence.DataQueryBuilder;
import com.backendless.persistence.GroupDataQueryBuilder;
import com.backendless.persistence.LoadRelationsQueryBuilder;
import com.backendless.persistence.MapDrivenDataStore;
import com.backendless.persistence.QueryOptions;
import com.backendless.property.ObjectProperty;
import com.backendless.utils.MapEntityUtil;
import com.backendless.utils.ReflectionUtil;
import com.backendless.utils.ResponderHelper;
import com.backendless.utils.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weborb.client.IChainedResponder;
import weborb.types.Types;
import weborb.writer.IObjectSubstitutor;
import weborb.writer.MessageWriter;

public final class Persistence {
    public static final String PERSISTENCE_MANAGER_SERVER_ALIAS = "com.backendless.services.persistence.PersistenceService";
    private static final String DEFAULT_OBJECT_ID_GETTER = "getObjectId";
    public static final String DEFAULT_OBJECT_ID_FIELD = "objectId";
    public static final String DEFAULT_CREATED_FIELD = "created";
    public static final String DEFAULT_UPDATED_FIELD = "updated";
    public static final String DEFAULT_META_FIELD = "__meta";
    public static final String REST_CLASS_FIELD = "___class";
    public static final String PARCELABLE_CREATOR_FIELD_NAME = "CREATOR";
    public static final String LOAD_ALL_RELATIONS = "*";
    public static final DataPermission Permissions = new DataPermission();
    private static final Persistence instance = new Persistence();
    private final BackendlessInjector injector = BackendlessInjector.getInstance();

    static Persistence getInstance() {
        return instance;
    }

    private Persistence() {
        Types.addClientClassMapping((String)"com.backendless.services.persistence.BackendlessDataQuery", BackendlessDataQuery.class);
        Types.addClientClassMapping((String)"com.backendless.services.persistence.common.BackendlessGroupDataQuery", BackendlessGroupDataQuery.class);
        Types.addClientClassMapping((String)"com.backendless.services.persistence.ObjectProperty", ObjectProperty.class);
        Types.addClientClassMapping((String)"com.backendless.services.persistence.QueryOptions", QueryOptions.class);
    }

    public void mapTableToClass(String tableName, Class clazz) {
        Types.addClientClassMapping((String)tableName, (Class)clazz);
    }

    public <E> List<String> create(List<E> objects) throws BackendlessException {
        return this.create(objects, null, false);
    }

    public <E> void create(List<E> objects, AsyncCallback<List<String>> responder) {
        this.create(objects, responder, true);
    }

    private <E> List<String> create(List<E> objects, AsyncCallback<List<String>> responder, boolean async) {
        if (objects == null) {
            throw new IllegalArgumentException("Object array for bulk operations cannot be null");
        }
        if (objects.isEmpty()) {
            return new ArrayList<String>();
        }
        String tableName = BackendlessSerializer.getSimpleName(objects.get(0).getClass());
        ArrayList<Map<String, Object>> serializedEntities = new ArrayList<Map<String, Object>>();
        for (E entity : objects) {
            serializedEntities.add(this.serializeEntityBeforeCreate(entity));
        }
        Object[] args = new Object[]{tableName, serializedEntities};
        if (!async) {
            return (List)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "createBulk", args, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(objects.get(0).getClass()));
        }
        Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "createBulk", args, responder, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(objects.get(0).getClass()));
        return null;
    }

    public <E> E save(E entity) throws BackendlessException {
        return this.save(entity, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E save(E entity, boolean isUpsert) throws BackendlessException {
        Map<String, Object> serializedEntity = this.serializeEntityBeforeCreate(entity);
        try {
            String method = isUpsert ? "upsert" : (serializedEntity.containsKey(DEFAULT_OBJECT_ID_FIELD) && serializedEntity.get(DEFAULT_OBJECT_ID_FIELD) != null ? "update" : "create");
            Object newEntity = Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, method, new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), serializedEntity}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity.getClass()));
            if (serializedEntity.get(DEFAULT_OBJECT_ID_FIELD) == null) {
                FootprintsManager.getInstance().Inner.duplicateFootprintForObject(serializedEntity, newEntity, entity);
            } else {
                FootprintsManager.getInstance().Inner.updateFootprintForObject(serializedEntity, newEntity, entity);
            }
            Footprint footprint = FootprintsManager.getInstance().getEntityFootprint(newEntity);
            if (footprint != null) {
                footprint.initObjectId(entity);
            }
            Object t = newEntity;
            return (E)t;
        }
        finally {
            MessageWriter.setObjectSubstitutor(null);
        }
    }

    public <E> void save(E entity, AsyncCallback<E> responder) {
        this.save(entity, false, responder);
    }

    public <E> void save(E entity, boolean isUpsert, AsyncCallback<E> responder) {
        block6: {
            try {
                String method;
                AsyncCallback<E> callbackOverrider;
                Map<String, Object> serializedEntity = this.serializeEntityBeforeCreate(entity);
                if (isUpsert) {
                    callbackOverrider = this.getUpsertAsyncHandler(entity, serializedEntity, responder);
                    method = "upsert";
                } else if (serializedEntity.get(DEFAULT_OBJECT_ID_FIELD) == null) {
                    callbackOverrider = this.getCreateAsyncHandler(entity, serializedEntity, responder);
                    method = "create";
                } else {
                    callbackOverrider = this.getUpdateAsyncHandler(entity, serializedEntity, responder);
                    method = "save";
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, method, new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), serializedEntity}, callbackOverrider, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity.getClass()));
            }
            catch (Throwable e) {
                if (responder == null) break block6;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E> E deepSave(E entity) throws BackendlessException {
        Map<String, Object> serializedEntity = this.serializeEntityBeforeDeepSave(entity);
        try {
            Object newEntity = Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "deepSave", new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), serializedEntity}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity.getClass()));
            if (serializedEntity.get(DEFAULT_OBJECT_ID_FIELD) == null) {
                FootprintsManager.getInstance().Inner.duplicateFootprintForObject(serializedEntity, newEntity, entity);
            } else {
                FootprintsManager.getInstance().Inner.updateFootprintForObject(serializedEntity, newEntity, entity);
            }
            Footprint footprint = FootprintsManager.getInstance().getEntityFootprint(newEntity);
            if (footprint != null) {
                footprint.initObjectId(entity);
            }
            Object t = newEntity;
            return (E)t;
        }
        finally {
            MessageWriter.setObjectSubstitutor(null);
        }
    }

    public <E> void deepSave(E entity, AsyncCallback<E> responder) {
        block2: {
            try {
                Map<String, Object> serializedEntity = this.serializeEntityBeforeDeepSave(entity);
                AsyncCallback<E> callbackOverrider = serializedEntity.get(DEFAULT_OBJECT_ID_FIELD) == null ? this.getCreateAsyncHandler(entity, serializedEntity, responder) : this.getUpdateAsyncHandler(entity, serializedEntity, responder);
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "deepSave", new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), serializedEntity}, callbackOverrider, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity.getClass()));
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public <E> E create(Class<E> aClass, Map entity) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "create", new Object[]{BackendlessSerializer.getSimpleName(aClass), entity}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(aClass));
    }

    public <E> void create(Class<E> aClass, Map entity, AsyncCallback<E> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "create", new Object[]{BackendlessSerializer.getSimpleName(aClass), entity}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(aClass));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    private <E> E update(Class<E> aClass, Map entity) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "update", new Object[]{BackendlessSerializer.getSimpleName(aClass), entity}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(aClass));
    }

    private <E> void update(Class<E> aClass, Map entity, AsyncCallback<E> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "update", new Object[]{BackendlessSerializer.getSimpleName(aClass), entity}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(aClass));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> Long remove(E entity) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        Map<String, Object> entityMap = BackendlessSerializer.serializeToMap(entity);
        FootprintsManager.getInstance().Inner.putMissingPropsToEntityMap(entity, entityMap);
        Object result = Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "remove", new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), entityMap});
        FootprintsManager.getInstance().Inner.removeFootprintForObject(entityMap, entity);
        return ((Number)result).longValue();
    }

    protected <E> void remove(final E entity, final AsyncCallback<Long> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                AsyncCallback<Object> removalCallback = new AsyncCallback<Object>(){

                    @Override
                    public void handleResponse(Object response) {
                        FootprintsManager.getInstance().Inner.removeFootprintForObject(BackendlessSerializer.serializeToMap(entity), entity);
                        if (responder == null) {
                            return;
                        }
                        responder.handleResponse(((Number)response).longValue());
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                };
                Map<String, Object> entityMap = BackendlessSerializer.serializeToMap(entity);
                FootprintsManager.getInstance().Inner.putMissingPropsToEntityMap(entity, entityMap);
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "remove", new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), entityMap}, removalCallback);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    int remove(String entityName, String whereClause) throws BackendlessException {
        Object[] args = new Object[]{entityName, whereClause};
        return (Integer)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "removeBulk", args);
    }

    void remove(String entityName, String whereClause, AsyncCallback<Integer> responder) throws BackendlessException {
        Object[] args = new Object[]{entityName, whereClause};
        Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "removeBulk", args, responder);
    }

    int update(String entityName, String whereClause, Map<String, Object> changes) throws BackendlessException {
        Object[] args = new Object[]{entityName, whereClause, changes};
        return (Integer)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "updateBulk", args);
    }

    void update(String entityName, String whereClause, Map<String, Object> changes, AsyncCallback<Integer> responder) throws BackendlessException {
        Object[] args = new Object[]{entityName, whereClause, changes};
        Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "updateBulk", args, responder);
    }

    protected <E> E findById(Class<E> entity, String id, List<String> relations) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity name cannot be null or empty.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null or empty.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", new Object[]{BackendlessSerializer.getSimpleName(entity), id, relations}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
    }

    protected <E> E findById(Class<E> entity, String id, List<String> relations, Integer relationsDepth) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity name cannot be null or empty.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null or empty.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", new Object[]{BackendlessSerializer.getSimpleName(entity), id, relations, relationsDepth}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
    }

    protected <E> E findById(E entity, List<String> relations, Integer relationsDepth) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        E entityArg = ReflectionUtil.hasField(entity.getClass(), DEFAULT_OBJECT_ID_FIELD) ? entity : FootprintsManager.getInstance().getObjectId(entity);
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), entityArg, relations, relationsDepth}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity.getClass()));
    }

    protected <E> E findById(E entity, DataQueryBuilder queryBuilder) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        if (queryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
        }
        E entityArg = ReflectionUtil.hasField(entity.getClass(), DEFAULT_OBJECT_ID_FIELD) ? entity : FootprintsManager.getInstance().getObjectId(entity);
        Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), entityArg, queryBuilder.build()};
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", args, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity.getClass()));
    }

    protected <E> E findById(Class<E> entity, String id, DataQueryBuilder queryBuilder) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity name cannot be null or empty.");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null or empty.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", new Object[]{BackendlessSerializer.getSimpleName(entity), id, queryBuilder.build()}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
    }

    protected <E> void findById(Class<E> entity, String id, List<String> relations, AsyncCallback<E> responder) {
        block4: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                if (id == null) {
                    throw new IllegalArgumentException("Id cannot be null or empty.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", new Object[]{BackendlessSerializer.getSimpleName(entity), id, relations}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> void findById(Class<E> entity, String id, List<String> relations, Integer relationsDepth, AsyncCallback<E> responder) {
        block4: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                if (id == null) {
                    throw new IllegalArgumentException("Id cannot be null or empty.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", new Object[]{BackendlessSerializer.getSimpleName(entity), id, relations, relationsDepth}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> void findById(E entity, List<String> relations, Integer relationsDepth, AsyncCallback<E> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                AdaptingResponder chainedResponder = new AdaptingResponder(entity.getClass(), new PoJoAdaptingPolicy());
                E entityArg = ReflectionUtil.hasField(entity.getClass(), DEFAULT_OBJECT_ID_FIELD) ? entity : FootprintsManager.getInstance().getObjectId(entity);
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), entityArg, relations, relationsDepth}, responder, chainedResponder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> void findById(E entity, DataQueryBuilder queryBuilder, AsyncCallback<E> responder) {
        block4: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                if (queryBuilder == null) {
                    throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
                }
                E entityArg = ReflectionUtil.hasField(entity.getClass(), DEFAULT_OBJECT_ID_FIELD) ? entity : FootprintsManager.getInstance().getObjectId(entity);
                Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity.getClass()), entityArg, queryBuilder.build()};
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", args, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity.getClass()));
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> void findById(Class<E> entity, String id, DataQueryBuilder queryBuilder, AsyncCallback<E> responder) {
        block4: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity name cannot be null or empty.");
                }
                if (id == null) {
                    throw new IllegalArgumentException("Id cannot be null or empty.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "findById", new Object[]{BackendlessSerializer.getSimpleName(entity), id, queryBuilder.build()}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public <T> List<T> loadRelations(String parentType, String objectId, LoadRelationsQueryBuilder queryBuilder, Class<T> relatedType) throws BackendlessException {
        StringUtils.checkEmpty(objectId, "Entity cannot be null.");
        if (queryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
        }
        BackendlessDataQuery dataQuery = queryBuilder.build();
        String relationName = dataQuery.getQueryOptions().getRelated().iterator().next();
        Object[] args = new Object[]{parentType, objectId, relationName, dataQuery};
        return (List)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "loadRelations", args, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(relatedType));
    }

    public <T> void loadRelations(String parentType, String objectId, LoadRelationsQueryBuilder queryBuilder, Class<T> relatedType, AsyncCallback<List<T>> responder) {
        block3: {
            StringUtils.checkEmpty(objectId, "Entity cannot be null.");
            if (queryBuilder == null) {
                throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
            }
            BackendlessDataQuery dataQuery = queryBuilder.build();
            String relationName = dataQuery.getQueryOptions().getRelated().iterator().next();
            int pageSize = dataQuery.getPageSize();
            int offset = dataQuery.getOffset();
            try {
                Object[] args = new Object[]{parentType, objectId, relationName, pageSize, offset};
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "loadRelations", args, responder, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(relatedType));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    private <E> void loadRelationsToEntity(E entity, E loadedRelations, List<String> relations) {
        if (entity.getClass().equals(BackendlessUser.class)) {
            BackendlessUser userWithRelations = (BackendlessUser)loadedRelations;
            BackendlessUser sourceUser = (BackendlessUser)entity;
            sourceUser.putProperties(userWithRelations.getProperties());
        } else {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = entity.getClass().getDeclaredFields()) {
                if (!relations.contains(declaredField.getName())) continue;
                if (!declaredField.isAccessible()) {
                    declaredField.setAccessible(true);
                }
                try {
                    Object fieldValue = declaredField.get(loadedRelations);
                    declaredField.set(entity, fieldValue);
                }
                catch (IllegalAccessException e) {
                    String message = String.format("Field %s is not accessible", declaredField.getName()) + ": " + e.getMessage();
                    throw new BackendlessException(message);
                }
            }
        }
    }

    public List<ObjectProperty> describe(String classSimpleName) throws BackendlessException {
        if (classSimpleName == null || classSimpleName.equals("")) {
            throw new IllegalArgumentException("Entity name cannot be null or empty.");
        }
        ObjectProperty[] response = (ObjectProperty[])Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "describe", new Object[]{classSimpleName});
        return Arrays.asList(response);
    }

    public void describe(String classSimpleName, final AsyncCallback<List<ObjectProperty>> responder) {
        block3: {
            try {
                if (classSimpleName == null || classSimpleName.equals("")) {
                    throw new IllegalArgumentException("Entity name cannot be null or empty.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "describe", new Object[]{classSimpleName}, new AsyncCallback<ObjectProperty[]>(){

                    @Override
                    public void handleResponse(ObjectProperty[] response) {
                        if (responder != null) {
                            responder.handleResponse(Arrays.asList(response));
                        }
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public <E> List<E> find(Class<E> entity, DataQueryBuilder queryBuilder) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        if (queryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
        }
        Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity), queryBuilder.build()};
        return (List)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "find", args, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(entity));
    }

    public <E> void find(Class<E> entity, DataQueryBuilder queryBuilder, AsyncCallback<List<E>> responder) {
        block4: {
            if (entity == null) {
                throw new IllegalArgumentException("Entity cannot be null.");
            }
            if (queryBuilder == null) {
                throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
            }
            BackendlessDataQuery dataQuery = queryBuilder.build();
            try {
                Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity), dataQuery};
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "find", args, responder, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public <E> GroupResult<?, E> group(Class<E> entity, GroupDataQueryBuilder queryBuilder) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        if (queryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
        }
        Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity), queryBuilder.build()};
        return (GroupResult)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "group", args, (IChainedResponder)ResponderHelper.getGroupResultAdaptingResponder(entity));
    }

    public <E> void group(Class<E> entity, GroupDataQueryBuilder queryBuilder, AsyncCallback<GroupResult<?, E>> responder) {
        block4: {
            if (entity == null) {
                throw new IllegalArgumentException("Entity cannot be null.");
            }
            if (queryBuilder == null) {
                throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
            }
            BackendlessGroupDataQuery dataQuery = queryBuilder.build();
            try {
                Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity), dataQuery};
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "group", args, responder, (IChainedResponder)ResponderHelper.getGroupResultAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> E first(Class<E> entity) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "first", new Object[]{BackendlessSerializer.getSimpleName(entity)}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
    }

    protected <E> E first(Class<E> entity, List<String> relations, Integer relationsDepth, Integer relationsPageSize) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "first", new Object[]{BackendlessSerializer.getSimpleName(entity), relations, relationsDepth, new ArrayList(), relationsPageSize}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
    }

    protected <E> void first(Class<E> entity, AsyncCallback<E> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "first", new Object[]{BackendlessSerializer.getSimpleName(entity)}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> void first(Class<E> entity, List<String> relations, Integer relationsDepth, Integer relationsPageSize, AsyncCallback<E> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "first", new Object[]{BackendlessSerializer.getSimpleName(entity), relations, relationsDepth, new ArrayList(), relationsPageSize}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> E last(Class<E> entity) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "last", new Object[]{BackendlessSerializer.getSimpleName(entity)}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
    }

    protected <E> E last(Class<E> entity, List<String> relations, Integer relationsDepth, Integer relationsPageSize) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        return (E)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "last", new Object[]{BackendlessSerializer.getSimpleName(entity), relations, relationsDepth, new ArrayList(), relationsPageSize}, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
    }

    protected <E> void last(Class<E> entity, AsyncCallback<E> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "last", new Object[]{BackendlessSerializer.getSimpleName(entity)}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    protected <E> void last(Class<E> entity, List<String> relations, Integer relationsDepth, Integer relationsPageSize, AsyncCallback<E> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "last", new Object[]{BackendlessSerializer.getSimpleName(entity), relations, relationsDepth, new ArrayList(), relationsPageSize}, responder, (IChainedResponder)ResponderHelper.getPOJOAdaptingResponder(entity));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public IDataStore<Map> of(String tableName) {
        return new MapDrivenDataStore(tableName, this, this.injector.getEventHandlerFactory().of(tableName));
    }

    public <E> IDataStore<E> of(Class<E> entityClass) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        if (entityClass.getName().contains("$")) {
            throw new IllegalArgumentException("Cannot use inner or anonymous classes. Make sure the class is public. It cannot be inner or anonymous");
        }
        try {
            Constructor<E> defaultConstructor = entityClass.getConstructor(new Class[0]);
            if (defaultConstructor == null || !Modifier.isPublic(defaultConstructor.getModifiers())) {
                throw new IllegalArgumentException("Missing public, default no-argument constructor");
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Missing public, default no-argument constructor");
        }
        return new DataStore<E>(entityClass, this, this.injector.getEventHandlerFactory().of(entityClass));
    }

    public static String getEntityId(Object entity) throws BackendlessException {
        String id = null;
        if (entity instanceof Map) {
            return (String)((Map)entity).get(DEFAULT_OBJECT_ID_FIELD);
        }
        if (ReflectionUtil.hasField(entity.getClass(), DEFAULT_OBJECT_ID_FIELD)) {
            try {
                Field field = ReflectionUtil.getField(entity.getClass(), DEFAULT_OBJECT_ID_FIELD);
                field.setAccessible(true);
                id = (String)field.get(entity);
            }
            catch (IllegalAccessException | NoSuchFieldException field) {}
        } else {
            try {
                Method declaredMethod = entity.getClass().getMethod(DEFAULT_OBJECT_ID_GETTER, new Class[0]);
                if (!declaredMethod.isAccessible()) {
                    declaredMethod.setAccessible(true);
                }
                id = (String)declaredMethod.invoke(entity, new Object[0]);
            }
            catch (Exception e) {
                id = null;
            }
        }
        if (id == null) {
            id = FootprintsManager.getInstance().getObjectId(entity);
        }
        return id;
    }

    <E> int getObjectCount(Class<E> entity) {
        Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity)};
        return (Integer)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "count", args);
    }

    <E> int getObjectCount(Class<E> entity, DataQueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
        }
        BackendlessDataQuery dataQuery = queryBuilder.build();
        Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity), dataQuery};
        return (Integer)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "count", args);
    }

    <E> void getObjectCount(Class<E> entity, AsyncCallback<Integer> responder) {
        block2: {
            try {
                Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity)};
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "count", args, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    <E> void getObjectCount(Class<E> entity, DataQueryBuilder queryBuilder, AsyncCallback<Integer> responder) {
        block3: {
            if (queryBuilder == null) {
                throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
            }
            BackendlessDataQuery dataQuery = queryBuilder.build();
            try {
                Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity), dataQuery};
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "count", args, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    <E> int getObjectCountInGroup(Class<E> entity, GroupDataQueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
        }
        BackendlessGroupDataQuery dataQuery = queryBuilder.build();
        Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity), dataQuery};
        return (Integer)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "countInGroup", args);
    }

    <E> void getObjectCountInGroup(Class<E> entity, GroupDataQueryBuilder queryBuilder, AsyncCallback<Integer> responder) {
        block3: {
            if (queryBuilder == null) {
                throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
            }
            BackendlessGroupDataQuery dataQuery = queryBuilder.build();
            try {
                Object[] args = new Object[]{BackendlessSerializer.getSimpleName(entity), dataQuery};
                Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "countInGroup", args, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    private <T> void checkDeclaredType(Class<T> entityClass) {
        if (entityClass.isArray() || entityClass.isAssignableFrom(Iterable.class) || entityClass.isAssignableFrom(Map.class)) {
            throw new IllegalArgumentException("Wrong entity type");
        }
        try {
            Constructor<?>[] constructors = entityClass.getConstructors();
            if (constructors.length > 0) {
                entityClass.getConstructor(new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Missing public, default no-argument constructor");
        }
    }

    public List<Map<String, Object>> getView(String viewName, DataQueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
        }
        BackendlessDataQuery dataQuery = queryBuilder.build();
        Object[] args = new Object[]{viewName, dataQuery};
        return (List)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "callStoredView", args);
    }

    public void getView(String viewName, DataQueryBuilder queryBuilder, AsyncCallback<Map<String, Object>> responder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("queryBuilder"));
        }
        BackendlessDataQuery dataQuery = queryBuilder.build();
        Object[] args = new Object[]{viewName, dataQuery};
        Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "callStoredView", args, responder);
    }

    public List<Map> callStoredProcedure(String spName, Map<String, Object> arguments) {
        Object[] args = new Object[]{spName, arguments};
        return (List)Invoker.invokeSync(PERSISTENCE_MANAGER_SERVER_ALIAS, "callStoredProcedure", args, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(HashMap.class));
    }

    public void callStoredProcedure(String procedureName, Map<String, Object> arguments, AsyncCallback<Map> responder) {
        Object[] args = new Object[]{procedureName, arguments};
        Invoker.invokeAsync(PERSISTENCE_MANAGER_SERVER_ALIAS, "callStoredProcedure", args, responder, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(HashMap.class));
    }

    private <E> Map<String, Object> serializeEntityBeforeCreate(final E entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        this.checkDeclaredType(entity.getClass());
        final Map<String, Object> serializedEntity = BackendlessSerializer.serializeToMap(entity);
        MapEntityUtil.removeNullsAndRelations(serializedEntity);
        MessageWriter.setObjectSubstitutor((IObjectSubstitutor)new IObjectSubstitutor(){

            public Object substitute(Object o) {
                if (o == entity) {
                    return serializedEntity;
                }
                return o;
            }
        });
        return serializedEntity;
    }

    private <E> Map<String, Object> serializeEntityBeforeDeepSave(final E entity) {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        this.checkDeclaredType(entity.getClass());
        final Map<String, Object> serializedEntity = BackendlessSerializer.serializeToMap(entity);
        MessageWriter.setObjectSubstitutor((IObjectSubstitutor)new IObjectSubstitutor(){

            public Object substitute(Object o) {
                if (o == entity) {
                    return serializedEntity;
                }
                return o;
            }
        });
        return serializedEntity;
    }

    private <E> AsyncCallback<E> getUpsertAsyncHandler(final E entity, final Map<String, Object> serializedEntity, final AsyncCallback<E> responder) {
        return new AsyncCallback<E>(){

            @Override
            public void handleResponse(E newEntity) {
                Map<String, Object> serializedNewEntity = BackendlessSerializer.serializeToMap(newEntity);
                if (serializedNewEntity.get(Persistence.DEFAULT_UPDATED_FIELD) == null) {
                    MessageWriter.setObjectSubstitutor(null);
                    FootprintsManager.getInstance().Inner.duplicateFootprintForObject(serializedEntity, newEntity, entity);
                } else {
                    FootprintsManager.getInstance().Inner.updateFootprintForObject(serializedEntity, newEntity, entity);
                }
                Footprint footprint = FootprintsManager.getInstance().getEntityFootprint(newEntity);
                if (footprint != null) {
                    footprint.initObjectId(entity);
                }
                if (responder != null) {
                    responder.handleResponse(newEntity);
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                if (responder != null) {
                    responder.handleFault(fault);
                }
            }
        };
    }

    private <E> AsyncCallback<E> getCreateAsyncHandler(final E entity, final Map<String, Object> serializedEntity, final AsyncCallback<E> responder) {
        return new AsyncCallback<E>(){

            @Override
            public void handleResponse(E newEntity) {
                MessageWriter.setObjectSubstitutor(null);
                FootprintsManager.getInstance().Inner.duplicateFootprintForObject(serializedEntity, newEntity, entity);
                Footprint footprint = FootprintsManager.getInstance().getEntityFootprint(newEntity);
                if (footprint != null) {
                    footprint.initObjectId(entity);
                }
                if (responder != null) {
                    responder.handleResponse(newEntity);
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                MessageWriter.setObjectSubstitutor(null);
                if (responder != null) {
                    responder.handleFault(fault);
                }
            }
        };
    }

    private <E> AsyncCallback<E> getUpdateAsyncHandler(final E entity, final Map<String, Object> serializedEntity, final AsyncCallback<E> responder) {
        return new AsyncCallback<E>(){

            @Override
            public void handleResponse(E newEntity) {
                FootprintsManager.getInstance().Inner.updateFootprintForObject(serializedEntity, newEntity, entity);
                Footprint footprint = FootprintsManager.getInstance().getEntityFootprint(newEntity);
                if (footprint != null) {
                    footprint.initObjectId(entity);
                }
                if (responder != null) {
                    responder.handleResponse(newEntity);
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                if (responder != null) {
                    responder.handleFault(fault);
                }
            }
        };
    }
}

