/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.IHeadersManager;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class PlainHeadersManager
implements IHeadersManager {
    protected final ConcurrentHashMap<String, String> headers = new ConcurrentHashMap();

    protected PlainHeadersManager() {
        this.cleanHeaders();
    }

    @Override
    public void cleanHeaders() {
        this.headers.clear();
    }

    @Override
    public void addHeader(IHeadersManager.HeadersEnum headersEnum, String value) {
        this.headers.put(headersEnum.getHeader(), value);
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void addHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
    }

    @Override
    public void removeHeader(IHeadersManager.HeadersEnum headersEnum) {
        this.headers.remove(headersEnum.getHeader());
    }

    @Override
    public void removeHeader(String name) {
        this.headers.remove(name);
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.cleanHeaders();
        this.headers.putAll(headers);
    }

    @Override
    public String getHeader(IHeadersManager.HeadersEnum headersEnum) {
        return this.headers.get(headersEnum.getHeader());
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(name);
    }
}

