/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolService {
    private static final ThreadPoolService instance = new ThreadPoolService();
    private final SimpleThreadFactory THREAD_FACTORY;
    private final ThreadPoolExecutor THREAD_POOL_EXECUTOR;
    private final ScheduledThreadPoolExecutor SCHEDULED_THREAD_POOL_EXECUTOR;

    static ThreadPoolService getInstance() {
        return instance;
    }

    private ThreadPoolService() {
        if (BackendlessInjector.getInstance().isCodeRunner()) {
            this.THREAD_FACTORY = new SimpleThreadFactory("BackendlessSDK_CodeRunner");
            this.THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(1, 5, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.THREAD_FACTORY);
            this.SCHEDULED_THREAD_POOL_EXECUTOR = null;
        } else {
            this.THREAD_FACTORY = new SimpleThreadFactory("BackendlessSDK");
            this.THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(2, 10, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), this.THREAD_FACTORY);
            this.SCHEDULED_THREAD_POOL_EXECUTOR = new ScheduledThreadPoolExecutor(2, this.THREAD_FACTORY);
        }
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.THREAD_POOL_EXECUTOR;
    }

    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.SCHEDULED_THREAD_POOL_EXECUTOR;
    }

    private static class SimpleThreadFactory
    implements ThreadFactory {
        private static final ThreadGroup THREAD_GROUP = new ThreadGroup("BackendlessSDK_ThreadGroup");
        private final String threadNamePrefix;
        private final boolean isDaemon = true;
        private final AtomicInteger threadNumber = new AtomicInteger();

        public SimpleThreadFactory(String poolName) {
            this.threadNamePrefix = "pool-" + poolName + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(THREAD_GROUP, runnable, this.threadNamePrefix + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }
}

