/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.async.callback.UploadCallback;
import com.backendless.async.message.AsyncMessage;
import com.backendless.async.message.AsyncUploadMessage;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.files.BackendlessFile;
import com.backendless.files.router.FileOutputStreamRouter;
import java.io.File;

class UploadFileAsyncTask {
    private final BackendlessInjector injector = BackendlessInjector.getInstance();
    private UploadCallback uploadCallback;
    private AsyncCallback<BackendlessFile> responder;
    private boolean overwrite;

    UploadFileAsyncTask() {
    }

    void executeThis(File file, String path, UploadCallback uploadCallback, AsyncCallback<BackendlessFile> responder) {
        this.executeThis(file, path, false, uploadCallback, responder);
    }

    void executeThis(File file, String path, boolean overwrite, UploadCallback uploadCallback, AsyncCallback<BackendlessFile> responder) {
        this.uploadCallback = uploadCallback;
        this.responder = responder;
        this.overwrite = overwrite;
        this.doInBackground(file, path);
    }

    private void doInBackground(final File file, final String path) {
        final AsyncUploadMessage asyncUploadMessage = new AsyncUploadMessage(this.uploadCallback);
        this.injector.getThreadPoolService().getThreadPoolExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FileOutputStreamRouter fileOutputStreamRouter = new FileOutputStreamRouter(file, new UploadCallback(){

                        @Override
                        public void onProgressUpdate(Integer progress) {
                            asyncUploadMessage.setCurrentProgress(progress);
                            UploadFileAsyncTask.this.injector.getHandleCarrier().deliverMessage(asyncUploadMessage);
                        }
                    });
                    BackendlessFile result = UploadFileAsyncTask.this.injector.getFiles().uploadFromStream(fileOutputStreamRouter, file.getName(), path, UploadFileAsyncTask.this.overwrite);
                    UploadFileAsyncTask.this.injector.getHandleCarrier().deliverMessage(new AsyncMessage<BackendlessFile>(result, UploadFileAsyncTask.this.responder));
                }
                catch (Exception e) {
                    UploadFileAsyncTask.this.injector.getHandleCarrier().deliverMessage(new AsyncMessage(new BackendlessFault(e), UploadFileAsyncTask.this.responder));
                }
            }
        });
    }
}

