/*
 * Decompiled with CFR 0.152.
 */
package com.backendless;

import com.backendless.BackendlessInjector;
import com.backendless.BackendlessUser;
import com.backendless.IHeadersManager;
import com.backendless.Invoker;
import com.backendless.UserServiceAndroidExtra;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.commons.user.UserStatusEnum;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.core.responder.policy.BackendlessUserAdaptingPolicy;
import com.backendless.exceptions.BackendlessException;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.persistence.BackendlessSerializer;
import com.backendless.persistence.DataQueryBuilder;
import com.backendless.property.AbstractProperty;
import com.backendless.property.UserProperty;
import com.backendless.utils.ResponderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weborb.client.IChainedResponder;
import weborb.types.Types;

public final class UserService {
    private static final String USER_STATUS_COLUMN = "userStatus";
    static final String USER_MANAGER_SERVER_ALIAS = "com.backendless.services.users.UserService";
    private static BackendlessUser currentUser = new BackendlessUser();
    private static final Object currentUserLock = new Object();
    public static final String USERS_TABLE_NAME = "Users";
    private static final UserService instance = new UserService();
    private final BackendlessInjector injector = BackendlessInjector.getInstance();

    static UserService getInstance() {
        return instance;
    }

    private UserService() {
        Types.addClientClassMapping((String)"com.backendless.services.users.property.AbstractProperty", AbstractProperty.class);
        Types.addClientClassMapping((String)"com.backendless.services.users.property.UserProperty", UserProperty.class);
        Types.addClientClassMapping((String)USERS_TABLE_NAME, BackendlessUser.class);
    }

    public BackendlessUser CurrentUser() {
        if (currentUser != null && currentUser.isEmpty()) {
            return null;
        }
        return currentUser;
    }

    public BackendlessUser CurrentUser(boolean reload) {
        if (reload) {
            if (currentUser != null && currentUser.getObjectId() != null && !currentUser.getObjectId().isEmpty()) {
                currentUser = this.injector.getUserService().findById(currentUser.getObjectId());
                return currentUser;
            }
            return null;
        }
        return this.CurrentUser();
    }

    public void CurrentUser(boolean reload, final AsyncCallback<BackendlessUser> responder) {
        if (reload) {
            if (currentUser != null && currentUser.getObjectId() != null && !currentUser.getObjectId().isEmpty()) {
                this.findById(currentUser.getObjectId(), new AsyncCallback<BackendlessUser>(){

                    @Override
                    public void handleResponse(BackendlessUser response) {
                        currentUser = response;
                        responder.handleResponse(response);
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            } else {
                responder.handleResponse(null);
            }
        } else {
            responder.handleResponse(this.CurrentUser());
        }
    }

    private UserServiceAndroidExtra getUserServiceAndroidExtra() {
        if (!this.injector.isAndroid()) {
            throw new RuntimeException("Operation may be performed only from an Android environment");
        }
        return UserServiceAndroidExtra.getInstance();
    }

    public BackendlessUser register(BackendlessUser user) throws BackendlessException {
        UserService.checkUserToBeProper(user);
        BackendlessSerializer.serializeUserProperties(user);
        String password = user.getPassword();
        BackendlessUser userToReturn = (BackendlessUser)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "register", new Object[]{user.getProperties()}, new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy()));
        user.clearProperties();
        userToReturn.setPassword(password);
        user.putProperties(userToReturn.getProperties());
        return userToReturn;
    }

    public void register(final BackendlessUser user, final AsyncCallback<BackendlessUser> responder) {
        block2: {
            try {
                UserService.checkUserToBeProper(user);
                BackendlessSerializer.serializeUserProperties(user);
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "register", new Object[]{user.getProperties()}, new AsyncCallback<BackendlessUser>(){

                    @Override
                    public void handleResponse(BackendlessUser response) {
                        response.setPassword(user.getPassword());
                        user.clearProperties();
                        user.putProperties(response.getProperties());
                        if (responder != null) {
                            responder.handleResponse(response);
                        }
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                }, new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy()));
            }
            catch (BackendlessException e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public BackendlessUser update(BackendlessUser user) throws BackendlessException {
        UserService.checkUserToBeProperForUpdate(user);
        BackendlessSerializer.serializeUserProperties(user);
        if (user.getUserId() != null && user.getUserId().equals("")) {
            throw new IllegalArgumentException("User not logged in or wrong user id.");
        }
        BackendlessUser userToReturn = (BackendlessUser)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "update", new Object[]{user.getProperties()}, new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy()));
        user.clearProperties();
        user.putProperties(userToReturn.getProperties());
        return userToReturn;
    }

    public void update(final BackendlessUser user, final AsyncCallback<BackendlessUser> responder) {
        block3: {
            try {
                UserService.checkUserToBeProperForUpdate(user);
                BackendlessSerializer.serializeUserProperties(user);
                if (user.getUserId() != null && user.getUserId().equals("")) {
                    throw new IllegalArgumentException("User not logged in or wrong user id.");
                }
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "update", new Object[]{user.getProperties()}, new AsyncCallback<BackendlessUser>(){

                    @Override
                    public void handleResponse(BackendlessUser response) {
                        user.clearProperties();
                        user.putProperties(response.getProperties());
                        if (responder != null) {
                            responder.handleResponse(response);
                        }
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                }, new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy()));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public BackendlessUser login(String login, String password) throws BackendlessException {
        return this.login(login, password, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendlessUser login(String login, String password, boolean stayLoggedIn) throws BackendlessException {
        Object object = currentUserLock;
        synchronized (object) {
            if (currentUser != null && !currentUser.isEmpty()) {
                this.logout();
            }
            if (login == null || login.equals("")) {
                throw new IllegalArgumentException("User login cannot be null or empty.");
            }
            if (password == null || password.equals("")) {
                throw new IllegalArgumentException("User password cannot be null or empty.");
            }
            this.handleUserLogin((BackendlessUser)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "login", new Object[]{login, password}, new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy())), stayLoggedIn);
            return currentUser;
        }
    }

    public BackendlessUser login(String objectId) throws BackendlessException {
        return this.login(objectId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendlessUser login(String objectId, boolean stayLoggedIn) throws BackendlessException {
        Object object = currentUserLock;
        synchronized (object) {
            if (currentUser != null && !currentUser.isEmpty()) {
                this.logout();
            }
            if (objectId == null || objectId.equals("")) {
                throw new IllegalArgumentException("Id cannot be null or empty.");
            }
            this.handleUserLogin((BackendlessUser)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "login", new Object[]{objectId}, new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy())), stayLoggedIn);
            return currentUser;
        }
    }

    public void login(String login, String password, AsyncCallback<BackendlessUser> responder) {
        this.login(login, password, responder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(final String login, final String password, final AsyncCallback<BackendlessUser> responder, final boolean stayLoggedIn) {
        block9: {
            if (currentUser != null && !currentUser.isEmpty()) {
                this.logout(new AsyncCallback<Void>(){

                    @Override
                    public void handleResponse(Void response) {
                        UserService.this.login(login, password, responder, stayLoggedIn);
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            } else {
                try {
                    Object object = currentUserLock;
                    synchronized (object) {
                        if (login == null || login.equals("")) {
                            throw new IllegalArgumentException("User login cannot be null or empty.");
                        }
                        if (password == null || password.equals("")) {
                            throw new IllegalArgumentException("User password cannot be null or empty.");
                        }
                        Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "login", new Object[]{login, password}, this.getUserLoginAsyncHandler(responder, stayLoggedIn), new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy()));
                    }
                }
                catch (Throwable e) {
                    if (responder == null) break block9;
                    responder.handleFault(new BackendlessFault(e));
                }
            }
        }
    }

    public void login(String objectId, AsyncCallback<BackendlessUser> responder) {
        this.login(objectId, responder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void login(final String objectId, final AsyncCallback<BackendlessUser> responder, final boolean stayLoggedIn) {
        block8: {
            if (currentUser != null && !currentUser.isEmpty()) {
                this.logout(new AsyncCallback<Void>(){

                    @Override
                    public void handleResponse(Void response) {
                        UserService.this.login(objectId, responder, stayLoggedIn);
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            } else {
                try {
                    Object object = currentUserLock;
                    synchronized (object) {
                        if (objectId == null || objectId.equals("")) {
                            throw new IllegalArgumentException("User login cannot be null or empty.");
                        }
                        Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "login", new Object[]{objectId}, this.getUserLoginAsyncHandler(responder, stayLoggedIn), new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy()));
                    }
                }
                catch (Throwable e) {
                    if (responder == null) break block8;
                    responder.handleFault(new BackendlessFault(e));
                }
            }
        }
    }

    public void loginWithOAuth2(String authProviderCode, String accessToken, Map<String, String> fieldsMappings, AsyncCallback<BackendlessUser> responder, boolean stayLoggedIn) {
        AsyncCallback<BackendlessUser> internalResponder = this.getUserLoginAsyncHandler(responder, stayLoggedIn);
        this.getUserServiceAndroidExtra().loginWithOAuth2(authProviderCode, accessToken, null, fieldsMappings, internalResponder);
    }

    public void loginWithOAuth2(String authProviderCode, String accessToken, BackendlessUser guestUser, Map<String, String> fieldsMappings, AsyncCallback<BackendlessUser> responder, boolean stayLoggedIn) {
        AsyncCallback<BackendlessUser> internalResponder = this.getUserLoginAsyncHandler(responder, stayLoggedIn);
        this.getUserServiceAndroidExtra().loginWithOAuth2(authProviderCode, accessToken, guestUser, fieldsMappings, internalResponder);
    }

    public void loginWithOAuth1(String authProviderCode, String authToken, String authTokenSecret, Map<String, String> fieldsMappings, AsyncCallback<BackendlessUser> responder, boolean stayLoggedIn) {
        AsyncCallback<BackendlessUser> internalResponder = this.getUserLoginAsyncHandler(responder, stayLoggedIn);
        this.getUserServiceAndroidExtra().loginWithOAuth1(authProviderCode, authToken, null, authTokenSecret, fieldsMappings, internalResponder);
    }

    public void loginWithOAuth1(String authProviderCode, String authToken, String authTokenSecret, BackendlessUser guestUser, Map<String, String> fieldsMappings, AsyncCallback<BackendlessUser> responder, boolean stayLoggedIn) {
        AsyncCallback<BackendlessUser> internalResponder = this.getUserLoginAsyncHandler(responder, stayLoggedIn);
        this.getUserServiceAndroidExtra().loginWithOAuth1(authProviderCode, authToken, guestUser, authTokenSecret, fieldsMappings, internalResponder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() throws BackendlessException {
        Object object = currentUserLock;
        synchronized (object) {
            block5: {
                try {
                    Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "logout", new Object[0]);
                }
                catch (BackendlessException fault) {
                    if (this.isLogoutFaultAllowed(fault.getCode())) break block5;
                    throw fault;
                }
            }
            this.handleLogout();
        }
    }

    private void handleLogout() {
        currentUser = new BackendlessUser();
        this.injector.getHeadersManager().removeHeader(IHeadersManager.HeadersEnum.USER_TOKEN_KEY);
        this.injector.getUserTokenStorage().set("");
        this.injector.getUserIdStorage().set("");
        this.injector.getRtClient().userLoggedOut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout(final AsyncCallback<Void> responder) {
        Object object = currentUserLock;
        synchronized (object) {
            Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "logout", new Object[0], new AsyncCallback<Void>(){

                @Override
                public void handleResponse(Void response) {
                    block3: {
                        try {
                            UserService.this.handleLogout();
                        }
                        catch (Throwable e) {
                            if (responder == null) break block3;
                            responder.handleFault(new BackendlessFault(e));
                        }
                    }
                    if (responder != null) {
                        responder.handleResponse(response);
                    }
                }

                @Override
                public void handleFault(BackendlessFault fault) {
                    if (UserService.this.isLogoutFaultAllowed(fault.getCode())) {
                        this.handleResponse(null);
                        return;
                    }
                    if (responder != null) {
                        responder.handleFault(fault);
                    }
                }
            });
        }
    }

    public void enableUser(String userId) {
        this.changeUserStatus(userId, UserStatusEnum.ENABLED);
    }

    public void enableUser(String userId, AsyncCallback<Void> responder) {
        this.changeUserStatus(userId, UserStatusEnum.ENABLED, responder);
    }

    public void disableUser(String userId) {
        this.changeUserStatus(userId, UserStatusEnum.DISABLED);
    }

    public void disableUser(String userId, AsyncCallback<Void> responder) {
        this.changeUserStatus(userId, UserStatusEnum.DISABLED, responder);
    }

    public void restorePassword(String identity) throws BackendlessException {
        if (identity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "restorePassword", new Object[]{identity});
    }

    public void restorePassword(String identity, AsyncCallback<Void> responder) {
        block3: {
            try {
                if (identity == null) {
                    throw new IllegalArgumentException("Identity cannot be null");
                }
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "restorePassword", new Object[]{identity}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public boolean verifyPassword(String password) {
        if (password == null || password.isEmpty()) {
            throw new IllegalArgumentException("User password cannot be null or empty.");
        }
        String userToken = this.injector.getUserTokenStorage().get();
        if (userToken == null || userToken.isEmpty()) {
            throw new IllegalArgumentException("No existing user token. In order to check password you have to be logged in.");
        }
        this.injector.getHeadersManager().addHeader(IHeadersManager.HeadersEnum.USER_TOKEN_KEY, userToken);
        return (Boolean)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "verifyPassword", new Object[]{password});
    }

    public String createEmailConfirmationURL(String identity) {
        if (identity == null || identity.isEmpty()) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        return (String)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "createEmailConfirmationURL", new Object[]{identity});
    }

    public void createEmailConfirmationURL(String identity, AsyncCallback<String> responder) {
        block3: {
            try {
                if (identity == null || identity.isEmpty()) {
                    throw new IllegalArgumentException("Identity cannot be null");
                }
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "createEmailConfirmationURL", new Object[]{identity}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public void resendEmailConfirmation(String identity) throws BackendlessException {
        if (identity == null || identity.isEmpty()) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "resendEmailConfirmation", new Object[]{identity});
    }

    public void resendEmailConfirmation(String identity, AsyncCallback<Void> responder) {
        block3: {
            try {
                if (identity == null || identity.isEmpty()) {
                    throw new IllegalArgumentException("Identity cannot be null");
                }
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "resendEmailConfirmation", new Object[]{identity}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public BackendlessUser findById(String id) throws BackendlessException {
        if (id == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        return (BackendlessUser)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "findById", new Object[]{id, new ArrayList()});
    }

    public void findById(String id, final AsyncCallback<BackendlessUser> responder) {
        block3: {
            try {
                if (id == null) {
                    throw new IllegalArgumentException("Identity cannot be null");
                }
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "findById", new Object[]{id, new ArrayList()}, new AsyncCallback<BackendlessUser>(){

                    @Override
                    public void handleResponse(BackendlessUser response) {
                        if (responder != null) {
                            responder.handleResponse(response);
                        }
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public void assignRole(String identity, String roleName) throws BackendlessException {
        if (identity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        if (roleName == null || roleName.equals("")) {
            throw new IllegalArgumentException("Role name cannot be null or empty");
        }
        Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "assignRole", new Object[]{identity, roleName});
    }

    public void assignRole(String identity, String roleName, AsyncCallback<Void> responder) {
        block4: {
            try {
                if (identity == null) {
                    throw new IllegalArgumentException("Identity cannot be null");
                }
                if (roleName == null || roleName.equals("")) {
                    throw new IllegalArgumentException("Role name cannot be null or empty");
                }
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "assignRole", new Object[]{identity, roleName}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public void unassignRole(String identity, String roleName) throws BackendlessException {
        if (identity == null) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        if (roleName == null || roleName.equals("")) {
            throw new IllegalArgumentException("Role name cannot be null or empty");
        }
        Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "unassignRole", new Object[]{identity, roleName});
    }

    public void unassignRole(String identity, String roleName, AsyncCallback<Void> responder) {
        block4: {
            try {
                if (identity == null) {
                    throw new IllegalArgumentException("Identity cannot be null");
                }
                if (roleName == null || roleName.equals("")) {
                    throw new IllegalArgumentException("Role name cannot be null or empty");
                }
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "unassignRole", new Object[]{identity, roleName}, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public List<String> getUserRoles() throws BackendlessException {
        return Arrays.asList((String[])Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "getUserRoles", new Object[0]));
    }

    public List<String> getUserRoles(String userId) {
        if (userId == null || userId.isEmpty()) {
            throw new IllegalArgumentException("Identity cannot be null");
        }
        Object[] objects = (Object[])Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "getUserRoles", new Object[]{userId});
        return objects.length == 0 ? Collections.emptyList() : Arrays.asList((String[])objects);
    }

    public void getUserRoles(final AsyncCallback<List<String>> responder) {
        block2: {
            try {
                AsyncCallback<String[]> callback = new AsyncCallback<String[]>(){

                    @Override
                    public void handleResponse(String[] response) {
                        if (responder != null) {
                            responder.handleResponse(Arrays.asList(response));
                        }
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                };
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "getUserRoles", new Object[0], callback);
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public void getUserRoles(String userId, final AsyncCallback<List<String>> responder) {
        block3: {
            try {
                if (userId == null || userId.isEmpty()) {
                    throw new IllegalArgumentException("Identity cannot be null");
                }
                AsyncCallback<Object[]> callback = new AsyncCallback<Object[]>(){

                    @Override
                    public void handleResponse(Object[] response) {
                        if (responder != null) {
                            responder.handleResponse(response.length == 0 ? Collections.emptyList() : Arrays.asList((String[])response));
                        }
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                };
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "getUserRoles", new Object[]{userId}, callback);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public List<BackendlessUser> findByRole(String roleName, boolean loadRoles, DataQueryBuilder queryBuilder) {
        if (roleName != null && roleName.isEmpty()) {
            throw new IllegalArgumentException("Role name cannot be null or empty");
        }
        return Arrays.asList((BackendlessUser[])Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "findByRole", new Object[]{roleName, loadRoles, queryBuilder.build()}));
    }

    public void findByRole(String roleName, boolean loadRoles, DataQueryBuilder queryBuilder, AsyncCallback<List<BackendlessUser>> responder) {
        block3: {
            try {
                if (roleName != null && roleName.isEmpty()) {
                    throw new IllegalArgumentException("Role name cannot be null or empty");
                }
                Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "findByRole", new Object[]{roleName, loadRoles, queryBuilder.build()}, responder, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(BackendlessUser.class));
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public List<UserProperty> describeUserClass() throws BackendlessException {
        UserProperty[] response = (UserProperty[])Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "describeUserClass", new Object[0]);
        return Arrays.asList(response);
    }

    public void describeUserClass(final AsyncCallback<List<UserProperty>> responder) {
        Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "describeUserClass", new Object[0], new AsyncCallback<UserProperty[]>(){

            @Override
            public void handleResponse(UserProperty[] response) {
                if (responder != null) {
                    responder.handleResponse(Arrays.asList(response));
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                if (responder != null) {
                    responder.handleFault(fault);
                }
            }
        });
    }

    public BackendlessUser loginAsGuest() {
        return this.loginAsGuest(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackendlessUser loginAsGuest(boolean stayLoggedIn) {
        Object object = currentUserLock;
        synchronized (object) {
            this.handleUserLogin((BackendlessUser)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "loginAsGuest", new Object[0], new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy())), stayLoggedIn);
            return currentUser;
        }
    }

    public void loginAsGuest(AsyncCallback<BackendlessUser> responder) {
        this.loginAsGuest(responder, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loginAsGuest(final AsyncCallback<BackendlessUser> responder, final boolean stayLoggedIn) {
        block7: {
            if (currentUser != null && !currentUser.isEmpty()) {
                this.logout(new AsyncCallback<Void>(){

                    @Override
                    public void handleResponse(Void response) {
                        UserService.this.loginAsGuest(responder, stayLoggedIn);
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            } else {
                try {
                    Object object = currentUserLock;
                    synchronized (object) {
                        Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "loginAsGuest", new Object[0], this.getUserLoginAsyncHandler(responder, stayLoggedIn), new AdaptingResponder<BackendlessUser>(BackendlessUser.class, new BackendlessUserAdaptingPolicy()));
                    }
                }
                catch (Throwable e) {
                    if (responder == null) break block7;
                    responder.handleFault(new BackendlessFault(e));
                }
            }
        }
    }

    public void getAuthorizationUrlLink(String authProviderCode, Map<String, String> fieldsMappings, List<String> scope, AsyncCallback<String> responder) throws BackendlessException {
        if (fieldsMappings == null) {
            fieldsMappings = new HashMap<String, String>();
        }
        if (scope == null) {
            scope = new ArrayList<String>();
        }
        Object origin = null;
        String deviceType = this.injector.getHeadersManager().getHeader(IHeadersManager.HeadersEnum.APP_TYPE_NAME);
        Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "getAuthorizationUrlLink", new Object[]{authProviderCode, origin, deviceType, fieldsMappings, scope}, responder);
    }

    public void getAuthorizationUrlLink(String authProviderCode, String callbackUrlDomain, Map<String, String> fieldsMappings, List<String> scope, AsyncCallback<String> responder) throws BackendlessException {
        if (fieldsMappings == null) {
            fieldsMappings = new HashMap<String, String>();
        }
        if (scope == null) {
            scope = new ArrayList<String>();
        }
        Object origin = null;
        String deviceType = this.injector.getHeadersManager().getHeader(IHeadersManager.HeadersEnum.APP_TYPE_NAME);
        Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "getAuthorizationUrlLink", new Object[]{authProviderCode, origin, deviceType, fieldsMappings, scope, callbackUrlDomain}, responder);
    }

    private static void checkUserToBeProper(BackendlessUser user) throws BackendlessException {
        UserService.checkUserToBeProperForUpdate(user);
        if (user.getPassword() == null || user.getPassword().equals("")) {
            throw new IllegalArgumentException("User password cannot be null or empty.");
        }
    }

    private static void checkUserToBeProperForUpdate(BackendlessUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User cannot be null or empty.");
        }
    }

    public String loggedInUser() {
        return this.injector.getUserIdStorage().get();
    }

    public void setCurrentUser(BackendlessUser user) {
        if (currentUser == null) {
            currentUser = user;
        } else {
            currentUser.setProperties(user.getProperties());
        }
    }

    private void handleUserLogin(BackendlessUser invokeResult, boolean stayLoggedIn) {
        String userToken = (String)invokeResult.getProperty(IHeadersManager.HeadersEnum.USER_TOKEN_KEY.getHeader());
        this.injector.getHeadersManager().addHeader(IHeadersManager.HeadersEnum.USER_TOKEN_KEY, userToken);
        currentUser = invokeResult;
        currentUser.removeProperty(IHeadersManager.HeadersEnum.USER_TOKEN_KEY.getHeader());
        if (stayLoggedIn) {
            this.injector.getUserTokenStorage().set(userToken);
            this.injector.getUserIdStorage().set(this.CurrentUser().getUserId());
        } else {
            this.injector.getUserTokenStorage().set("");
            this.injector.getUserIdStorage().set("");
        }
        this.injector.getRtClient().userLoggedIn(userToken);
    }

    private AsyncCallback<BackendlessUser> getUserLoginAsyncHandler(final AsyncCallback<BackendlessUser> responder, final boolean stayLoggedIn) {
        return new AsyncCallback<BackendlessUser>(){

            @Override
            public void handleResponse(BackendlessUser response) {
                block3: {
                    try {
                        UserService.this.handleUserLogin(response, stayLoggedIn);
                    }
                    catch (Throwable e) {
                        if (responder == null) break block3;
                        responder.handleFault(new BackendlessFault(e));
                    }
                }
                if (responder != null) {
                    responder.handleResponse(currentUser);
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                if (responder != null) {
                    responder.handleFault(fault);
                }
            }
        };
    }

    public boolean isValidLogin() {
        String userToken = this.injector.getUserTokenStorage().get();
        if (userToken != null && !userToken.equals("")) {
            return (Boolean)Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "isValidUserToken", new Object[]{userToken});
        }
        return this.CurrentUser() != null;
    }

    public void isValidLogin(AsyncCallback<Boolean> responder) {
        String userToken = this.injector.getUserTokenStorage().get();
        if (userToken != null && !userToken.equals("")) {
            Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "isValidUserToken", new Object[]{userToken}, responder);
        } else {
            responder.handleResponse(this.CurrentUser() != null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeUserStatus(String userId, UserStatusEnum newUserStatus) throws BackendlessException {
        Object object = currentUserLock;
        synchronized (object) {
            Invoker.invokeSync(USER_MANAGER_SERVER_ALIAS, "changeUserStatus", new Object[]{userId, newUserStatus});
            if (currentUser != null && !currentUser.isEmpty() && currentUser.getObjectId().equals(userId)) {
                currentUser.setProperty(USER_STATUS_COLUMN, newUserStatus.toString());
            }
        }
    }

    private void changeUserStatus(final String userId, final UserStatusEnum newUserStatus, final AsyncCallback<Void> responder) {
        Invoker.invokeAsync(USER_MANAGER_SERVER_ALIAS, "changeUserStatus", new Object[]{userId, newUserStatus}, new AsyncCallback<Void>(){

            @Override
            public void handleResponse(Void response) {
                if (currentUser != null && !currentUser.isEmpty() && currentUser.getObjectId().equals(userId)) {
                    currentUser.setProperty(UserService.USER_STATUS_COLUMN, newUserStatus.toString());
                }
                if (responder != null) {
                    responder.handleResponse(response);
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                if (responder != null) {
                    responder.handleFault(fault);
                }
            }
        });
    }

    private boolean isLogoutFaultAllowed(String errorCode) {
        return errorCode.equals("3064") || errorCode.equals("3091") || errorCode.equals("3090") || errorCode.equals("3023");
    }
}

