/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.async.message;

import com.backendless.async.callback.AsyncCallback;
import com.backendless.async.message.IAsyncMessage;
import com.backendless.exceptions.BackendlessFault;

public final class AsyncMessage<E>
implements IAsyncMessage<E> {
    private final IHandler handler;

    public AsyncMessage(E response, AsyncCallback<E> callback) {
        this.handler = new ResponseHandler(response, callback);
    }

    public AsyncMessage(BackendlessFault fault, AsyncCallback<E> callback) {
        this.handler = new FaultHandler(fault, callback);
    }

    @Override
    public void handleCallback() {
        this.handler.handle();
    }

    private static class FaultHandler<E>
    implements IHandler {
        private final AsyncCallback<E> callback;
        private final BackendlessFault fault;

        private FaultHandler(BackendlessFault fault, AsyncCallback<E> callback) {
            this.fault = fault;
            this.callback = callback;
        }

        @Override
        public void handle() {
            if (this.callback != null) {
                this.callback.handleFault(this.fault);
            }
        }
    }

    private static class ResponseHandler<E>
    implements IHandler {
        private final AsyncCallback<E> callback;
        private final E response;

        private ResponseHandler(E response, AsyncCallback<E> callback) {
            this.response = response;
            this.callback = callback;
        }

        @Override
        public void handle() {
            if (this.callback != null) {
                this.callback.handleResponse(this.response);
            }
        }
    }

    private static interface IHandler {
        public void handle();
    }
}

