/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.core.responder;

import com.backendless.core.responder.policy.IAdaptingPolicy;
import com.backendless.core.responder.policy.PoJoAdaptingPolicy;
import com.backendless.exceptions.BackendlessFault;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import weborb.client.Fault;
import weborb.client.IRawResponder;
import weborb.client.IResponder;
import weborb.exceptions.AdaptingException;
import weborb.reader.AnonymousObject;
import weborb.reader.NamedObject;
import weborb.reader.StringType;
import weborb.types.IAdaptingType;
import weborb.v3types.ErrMessage;

public class AdaptingResponder<E>
implements IRawResponder {
    private Class<E> clazz;
    private IResponder nextResponder;
    private IAdaptingPolicy<E> adaptingPolicy;

    public AdaptingResponder() {
        this.adaptingPolicy = new PoJoAdaptingPolicy();
    }

    public AdaptingResponder(IAdaptingPolicy<E> adaptingPolicy) {
        this.adaptingPolicy = adaptingPolicy;
    }

    public AdaptingResponder(Class<E> clazz) {
        this.clazz = clazz;
        this.adaptingPolicy = new PoJoAdaptingPolicy();
    }

    public AdaptingResponder(Class<E> clazz, IAdaptingPolicy<E> adaptingPolicy) {
        this.clazz = clazz;
        this.adaptingPolicy = adaptingPolicy;
    }

    public AdaptingResponder(Class<E> clazz, IAdaptingPolicy<E> adaptingPolicy, IResponder nextResponder) {
        this.clazz = clazz;
        this.nextResponder = nextResponder;
        this.adaptingPolicy = adaptingPolicy;
    }

    public final void responseHandler(Object adaptingType) {
        IAdaptingType type = (IAdaptingType)adaptingType;
        IAdaptingType bodyHolder = ((NamedObject)type).getTypedObject();
        if (((IAdaptingType)adaptingType).getDefaultType().equals(ErrMessage.class)) {
            if (this.nextResponder != null) {
                this.nextResponder.errorHandler((Fault)AdaptingResponder.adaptFault((AnonymousObject)bodyHolder));
            }
        } else {
            IAdaptingType entity = (IAdaptingType)((AnonymousObject)bodyHolder).getProperties().get("body");
            try {
                this.adaptingPolicy.adapt(this.clazz, entity, this.nextResponder);
            }
            catch (AdaptingException e) {
                this.errorHandler(new BackendlessFault(e));
            }
        }
    }

    public void errorHandler(Fault fault) {
        this.nextResponder.errorHandler(fault);
    }

    public void setNextResponder(IResponder nextResponder) {
        this.nextResponder = nextResponder;
    }

    IResponder getNextResponder() {
        return this.nextResponder;
    }

    Class<E> getClazz() {
        return this.clazz;
    }

    public static BackendlessFault adaptFault(AnonymousObject bodyHolder) {
        StringType faultMessage = (StringType)bodyHolder.getProperties().get("faultString");
        StringType faultDetail = (StringType)bodyHolder.getProperties().get("faultDetail");
        StringType faultCode = (StringType)bodyHolder.getProperties().get("faultCode");
        HashMap<String, Object> extendedData = new HashMap<String, Object>();
        try {
            extendedData.putAll((Map)((AnonymousObject)bodyHolder.getProperties().get("extendedData")).defaultAdapt());
        }
        catch (Exception e) {
            Logger.getLogger(AdaptingResponder.class.getName()).log(Level.WARNING, "WebOrb adapting error. {0}" + e.getMessage());
        }
        return new BackendlessFault(new Fault((String)faultMessage.defaultAdapt(), (String)faultDetail.defaultAdapt(), (String)faultCode.defaultAdapt()), extendedData);
    }
}

