/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.exceptions;

import com.backendless.exceptions.BackendlessFault;
import java.util.Map;

public class BackendlessException
extends RuntimeException {
    private static final long serialVersionUID = -7537447408166433783L;
    private BackendlessFault backendlessFault;
    private int httpStatusCode = 400;

    public BackendlessException() {
    }

    public BackendlessException(String message) {
        super(message);
        this.backendlessFault = new BackendlessFault(message);
    }

    public BackendlessException(String message, int httpStatusCode) {
        this(message);
        this.httpStatusCode = httpStatusCode;
    }

    public BackendlessException(String message, Throwable throwable) {
        super(message, throwable);
        this.backendlessFault = new BackendlessFault(message);
    }

    public BackendlessException(String message, Throwable throwable, int httpStatusCode) {
        this(message, throwable);
        this.httpStatusCode = httpStatusCode;
    }

    public BackendlessException(Throwable throwable) {
        super(throwable);
        this.backendlessFault = new BackendlessFault(throwable);
    }

    public BackendlessException(String code, String message) {
        super(message);
        this.backendlessFault = new BackendlessFault(code, message);
    }

    public BackendlessException(String code, String message, int httpStatusCode) {
        this(code, message);
        this.httpStatusCode = httpStatusCode;
    }

    public BackendlessException(BackendlessFault fault) {
        super(fault.getMessage() == null ? fault.getDetail() : fault.getMessage());
        this.backendlessFault = fault;
    }

    public String getCode() {
        return this.backendlessFault.getCode();
    }

    @Override
    public String getMessage() {
        String message = this.backendlessFault.getMessage();
        return message == null ? this.backendlessFault.getDetail() : message;
    }

    public String getDetail() {
        return this.backendlessFault.getDetail();
    }

    public Map<String, Object> getExtendedData() {
        return this.backendlessFault.getExtendedData();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{ code: '" + this.getCode() + '\'' + ", message: '" + this.getMessage() + '\'' + ", detail: '" + this.getDetail() + '\'' + ", extendedData: '" + this.getExtendedData() + '\'' + ", httpStatusCode: '" + this.getHttpStatusCode() + '\'' + " }";
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(int httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }
}

