/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.files.router;

import com.backendless.async.callback.UploadCallback;
import com.backendless.files.router.OutputStreamRouter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class FileOutputStreamRouter
implements OutputStreamRouter {
    private final File file;
    private final UploadCallback uploadCallback;
    private int lastProgress;

    public FileOutputStreamRouter(File file, UploadCallback uploadCallback) {
        this.file = file;
        this.uploadCallback = uploadCallback == null ? new DummyUploadCallback() : uploadCallback;
    }

    @Override
    public void writeStream(OutputStream out) throws IOException {
        long fileSize = this.file.length();
        byte[] buffer = new byte[8192];
        int readBytesTotal = 0;
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.file));){
            int readBytes;
            while ((readBytes = inputStream.read(buffer)) != -1) {
                out.write(buffer, 0, readBytes);
                out.flush();
                this.updateProgress(fileSize, readBytesTotal += readBytes);
            }
        }
    }

    private void updateProgress(long fileSize, double readBytesTotal) {
        int progress = (int)(readBytesTotal / (double)fileSize * 100.0);
        if (progress != this.lastProgress) {
            this.lastProgress = progress;
            this.uploadCallback.onProgressUpdate(progress);
        }
    }

    private static class DummyUploadCallback
    implements UploadCallback {
        private DummyUploadCallback() {
        }

        @Override
        public void onProgressUpdate(Integer progress) {
        }
    }
}

