/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.files.security;

import com.backendless.Invoker;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.core.responder.policy.PoJoAdaptingPolicy;
import com.backendless.files.security.FileOperation;
import com.backendless.files.security.FileRolePermission;
import com.backendless.files.security.FileUserPermission;
import com.backendless.files.security.Permission;
import com.backendless.utils.PermissionTypes;

public abstract class AbstractFilePermission {
    private static final String PERMISSION_SERVICE = "com.backendless.services.file.FileService";

    protected abstract FileOperation getOperation();

    public void grantForUser(String userId, String fileOrDirURL) {
        this.grantForUser(userId, fileOrDirURL, null);
    }

    public void grantForUser(String userId, String fileOrDirURL, AsyncCallback<Void> responder) {
        String method = "updateUserPermission";
        Object[] args = this.buildArgs(fileOrDirURL, userId, false, PermissionTypes.GRANT);
        this.serverCall(responder, method, args);
    }

    public void denyForUser(String userId, String fileOrDirURL) {
        this.denyForUser(userId, fileOrDirURL, null);
    }

    public void denyForUser(String userId, String fileOrDirURL, AsyncCallback responder) {
        String method = "updateUserPermission";
        Object[] args = this.buildArgs(fileOrDirURL, userId, false, PermissionTypes.DENY);
        this.serverCall(responder, method, args);
    }

    public void grantForRole(String roleName, String fileOrDirURL) {
        this.grantForRole(roleName, fileOrDirURL, null);
    }

    public void grantForRole(String roleName, String fileOrDirURL, AsyncCallback responder) {
        String method = "updateRolePermissions";
        Object[] args = this.buildArgs(fileOrDirURL, roleName, true, PermissionTypes.GRANT);
        this.serverCall(responder, method, args);
    }

    public void denyForRole(String roleName, String fileOrDirURL) {
        this.denyForRole(roleName, fileOrDirURL, null);
    }

    public void denyForRole(String roleName, String fileOrDirURL, AsyncCallback responder) {
        String method = "updateRolePermissions";
        Object[] args = this.buildArgs(fileOrDirURL, roleName, true, PermissionTypes.DENY);
        this.serverCall(responder, method, args);
    }

    public void grantForAllUsers(String fileOrDirURL) {
        this.grantForAllUsers(fileOrDirURL, null);
    }

    public void grantForAllUsers(String fileOrDirURL, AsyncCallback responder) {
        String method = "updatePermissionForAllUsers";
        Object[] args = this.buildArgs(fileOrDirURL, null, false, PermissionTypes.GRANT);
        this.serverCall(responder, method, args);
    }

    public void denyForAllUsers(String fileOrDirURL) {
        this.denyForAllUsers(fileOrDirURL, null);
    }

    public void denyForAllUsers(String fileOrDirURL, AsyncCallback responder) {
        String method = "updatePermissionForAllUsers";
        Object[] args = this.buildArgs(fileOrDirURL, null, false, PermissionTypes.DENY);
        this.serverCall(responder, method, args);
    }

    public void grantForAllRoles(String fileOrDirURL) {
        this.grantForAllRoles(fileOrDirURL, null);
    }

    public void grantForAllRoles(String fileOrDirURL, AsyncCallback responder) {
        String method = "updateRolePermissionsForAllRoles";
        Object[] args = this.buildArgs(fileOrDirURL, null, true, PermissionTypes.GRANT);
        this.serverCall(responder, method, args);
    }

    public void denyForAllRoles(String fileOrDirURL) {
        this.denyForAllRoles(fileOrDirURL, null);
    }

    public void denyForAllRoles(String fileOrDirURL, AsyncCallback responder) {
        String method = "updateRolePermissionsForAllRoles";
        Object[] args = this.buildArgs(fileOrDirURL, null, true, PermissionTypes.DENY);
        this.serverCall(responder, method, args);
    }

    private Object[] buildArgs(String fileOrDirURL, String principal, boolean isRole, PermissionTypes permissionType) {
        FileOperation operation = this.getOperation();
        Permission permission = isRole ? new FileRolePermission(fileOrDirURL, permissionType, operation) : new FileUserPermission(fileOrDirURL, permissionType, operation);
        if (principal != null) {
            return new Object[]{principal, permission};
        }
        return new Object[]{permission};
    }

    private void serverCall(AsyncCallback responder, String method, Object[] args) {
        if (responder == null) {
            Invoker.invokeSync(PERMISSION_SERVICE, method, args, new AdaptingResponder(null, new PoJoAdaptingPolicy()));
        } else {
            Invoker.invokeAsync(PERMISSION_SERVICE, method, args, responder, new AdaptingResponder(null, new PoJoAdaptingPolicy()));
        }
    }
}

