/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.hive.HiveGeneralWithoutStoreKey;
import com.backendless.hive.HiveGeneralWithoutStoreKeyForSet;
import com.backendless.hive.HiveGeneralWithoutStoreKeyForSortedSet;
import com.backendless.hive.HiveKeyValue;
import com.backendless.hive.HiveList;
import com.backendless.hive.HiveManagement;
import com.backendless.hive.HiveMap;
import com.backendless.hive.HiveSet;
import com.backendless.hive.HiveSortedSet;
import com.backendless.hive.StoreType;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;

public final class Hive {
    private static final WeakHashMap<String, Hive> hives = new WeakHashMap();
    private static final WeakHashMap<String, HiveList<?>> listHives = new WeakHashMap();
    private static final WeakHashMap<String, HiveSet<?>> setHives = new WeakHashMap();
    private static final WeakHashMap<String, HiveSortedSet<?>> sortedSetHives = new WeakHashMap();
    private static final WeakHashMap<String, HiveMap<?>> mapHives = new WeakHashMap();
    private static final HiveManagement hiveManagement = HiveManagement.getInstance();
    private final String hiveName;
    private final HiveKeyValue hiveKeyValue;
    private final HiveGeneralWithoutStoreKey generalKeyValueOps;
    private final HiveGeneralWithoutStoreKey generalListOps;
    private final HiveGeneralWithoutStoreKeyForSet generalSetOps;
    private final HiveGeneralWithoutStoreKeyForSortedSet generalSortedSetOps;
    private final HiveGeneralWithoutStoreKey generalMapOps;

    private Hive(String name) {
        this.hiveName = name;
        this.generalKeyValueOps = new HiveGeneralWithoutStoreKey(this.hiveName, StoreType.KeyValue, hiveManagement);
        this.hiveKeyValue = new HiveKeyValue(this.hiveName, this.generalKeyValueOps);
        this.generalListOps = new HiveGeneralWithoutStoreKey(this.hiveName, StoreType.List, hiveManagement);
        this.generalSetOps = new HiveGeneralWithoutStoreKeyForSet(this.hiveName, StoreType.Set, hiveManagement);
        this.generalSortedSetOps = new HiveGeneralWithoutStoreKeyForSortedSet(this.hiveName, StoreType.SortedSet, hiveManagement);
        this.generalMapOps = new HiveGeneralWithoutStoreKey(this.hiveName, StoreType.Map, hiveManagement);
    }

    public static Hive getOrCreate(String name) {
        Hive hive = hives.get(name);
        if (hive == null) {
            hive = new Hive(name);
            hives.put(name, hive);
        }
        return hive;
    }

    public static CompletableFuture<Set<String>> getNames() {
        return hiveManagement.getNames();
    }

    public static CompletableFuture<Void> create(String name) {
        return hiveManagement.create(name);
    }

    public static CompletableFuture<Void> rename(String name, String newName) {
        return hiveManagement.rename(name, newName);
    }

    public static CompletableFuture<Long> delete(String name) {
        return hiveManagement.delete(name);
    }

    public static CompletableFuture<Long> deleteAll() {
        return hiveManagement.deleteAll();
    }

    public HiveKeyValue KeyValueStore() {
        return this.hiveKeyValue;
    }

    public HiveGeneralWithoutStoreKey ListStore() {
        return this.generalListOps;
    }

    public HiveList<Object> ListStore(String storeKey) {
        return this.ListStore(storeKey, Object.class);
    }

    public <T> HiveList<T> ListStore(String storeKey, Class<T> tClass) {
        String hiveStoreKey = this.getComplexKey(storeKey);
        HiveList<Object> hiveList = listHives.get(hiveStoreKey);
        if (hiveList == null) {
            hiveList = new HiveList(this.hiveName, storeKey);
            listHives.put(hiveStoreKey, hiveList);
        }
        return hiveList;
    }

    public HiveGeneralWithoutStoreKeyForSet SetStore() {
        return this.generalSetOps;
    }

    public HiveSet<Object> SetStore(String storeKey) {
        return this.SetStore(storeKey, Object.class);
    }

    public <T> HiveSet<T> SetStore(String storeKey, Class<T> tClass) {
        String hiveStoreKey = this.getComplexKey(storeKey);
        HiveSet<Object> hiveSet = setHives.get(hiveStoreKey);
        if (hiveSet == null) {
            hiveSet = new HiveSet(this.hiveName, storeKey);
            setHives.put(hiveStoreKey, hiveSet);
        }
        return hiveSet;
    }

    public HiveGeneralWithoutStoreKeyForSortedSet SortedSetStore() {
        return this.generalSortedSetOps;
    }

    public HiveSortedSet<Object> SortedSetStore(String storeKey) {
        return this.SortedSetStore(storeKey, Object.class);
    }

    public <T> HiveSortedSet<T> SortedSetStore(String storeKey, Class<T> tClass) {
        String hiveStoreKey = this.getComplexKey(storeKey);
        HiveSortedSet<Object> hiveSortedSet = sortedSetHives.get(hiveStoreKey);
        if (hiveSortedSet == null) {
            hiveSortedSet = new HiveSortedSet(this.hiveName, storeKey);
            sortedSetHives.put(hiveStoreKey, hiveSortedSet);
        }
        return hiveSortedSet;
    }

    public HiveGeneralWithoutStoreKey MapStore() {
        return this.generalMapOps;
    }

    public HiveMap<Object> MapStore(String storeKey) {
        return this.MapStore(storeKey, Object.class);
    }

    public <T> HiveMap<T> MapStore(String storeKey, Class<T> tClass) {
        String hiveStoreKey = this.getComplexKey(storeKey);
        HiveMap<Object> hiveMap = mapHives.get(hiveStoreKey);
        if (hiveMap == null) {
            hiveMap = new HiveMap(this.hiveName, storeKey);
            mapHives.put(hiveStoreKey, hiveMap);
        }
        return hiveMap;
    }

    private String getComplexKey(String storeKey) {
        return this.hiveName + "-" + storeKey;
    }
}

