/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.Invoker;
import com.backendless.async.callback.BackendlessCallback;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.hive.StoreType;
import java.util.concurrent.CompletableFuture;

abstract class HiveGeneral {
    public static final String HIVE_GENERAL_KEY_ALIAS = "com.backendless.services.hive.HiveGeneralKeyService";
    protected final String hiveName;
    protected final StoreType storeType;
    protected final String storeKey;

    HiveGeneral(String hiveName, StoreType storeType, String storeKey) {
        this.hiveName = hiveName;
        this.storeType = storeType;
        this.storeKey = storeKey;
    }

    protected CompletableFuture<Long> delete() {
        return this.makeRemoteCallForGeneral("del", new AdaptingResponder<Long>(Long.class), new Object[0]);
    }

    protected CompletableFuture<Long> delete(String key) {
        return this.makeRemoteCallForGeneral("del", new AdaptingResponder<Long>(Long.class), key);
    }

    protected CompletableFuture<Boolean> rename(String newKey, boolean overwrite) {
        if (overwrite) {
            return this.makeRemoteCallForGeneral("rename", newKey).thenApply(voidNull -> true);
        }
        return this.makeRemoteCallForGeneral("renameIfNotExists", newKey);
    }

    protected CompletableFuture<Boolean> rename(String key, String newKey, boolean overwrite) {
        if (overwrite) {
            return this.makeRemoteCallForGeneral("rename", key, newKey).thenApply(voidNull -> true);
        }
        return this.makeRemoteCallForGeneral("renameIfNotExists", key, newKey);
    }

    protected CompletableFuture<Void> expireAfter(Integer ttlSeconds) {
        return this.makeRemoteCallForGeneral("expire", ttlSeconds);
    }

    protected CompletableFuture<Void> expireAfter(String key, Integer ttlSeconds) {
        return this.makeRemoteCallForGeneral("expire", key, ttlSeconds);
    }

    protected CompletableFuture<Void> expireAt(Integer unixTimeSeconds) {
        return this.makeRemoteCallForGeneral("expireAt", unixTimeSeconds);
    }

    protected CompletableFuture<Void> expireAt(String key, Integer unixTimeSeconds) {
        return this.makeRemoteCallForGeneral("expireAt", key, unixTimeSeconds);
    }

    protected CompletableFuture<Long> getExpiration() {
        return this.makeRemoteCallForGeneral("getExpirationTTL", new AdaptingResponder<Long>(Long.class), new Object[0]);
    }

    protected CompletableFuture<Long> getExpiration(String key) {
        return this.makeRemoteCallForGeneral("getExpirationTTL", new AdaptingResponder<Long>(Long.class), key);
    }

    protected CompletableFuture<Void> clearExpiration() {
        return this.makeRemoteCallForGeneral("clearExpiration", new Object[0]);
    }

    protected CompletableFuture<Void> clearExpiration(String key) {
        return this.makeRemoteCallForGeneral("clearExpiration", key);
    }

    protected CompletableFuture<Long> secondsSinceLastOperation() {
        return this.makeRemoteCallForGeneral("secondsSinceLastOperation", new AdaptingResponder<Long>(Long.class), new Object[0]);
    }

    protected CompletableFuture<Long> secondsSinceLastOperation(String key) {
        return this.makeRemoteCallForGeneral("secondsSinceLastOperation", new AdaptingResponder<Long>(Long.class), key);
    }

    protected <T> CompletableFuture<T> makeRemoteCallForGeneral(String methodName, Object ... args) {
        return this.makeRemoteCallForGeneral(methodName, null, args);
    }

    protected <T> CompletableFuture<T> makeRemoteCallForGeneral(String methodName, AdaptingResponder<T> adaptingResponder, Object ... args) {
        Object[] combinedArgs;
        int dstPos;
        if (this.storeKey == null) {
            dstPos = 2;
            combinedArgs = new Object[dstPos + args.length];
            combinedArgs[0] = this.hiveName;
            combinedArgs[1] = this.storeType;
        } else {
            dstPos = 3;
            combinedArgs = new Object[dstPos + args.length];
            combinedArgs[0] = this.hiveName;
            combinedArgs[1] = this.storeType;
            combinedArgs[2] = this.storeKey;
        }
        System.arraycopy(args, 0, combinedArgs, dstPos, args.length);
        return this.makeRemoteCall(HIVE_GENERAL_KEY_ALIAS, methodName, adaptingResponder, combinedArgs);
    }

    protected <T> CompletableFuture<T> makeRemoteCallWithoutStoreKey(String remoteServiceName, String methodName, Object[] args) {
        return this.makeRemoteCallWithoutStoreKey(remoteServiceName, methodName, null, args);
    }

    protected <T> CompletableFuture<T> makeRemoteCallWithoutStoreKey(String remoteServiceName, String methodName, AdaptingResponder<T> adaptingResponder, Object[] args) {
        Object[] combinedArgs = new Object[1 + args.length];
        combinedArgs[0] = this.hiveName;
        System.arraycopy(args, 0, combinedArgs, 1, args.length);
        return this.makeRemoteCall(remoteServiceName, methodName, adaptingResponder, combinedArgs);
    }

    protected <T> CompletableFuture<T> makeRemoteCallWithStoreKey(String remoteServiceName, String methodName, Object[] args) {
        return this.makeRemoteCallWithStoreKey(remoteServiceName, methodName, null, args);
    }

    protected <T> CompletableFuture<T> makeRemoteCallWithStoreKey(String remoteServiceName, String methodName, AdaptingResponder<T> adaptingResponder, Object[] args) {
        Object[] combinedArgs = new Object[2 + args.length];
        combinedArgs[0] = this.hiveName;
        combinedArgs[1] = this.storeKey;
        System.arraycopy(args, 0, combinedArgs, 2, args.length);
        return this.makeRemoteCall(remoteServiceName, methodName, adaptingResponder, combinedArgs);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String remoteServiceName, String methodName, AdaptingResponder<T> adaptingResponder, Object[] args) {
        final CompletableFuture futureResult = new CompletableFuture();
        Invoker.invokeAsync(remoteServiceName, methodName, args, new BackendlessCallback<T>(){

            @Override
            public void handleResponse(T response) {
                futureResult.complete(response);
            }
        }, adaptingResponder);
        return futureResult;
    }
}

