/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.core.responder.AdaptingResponder;
import com.backendless.hive.HiveGeneralForComplexStore;
import com.backendless.hive.HiveSerializer;
import com.backendless.hive.StoreType;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public final class HiveList<T>
extends HiveGeneralForComplexStore {
    public static final String HIVE_LIST_ALIAS = "com.backendless.services.hive.HiveListService";

    HiveList(String hiveName, String storeKey) {
        super(hiveName, StoreType.List, storeKey);
    }

    public CompletableFuture<List<T>> get() {
        return this.makeRemoteCall("get", new Object[0]).thenApply(HiveSerializer::deserializeAsList);
    }

    public CompletableFuture<List<T>> get(int start, int stop) {
        return this.makeRemoteCall("get", start, stop).thenApply(HiveSerializer::deserializeAsList);
    }

    public CompletableFuture<T> get(int index) {
        return this.makeRemoteCall("get", index).thenApply(HiveSerializer::deserialize);
    }

    public CompletableFuture<Long> set(List<T> values) {
        return this.makeRemoteCall("set", new AdaptingResponder<Long>(Long.class), HiveSerializer.serializeAsList(values));
    }

    public CompletableFuture<Void> set(int index, Object value) {
        return this.makeRemoteCall("set", index, HiveSerializer.serialize(value));
    }

    public CompletableFuture<Long> insertBefore(Object targetValue, Object value) {
        return this.insert(targetValue, value, true);
    }

    public CompletableFuture<Long> insertAfter(Object targetValue, Object value) {
        return this.insert(targetValue, value, false);
    }

    private CompletableFuture<Long> insert(Object targetValue, Object value, boolean before) {
        return this.makeRemoteCall("insert", new AdaptingResponder<Long>(Long.class), HiveSerializer.serialize(targetValue), HiveSerializer.serialize(value), before);
    }

    public CompletableFuture<Long> addFirst(T value) {
        return this.addFirst(Collections.singletonList(value));
    }

    public CompletableFuture<Long> addFirst(List<T> values) {
        return this.makeRemoteCall("addFirst", new AdaptingResponder<Long>(Long.class), HiveSerializer.serializeAsList(values));
    }

    public CompletableFuture<Long> addLast(T value) {
        return this.addLast(Collections.singletonList(value));
    }

    public CompletableFuture<Long> addLast(List<T> values) {
        return this.makeRemoteCall("addLast", new AdaptingResponder<Long>(Long.class), HiveSerializer.serializeAsList(values));
    }

    public CompletableFuture<T> deleteAndReturnFirst() {
        return this.makeRemoteCall("removeAndReturnFirst", new Object[0]).thenApply(HiveSerializer::deserialize);
    }

    public CompletableFuture<T> deleteAndReturnLast() {
        return this.makeRemoteCall("removeAndReturnLast", new Object[0]).thenApply(HiveSerializer::deserialize);
    }

    public CompletableFuture<List<T>> deleteAndReturnFirst(int count) {
        return this.makeRemoteCall("removeAndReturnFirst", count).thenApply(HiveSerializer::deserializeAsList);
    }

    public CompletableFuture<List<T>> deleteAndReturnLast(int count) {
        return this.makeRemoteCall("removeAndReturnLast", count).thenApply(HiveSerializer::deserializeAsList);
    }

    public CompletableFuture<Long> deleteValue(T value, int count) {
        return this.makeRemoteCall("removeValue", new AdaptingResponder<Long>(Long.class), HiveSerializer.serialize(value), count);
    }

    public CompletableFuture<Long> length() {
        return this.makeRemoteCall("length", new AdaptingResponder<Long>(Long.class), new Object[0]);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, Object ... args) {
        return this.makeRemoteCallWithStoreKey(HIVE_LIST_ALIAS, methodName, args);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, AdaptingResponder<T> adaptingResponder, Object ... args) {
        return this.makeRemoteCallWithStoreKey(HIVE_LIST_ALIAS, methodName, adaptingResponder, args);
    }
}

