/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.Invoker;
import com.backendless.async.callback.BackendlessCallback;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.hive.ScanResult;
import com.backendless.hive.StoreType;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public final class HiveManagement {
    public static final String HIVE_SERVICE_ALIAS = "com.backendless.services.hive.HiveService";
    private static final HiveManagement HIVE_MANAGEMENT = new HiveManagement();

    public static HiveManagement getInstance() {
        return HIVE_MANAGEMENT;
    }

    HiveManagement() {
    }

    public CompletableFuture<Set<String>> getNames() {
        return this.makeRemoteCall("getHiveNames", new AdaptingResponder<Set>(Set.class), new Object[0]).thenApply(set -> set);
    }

    public CompletableFuture<Void> create(String name) {
        return this.makeRemoteCall("addHive", name);
    }

    public CompletableFuture<Void> rename(String name, String newName) {
        return this.makeRemoteCall("renameHive", name, newName);
    }

    public CompletableFuture<Long> delete(String name) {
        return this.makeRemoteCall("deleteHive", new AdaptingResponder<Long>(Long.class), name);
    }

    public CompletableFuture<Long> deleteAll() {
        return this.makeRemoteCall("deleteAllHives", new AdaptingResponder<Long>(Long.class), new Object[0]);
    }

    public CompletableFuture<ScanResult> keys(String name, StoreType storeType, String filterPattern, String cursor, int pageSize) {
        return this.makeRemoteCall("retrieveHiveKeys", name, storeType, filterPattern, cursor, pageSize);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, Object ... args) {
        return this.makeRemoteCall(methodName, null, args);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, AdaptingResponder<T> adaptingResponder, Object ... args) {
        final CompletableFuture futureResult = new CompletableFuture();
        Invoker.invokeAsync(HIVE_SERVICE_ALIAS, methodName, args, new BackendlessCallback<T>(){

            @Override
            public void handleResponse(T response) {
                futureResult.complete(response);
            }
        }, adaptingResponder);
        return futureResult;
    }
}

