/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.core.responder.AdaptingResponder;
import com.backendless.hive.HiveGeneralForComplexStore;
import com.backendless.hive.HiveSerializer;
import com.backendless.hive.StoreType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public final class HiveMap<T>
extends HiveGeneralForComplexStore {
    public static final String HIVE_MAP_ALIAS = "com.backendless.services.hive.HiveMapService";

    HiveMap(String hiveName, String storeKey) {
        super(hiveName, StoreType.Map, storeKey);
    }

    public CompletableFuture<Map<String, T>> get() {
        return this.makeRemoteCall("get", new Object[0]).thenApply(HiveSerializer::deserialize);
    }

    public CompletableFuture<T> get(String objKey) {
        return this.makeRemoteCall("get", objKey).thenApply(HiveSerializer::deserialize);
    }

    public CompletableFuture<Map<String, T>> get(List<String> objKeys) {
        return this.makeRemoteCall("multiGet", objKeys).thenApply(HiveSerializer::deserialize);
    }

    public CompletableFuture<List<String>> keys() {
        return this.makeRemoteCall("getKeys", new AdaptingResponder<List>(List.class), new Object[0]).thenApply(result -> result);
    }

    public CompletableFuture<List<T>> values() {
        return this.makeRemoteCall("getValues", new Object[0]).thenApply(HiveSerializer::deserializeAsList);
    }

    public CompletableFuture<Long> set(Map<String, T> values) {
        return this.makeRemoteCall("set", new AdaptingResponder<Long>(Long.class), HiveSerializer.serializeAsMap(values));
    }

    private CompletableFuture<Boolean> set(String objKey, T value) {
        return this.makeRemoteCall("set", objKey, HiveSerializer.serialize(value));
    }

    private CompletableFuture<Boolean> setIfNotExist(String objKey, T value) {
        return this.makeRemoteCall("setIfNotExist", objKey, HiveSerializer.serialize(value));
    }

    public CompletableFuture<Boolean> set(String objKey, T value, boolean overwrite) {
        if (overwrite) {
            return this.set(objKey, value);
        }
        return this.setIfNotExist(objKey, value);
    }

    public CompletableFuture<Long> increment(String objKey, Integer value) {
        return this.makeRemoteCall("incrementBy", new AdaptingResponder<Long>(Long.class), objKey, value);
    }

    public CompletableFuture<Long> decrement(String objKey, Integer value) {
        return this.increment(objKey, -value.intValue());
    }

    public CompletableFuture<Boolean> keyExists(String objKey) {
        return this.makeRemoteCall("exists", objKey);
    }

    public CompletableFuture<Long> length() {
        return this.makeRemoteCall("length", new AdaptingResponder<Long>(Long.class), new Object[0]);
    }

    @Override
    public CompletableFuture<Long> delete(String objKey) {
        return this.delete(Collections.singletonList(objKey));
    }

    public CompletableFuture<Long> delete(List<String> objKeys) {
        return this.makeRemoteCall("del", new AdaptingResponder<Long>(Long.class), objKeys);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, Object ... args) {
        return this.makeRemoteCallWithStoreKey(HIVE_MAP_ALIAS, methodName, args);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, AdaptingResponder<T> adaptingResponder, Object ... args) {
        return this.makeRemoteCallWithStoreKey(HIVE_MAP_ALIAS, methodName, adaptingResponder, args);
    }
}

