/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.utils.WeborbSerializationHelper;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;

final class HiveSerializer {
    HiveSerializer() {
    }

    static String serialize(Object obj) {
        return new String(WeborbSerializationHelper.serialize(obj), StandardCharsets.UTF_8);
    }

    static <T> T deserialize(String jsonString) {
        return (T)WeborbSerializationHelper.deserialize(jsonString.getBytes(StandardCharsets.UTF_8));
    }

    static HashMap<String, String> serializeAsMap(Map<String, ?> mapOfObjects) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, ?> entry : mapOfObjects.entrySet()) {
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("null value for key '" + entry.getKey() + "'");
            }
            result.put(entry.getKey(), HiveSerializer.serialize(entry.getValue()));
        }
        return result;
    }

    static <T> HashMap<String, T> deserialize(Map<String, String> mapOfJsonStrings) {
        HashMap<String, T> result = new HashMap<String, T>();
        for (Map.Entry<String, String> entry : mapOfJsonStrings.entrySet()) {
            result.put(entry.getKey(), HiveSerializer.deserialize(entry.getValue()));
        }
        return result;
    }

    static ArrayList<String> serializeAsList(Collection<?> listOfObjects) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object obj : listOfObjects) {
            if (obj == null) {
                throw new IllegalArgumentException("null value found in collection");
            }
            result.add(HiveSerializer.serialize(obj));
        }
        return result;
    }

    static <T> ArrayList<T> deserializeAsList(String[] arrayOfJsonStrings) {
        ArrayList<T> result = new ArrayList<T>();
        for (String listOfJsonString : arrayOfJsonStrings) {
            result.add(HiveSerializer.deserialize(listOfJsonString));
        }
        return result;
    }

    static <T> HashSet<T> deserializeAsSet(String[] listOfJsonStrings) {
        HashSet<T> result = new HashSet<T>();
        for (String listOfJsonString : listOfJsonStrings) {
            result.add(HiveSerializer.deserialize(listOfJsonString));
        }
        return result;
    }

    static <T> LinkedHashSet<T> deserializeAsLinkedSet(String[] listOfJsonStrings) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (String listOfJsonString : listOfJsonStrings) {
            result.add(HiveSerializer.deserialize(listOfJsonString));
        }
        return result;
    }
}

