/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.core.responder.AdaptingResponder;
import com.backendless.hive.HiveGeneralForComplexStore;
import com.backendless.hive.HiveSerializer;
import com.backendless.hive.StoreType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public final class HiveSet<T>
extends HiveGeneralForComplexStore {
    public static final String HIVE_SET_ALIAS = "com.backendless.services.hive.HiveSetService";

    HiveSet(String hiveName, String storeKey) {
        super(hiveName, StoreType.Set, storeKey);
    }

    public CompletableFuture<Set<T>> get() {
        return this.makeRemoteCall("get", new Object[0]).thenApply(HiveSerializer::deserializeAsSet);
    }

    public CompletableFuture<List<T>> getRandom(int count) {
        return this.makeRemoteCall("getRandom", count).thenApply(HiveSerializer::deserializeAsList);
    }

    public CompletableFuture<Set<T>> getRandomAndDel(int count) {
        return this.makeRemoteCall("getRandomAndDel", count).thenApply(HiveSerializer::deserializeAsSet);
    }

    public CompletableFuture<Boolean> isValueMember(T value) {
        return this.makeRemoteCall("contains", HiveSerializer.serialize(value));
    }

    public CompletableFuture<List<Boolean>> isValueMember(Set<T> values) {
        return this.makeRemoteCall("contains", new AdaptingResponder<List>(List.class), HiveSerializer.serializeAsList(values)).thenApply(result -> result);
    }

    public CompletableFuture<Long> length() {
        return this.makeRemoteCall("size", new AdaptingResponder<Long>(Long.class), new Object[0]);
    }

    public CompletableFuture<Long> add(T value) {
        return this.add(Collections.singleton(value));
    }

    public CompletableFuture<Long> add(Set<T> values) {
        return this.makeRemoteCall("add", new AdaptingResponder<Long>(Long.class), HiveSerializer.serializeAsList(values));
    }

    public CompletableFuture<Long> delete(Set<T> values) {
        return this.makeRemoteCall("del", new AdaptingResponder<Long>(Long.class), HiveSerializer.serializeAsList(values));
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, Object ... args) {
        return this.makeRemoteCallWithStoreKey(HIVE_SET_ALIAS, methodName, args);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, AdaptingResponder<T> adaptingResponder, Object ... args) {
        return this.makeRemoteCallWithStoreKey(HIVE_SET_ALIAS, methodName, adaptingResponder, args);
    }
}

