/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.core.responder.AdaptingResponder;
import com.backendless.hive.DuplicateBehaviour;
import com.backendless.hive.HiveGeneralForComplexStore;
import com.backendless.hive.HiveSerializer;
import com.backendless.hive.ResultType;
import com.backendless.hive.ScoreUpdateMode;
import com.backendless.hive.ScoreValuePair;
import com.backendless.hive.StoreType;
import com.backendless.hive.ValueBound;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public final class HiveSortedSet<T>
extends HiveGeneralForComplexStore {
    public static final String HIVE_SORTED_SET_ALIAS = "com.backendless.services.hive.HiveSortedSetService";

    HiveSortedSet(String hiveName, String storeKey) {
        super(hiveName, StoreType.SortedSet, storeKey);
    }

    public CompletableFuture<Long> add(ScoreValuePair<T> item) {
        return this.add(Collections.singleton(item), null, null, null);
    }

    public CompletableFuture<Long> add(Set<ScoreValuePair<T>> items) {
        return this.add(items, null, null, null);
    }

    public CompletableFuture<Long> add(Set<ScoreValuePair<T>> items, DuplicateBehaviour duplicateBehaviour, ScoreUpdateMode scoreUpdateMode, ResultType resultType) {
        return this.makeRemoteCall("add", new AdaptingResponder<Long>(Long.class), ScoreValuePair.toObjectArray(items), duplicateBehaviour, scoreUpdateMode, resultType);
    }

    public CompletableFuture<Double> incrementScore(double scoreAmount, String member) {
        return this.makeRemoteCall("increment", scoreAmount, member);
    }

    public CompletableFuture<Double> decrementScore(double scoreAmount, String member) {
        return this.incrementScore(-scoreAmount, member);
    }

    public CompletableFuture<LinkedHashSet<ScoreValuePair<T>>> getAndDeleteMaxScore(int count) {
        return this.makeRemoteCall("getAndRemoveMax", count).thenApply(ScoreValuePair::fromObjectArray);
    }

    public CompletableFuture<LinkedHashSet<ScoreValuePair<T>>> getAndDeleteMinScore(int count) {
        return this.makeRemoteCall("getAndRemoveMin", count).thenApply(ScoreValuePair::fromObjectArray);
    }

    public CompletableFuture<List<T>> getRandom(int count) {
        return this.makeRemoteCall("getRandom", count).thenApply(HiveSerializer::deserializeAsList);
    }

    public CompletableFuture<List<ScoreValuePair<T>>> getRandomWithScores(int count) {
        return this.makeRemoteCall("getRandomWithScores", count).thenApply(ScoreValuePair::fromObjectArrayToList);
    }

    public CompletableFuture<Double> getScore(String member) {
        return this.makeRemoteCall("getScore", member);
    }

    public CompletableFuture<Long> getRank(String member, boolean reverse) {
        if (reverse) {
            return this.getReverseRank(member);
        }
        return this.getRank(member);
    }

    private CompletableFuture<Long> getRank(String member) {
        return this.makeRemoteCall("getRank", new AdaptingResponder<Long>(Long.class), member);
    }

    private CompletableFuture<Long> getReverseRank(String member) {
        return this.makeRemoteCall("getReverseRank", new AdaptingResponder<Long>(Long.class), member);
    }

    public CompletableFuture<LinkedHashSet<T>> getRangeByRank(long startRank, long stopRank, boolean reverse) {
        if (reverse) {
            return this.getReverseRangeByRank(startRank, stopRank);
        }
        return this.getRangeByRank(startRank, stopRank);
    }

    private CompletableFuture<LinkedHashSet<T>> getRangeByRank(long startRank, long stopRank) {
        return this.makeRemoteCall("getRangeByRank", startRank, stopRank).thenApply(HiveSerializer::deserializeAsLinkedSet);
    }

    private CompletableFuture<LinkedHashSet<T>> getReverseRangeByRank(long startRank, long stopRank) {
        return this.makeRemoteCall("getReverseRangeByRank", startRank, stopRank).thenApply(HiveSerializer::deserializeAsLinkedSet);
    }

    public CompletableFuture<LinkedHashSet<ScoreValuePair<T>>> getRangeWithScoresByRank(long startRank, long stopRank, boolean reverse) {
        if (reverse) {
            return this.getReverseRangeWithScoresByRank(startRank, stopRank);
        }
        return this.getRangeWithScoresByRank(startRank, stopRank);
    }

    private CompletableFuture<LinkedHashSet<ScoreValuePair<T>>> getRangeWithScoresByRank(long startRank, long stopRank) {
        return this.makeRemoteCall("getRangeWithScoresByRank", startRank, stopRank).thenApply(ScoreValuePair::fromObjectArray);
    }

    private CompletableFuture<LinkedHashSet<ScoreValuePair<T>>> getReverseRangeWithScoresByRank(long startRank, long stopRank) {
        return this.makeRemoteCall("getReverseRangeWithScoresByRank", startRank, stopRank).thenApply(ScoreValuePair::fromObjectArray);
    }

    public CompletableFuture<LinkedHashSet<T>> getRangeByScore(ScoreRangeOptions options, long offset, long pageSize, boolean reverse) {
        if (reverse) {
            return this.getReverseRangeByScore(options.minScore, options.minBound, options.maxScore, options.maxBound, offset, pageSize);
        }
        return this.getRangeByScore(options.minScore, options.minBound, options.maxScore, options.maxBound, offset, pageSize);
    }

    private CompletableFuture<LinkedHashSet<T>> getRangeByScore(double minScore, ValueBound minBound, double maxScore, ValueBound maxBound, long offset, long pageSize) {
        return this.makeRemoteCall("getRangeByScore", minScore, minBound, maxScore, maxBound, offset, pageSize).thenApply(HiveSerializer::deserializeAsLinkedSet);
    }

    private CompletableFuture<LinkedHashSet<T>> getReverseRangeByScore(double minScore, ValueBound minBound, double maxScore, ValueBound maxBound, long offset, long pageSize) {
        return this.makeRemoteCall("getReverseRangeByScore", minScore, minBound, maxScore, maxBound, offset, pageSize).thenApply(HiveSerializer::deserializeAsLinkedSet);
    }

    public CompletableFuture<LinkedHashSet<ScoreValuePair<T>>> getRangeWithScoresByScore(ScoreRangeOptions options, long offset, long pageSize, boolean reverse) {
        if (reverse) {
            return this.getReverseRangeWithScoresByScore(options.minScore, options.minBound, options.maxScore, options.maxBound, offset, pageSize);
        }
        return this.getRangeWithScoresByScore(options.minScore, options.minBound, options.maxScore, options.maxBound, offset, pageSize);
    }

    private CompletableFuture<LinkedHashSet<ScoreValuePair<T>>> getRangeWithScoresByScore(double minScore, ValueBound minBound, double maxScore, ValueBound maxBound, long offset, long pageSize) {
        return this.makeRemoteCall("getRangeWithScoresByScore", minScore, minBound, maxScore, maxBound, offset, pageSize).thenApply(ScoreValuePair::fromObjectArray);
    }

    private CompletableFuture<LinkedHashSet<ScoreValuePair<T>>> getReverseRangeWithScoresByScore(double minScore, ValueBound minBound, double maxScore, ValueBound maxBound, long offset, long pageSize) {
        return this.makeRemoteCall("getReverseRangeWithScoresByScore", minScore, minBound, maxScore, maxBound, offset, pageSize).thenApply(ScoreValuePair::fromObjectArray);
    }

    public CompletableFuture<Long> delete(Set<String> values) {
        return this.makeRemoteCall("remove", new AdaptingResponder<Long>(Long.class), values);
    }

    public CompletableFuture<Long> deleteByRank(long startRank, long stopRank) {
        return this.makeRemoteCall("removeByRank", new AdaptingResponder<Long>(Long.class), startRank, stopRank);
    }

    public CompletableFuture<Long> deleteByScore(ScoreRangeOptions options) {
        return this.deleteByScore(options.minScore, options.minBound, options.maxScore, options.maxBound);
    }

    public CompletableFuture<Long> deleteByScore(double minScore, ValueBound minBound, double maxScore, ValueBound maxBound) {
        return this.makeRemoteCall("removeByScore", new AdaptingResponder<Long>(Long.class), minScore, minBound, maxScore, maxBound);
    }

    public CompletableFuture<Long> length() {
        return this.makeRemoteCall("size", new AdaptingResponder<Long>(Long.class), new Object[0]);
    }

    public CompletableFuture<Long> countBetweenScores(ScoreRangeOptions options) {
        return this.countBetweenScores(options.minScore, options.minBound, options.maxScore, options.maxBound);
    }

    private CompletableFuture<Long> countBetweenScores(double minScore, ValueBound minBound, double maxScore, ValueBound maxBound) {
        return this.makeRemoteCall("count", new AdaptingResponder<Long>(Long.class), minScore, minBound, maxScore, maxBound);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, Object ... args) {
        return this.makeRemoteCallWithStoreKey(HIVE_SORTED_SET_ALIAS, methodName, args);
    }

    private <T> CompletableFuture<T> makeRemoteCall(String methodName, AdaptingResponder<T> adaptingResponder, Object ... args) {
        return this.makeRemoteCallWithStoreKey(HIVE_SORTED_SET_ALIAS, methodName, adaptingResponder, args);
    }

    public static final class ScoreRangeOptions {
        private double minScore;
        private ValueBound minBound;
        private double maxScore;
        private ValueBound maxBound;

        public ScoreRangeOptions setMinScore(double minScore) {
            this.minScore = minScore;
            return this;
        }

        public ScoreRangeOptions setMinBound(ValueBound minBound) {
            this.minBound = minBound;
            return this;
        }

        public ScoreRangeOptions setMaxScore(double maxScore) {
            this.maxScore = maxScore;
            return this;
        }

        public ScoreRangeOptions setMaxBound(ValueBound maxBound) {
            this.maxBound = maxBound;
            return this;
        }
    }
}

