/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.hive;

import com.backendless.hive.HiveSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;

public class ScoreValuePair<T> {
    private final double score;
    private final T value;

    public ScoreValuePair(double score, T value) {
        if (value == null) {
            throw new NullPointerException("Value is null for score: " + score);
        }
        this.score = score;
        this.value = value;
    }

    public static <T> LinkedHashSet<ScoreValuePair<T>> from(Object[] arrayItems) {
        if (arrayItems.length % 2 != 0) {
            throw new IllegalArgumentException("Wrong length of incoming array for ScoreValuePair. It should contain even numbers of elements.");
        }
        LinkedHashSet<ScoreValuePair<T>> items = new LinkedHashSet<ScoreValuePair<T>>();
        for (int i = 0; i < arrayItems.length; i += 2) {
            items.add(new ScoreValuePair<Object>(((Number)arrayItems[i]).doubleValue(), arrayItems[i + 1]));
        }
        return items;
    }

    static <T> Object[] toObjectArray(Collection<ScoreValuePair<T>> items) {
        Object[] arrayItems = new Object[items.size() * 2];
        int i = 0;
        for (ScoreValuePair<T> item : items) {
            arrayItems[i * 2] = item.getScore();
            arrayItems[i * 2 + 1] = HiveSerializer.serialize(item.getValue());
            ++i;
        }
        return arrayItems;
    }

    static <T> ArrayList<ScoreValuePair<T>> fromObjectArrayToList(Object[] arrayItems) {
        if (arrayItems.length % 2 != 0) {
            throw new IllegalArgumentException("Wrong length of incoming array for ScoreValuePair. It should contain even numbers of elements.");
        }
        ArrayList<ScoreValuePair<T>> items = new ArrayList<ScoreValuePair<T>>();
        for (int i = 0; i < arrayItems.length; i += 2) {
            items.add(new ScoreValuePair(((Number)arrayItems[i]).doubleValue(), HiveSerializer.deserialize((String)arrayItems[i + 1])));
        }
        return items;
    }

    static <T> LinkedHashSet<ScoreValuePair<T>> fromObjectArray(Object[] arrayItems) {
        if (arrayItems.length % 2 != 0) {
            throw new IllegalArgumentException("Wrong length of incoming array for ScoreValuePair. It should contain even numbers of elements.");
        }
        LinkedHashSet<ScoreValuePair<T>> items = new LinkedHashSet<ScoreValuePair<T>>();
        for (int i = 0; i < arrayItems.length; i += 2) {
            items.add(new ScoreValuePair(((Number)arrayItems[i]).doubleValue(), HiveSerializer.deserialize((String)arrayItems[i + 1])));
        }
        return items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScoreValuePair)) {
            return false;
        }
        ScoreValuePair that = (ScoreValuePair)o;
        return Double.compare(that.score, this.score) == 0 && this.value.equals(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public double getScore() {
        return this.score;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return "ScoreValuePair(score=" + this.getScore() + ", value=" + this.getValue() + ")";
    }
}

