/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.logging;

import com.backendless.BackendlessInjector;
import com.backendless.Invoker;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.logging.Level;
import com.backendless.logging.LogMessage;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class LogBuffer {
    private static final int NUM_OF_MESSAGES = 100;
    private static final int NUM_OF_MESSAGES_CODERUNNER = 1;
    private static final int TIME_FREQUENCY = 300;
    private static final int TIME_FREQUENCY_CODERUNNER = -1;
    private static final String LOGGING_SERVER_ALIAS = "com.backendless.services.logging.LogService";
    private final BackendlessInjector injector = BackendlessInjector.getInstance();
    private ScheduledExecutorService scheduledExecutorService;
    private int numOfMessages = this.injector.isCodeRunner() ? 1 : 100;
    private int timeFrequency = this.injector.isCodeRunner() ? -1 : 300;
    private final Queue<LogMessage> logMessages = new ConcurrentLinkedQueue<LogMessage>();
    private ScheduledFuture<?> scheduledFuture;

    public static LogBuffer getInstance() {
        return SingletonHolder.HOLDER_INSTANCE;
    }

    private LogBuffer() {
        if (!this.injector.isCodeRunner()) {
            this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        }
        this.setupTimer();
    }

    public void setLogReportingPolicy(int numOfMessages, int timeFrequency) {
        if (numOfMessages <= 0 && timeFrequency <= 0) {
            throw new IllegalArgumentException("Either the number of messages or the time frequency must be a positive value");
        }
        this.numOfMessages = numOfMessages;
        this.timeFrequency = timeFrequency;
        this.setupTimer();
    }

    public void flush() {
        if (!this.logMessages.isEmpty()) {
            this.reportBatch(new ArrayList<LogMessage>(this.logMessages));
            this.logMessages.clear();
        }
    }

    private void setupTimer() {
        if (this.timeFrequency > 0) {
            this.scheduledTask();
        }
    }

    void enqueue(String logger, Level level, String message, Throwable exception) {
        if (this.numOfMessages == 1) {
            this.reportSingleLogMessage(logger, level, message, exception != null ? this.getStackTrace(exception) : null);
            return;
        }
        this.logMessages.add(new LogMessage(logger, level, new Date(System.currentTimeMillis()), message, exception != null ? this.getStackTrace(exception) : null));
        if (this.numOfMessages > 1 && this.logMessages.size() >= this.numOfMessages) {
            this.flush();
        }
    }

    private void scheduledTask() {
        if (this.injector.isCodeRunner()) {
            return;
        }
        if (!this.scheduledExecutorService.isShutdown()) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    LogBuffer.this.flush();
                }
            }, 0L, this.timeFrequency, TimeUnit.SECONDS);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        try (StringWriter errors = new StringWriter();){
            PrintWriter s1 = new PrintWriter(errors);
            try {
                t.printStackTrace(s1);
                String string = errors.toString();
                s1.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    s1.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public void reportSingleLogMessage(String logger, Level loglevel, String message, String exception) {
        if (this.injector.isCodeRunner()) {
            Invoker.invokeSync(LOGGING_SERVER_ALIAS, "log", new Object[]{loglevel.name(), logger, message, exception});
        } else {
            Invoker.invokeAsync(LOGGING_SERVER_ALIAS, "log", new Object[]{loglevel.name(), logger, message, exception}, new AsyncCallback<Void>(){

                @Override
                public void handleResponse(Void response) {
                }

                @Override
                public void handleFault(BackendlessFault fault) {
                }
            });
        }
    }

    public void reportBatch(List<LogMessage> logBatches) {
        if (this.injector.isCodeRunner()) {
            Invoker.invokeSync(LOGGING_SERVER_ALIAS, "batchLog", new Object[]{logBatches});
        } else {
            Invoker.invokeAsync(LOGGING_SERVER_ALIAS, "batchLog", new Object[]{logBatches}, new AsyncCallback<Void>(){

                @Override
                public void handleResponse(Void response) {
                }

                @Override
                public void handleFault(BackendlessFault fault) {
                }
            });
        }
    }

    public void close() {
        this.scheduledFuture.cancel(true);
        this.scheduledExecutorService.shutdownNow();
    }

    public static class SingletonHolder {
        public static final LogBuffer HOLDER_INSTANCE = new LogBuffer();
    }
}

