/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.logging;

import com.backendless.logging.Level;
import com.backendless.logging.LogBuffer;

public class Logger {
    private final String name;
    private static final LogBuffer logBufer = LogBuffer.getInstance();

    public static Logger getLogger(Class clazz) {
        return new Logger(clazz.getCanonicalName());
    }

    public static Logger getLogger(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Log name cannot be empty");
        }
        return new Logger(name);
    }

    Logger(String name) {
        this.name = name;
    }

    public void debug(String message) {
        logBufer.enqueue(this.name, Level.DEBUG, message, null);
    }

    public void info(String message) {
        logBufer.enqueue(this.name, Level.INFO, message, null);
    }

    public void warn(String message) {
        logBufer.enqueue(this.name, Level.WARN, message, null);
    }

    public void warn(String message, Throwable t) {
        logBufer.enqueue(this.name, Level.WARN, message, t);
    }

    public void error(String message) {
        logBufer.enqueue(this.name, Level.ERROR, message, null);
    }

    public void error(String message, Throwable t) {
        logBufer.enqueue(this.name, Level.ERROR, message, t);
    }

    public void fatal(String message) {
        logBufer.enqueue(this.name, Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t) {
        logBufer.enqueue(this.name, Level.FATAL, message, t);
    }

    public void trace(String message) {
        logBufer.enqueue(this.name, Level.TRACE, message, null);
    }
}

