/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.messaging;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Message {
    private String messageId;
    private Map<String, String> headers;
    private Object data;
    private String publisherId;
    private long timestamp;

    public String getMessageId() {
        return this.messageId;
    }

    public Map<String, String> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
            return this.headers;
        }
        return new HashMap<String, String>(this.headers);
    }

    public Object getData() {
        return this.data;
    }

    public String getPublisherId() {
        return this.publisherId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public void setPublisherId(String publisherId) {
        this.publisherId = publisherId;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        if (this.timestamp != message.timestamp) {
            return false;
        }
        if (!Objects.equals(this.data, message.data)) {
            return false;
        }
        if (!Objects.equals(this.headers, message.headers)) {
            return false;
        }
        if (!Objects.equals(this.messageId, message.messageId)) {
            return false;
        }
        return Objects.equals(this.publisherId, message.publisherId);
    }

    public int hashCode() {
        int result = this.messageId != null ? this.messageId.hashCode() : 0;
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.publisherId != null ? this.publisherId.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Message");
        sb.append("{messageId='").append(this.messageId).append('\'');
        sb.append(", data=").append(this.data);
        sb.append(", headers={");
        int i = 0;
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            sb.append(entry.getKey()).append(":").append(entry.getValue());
            if (++i == this.headers.size()) continue;
            sb.append(", ");
        }
        sb.append("}, publisherId='").append(this.publisherId).append('\'');
        sb.append(", timestamp=").append(this.timestamp);
        sb.append('}');
        return sb.toString();
    }
}

