/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.BackendlessInjector;
import com.backendless.IDataStore;
import com.backendless.persistence.DataQueryBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class BackendlessDataCollection<T extends Identifiable<T>>
implements Collection<T> {
    private final Class<T> entityType;
    private final IDataStore<T> iDataStore;
    private final String slice;
    private LinkedHashMap<String, T> preservedData;
    private int size;
    private boolean isLoaded = false;

    public BackendlessDataCollection(Class<T> entityType) {
        this(entityType, false);
    }

    public BackendlessDataCollection(Class<T> entityType, String slice) {
        this(entityType, false, slice);
    }

    public BackendlessDataCollection(Class<T> entityType, boolean preserveIteratedData) {
        this(entityType, preserveIteratedData, "");
    }

    public BackendlessDataCollection(Class<T> entityType, boolean preserveIteratedData, String slice) {
        this.entityType = entityType;
        this.slice = slice == null ? "" : slice;
        this.iDataStore = BackendlessInjector.getInstance().getPersistence().of(this.entityType);
        if (preserveIteratedData) {
            this.preservedData = new LinkedHashMap();
        }
        this.size = this.getRealSize();
    }

    public String getSlice() {
        return this.slice;
    }

    public boolean isPersisted() {
        return this.preservedData != null;
    }

    public int getPersistedSize() {
        if (this.preservedData == null) {
            throw new IllegalStateException("This collection is not persisted.");
        }
        return this.preservedData.size();
    }

    public boolean isLoaded() {
        if (this.preservedData == null) {
            throw new IllegalStateException("This collection is not persisted.");
        }
        return this.isLoaded;
    }

    public void invalidateState() {
        if (this.preservedData != null) {
            this.preservedData.clear();
            this.isLoaded = false;
        }
        this.size = this.getRealSize();
    }

    public void populate() {
        if (this.preservedData == null) {
            throw new IllegalStateException("This collection is not persisted.");
        }
        Iterator<T> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
        }
    }

    private int getRealSize() {
        return this.iDataStore.getObjectCount(DataQueryBuilder.create().setWhereClause(this.slice));
    }

    private void checkObjectType(Object o) {
        if (this.entityType != o.getClass()) {
            throw new IllegalArgumentException(o.getClass() + " is not a type of objects contained in this collection.");
        }
    }

    private void checkObjectTypeAndId(Object o) {
        if (this.entityType != o.getClass()) {
            throw new IllegalArgumentException(o.getClass() + " is not a type of objects contained in this collection.");
        }
        String objectId = ((Identifiable)o).getObjectId();
        if (objectId == null) {
            throw new IllegalArgumentException("'objectId' is null.");
        }
    }

    private String getQuery(String id) {
        String query = "objectId='" + id + "'";
        query = this.slice.isEmpty() ? query : this.slice + " and " + query;
        return query;
    }

    private String getQuery(Collection<T> objs, boolean exclude) {
        String firstPart = exclude ? "objectId not in (" : "objectId in (";
        StringBuilder sb = new StringBuilder(firstPart);
        for (Identifiable obj : objs) {
            sb.append('\'').append(obj.getObjectId()).append('\'').append(',');
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        String query = sb.toString();
        query = this.slice.isEmpty() ? query : this.slice + " and " + query;
        return query;
    }

    private String getQueryByIds(Collection<String> ids, boolean exclude) {
        String firstPart = exclude ? "objectId not in (" : "objectId in (";
        StringBuilder sb = new StringBuilder(firstPart);
        for (String id : ids) {
            sb.append('\'').append(id).append('\'').append(',');
        }
        sb.replace(sb.length() - 1, sb.length(), ")");
        String query = sb.toString();
        query = this.slice.isEmpty() ? query : this.slice + " and " + query;
        return query;
    }

    public T getById(String objectId) {
        if (this.preservedData != null && this.isLoaded) {
            return (T)((Identifiable)this.preservedData.get(objectId));
        }
        DataQueryBuilder queryBuilder = DataQueryBuilder.create().setWhereClause(this.getQuery(objectId));
        return (T)((Identifiable)((Object)this.iDataStore.find(queryBuilder)));
    }

    @Override
    public Iterator<T> iterator() {
        return new BackendlessDataCollectionIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean remove(Object o) {
        this.checkObjectTypeAndId(o);
        boolean result = false;
        if (this.preservedData != null) {
            result = this.preservedData.remove(((Identifiable)o).getObjectId()) != null;
        }
        return result |= this.iDataStore.remove(this.getQuery(((Identifiable)o).getObjectId())) != 0;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        for (Object element : c) {
            this.checkObjectTypeAndId(element);
        }
        boolean result = false;
        if (this.preservedData != null) {
            for (Identifiable entity : c) {
                result = this.preservedData.remove(entity.getObjectId()) != null;
            }
        }
        return result |= this.iDataStore.remove(this.getQuery(c, false)) != 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o) {
        this.checkObjectTypeAndId(o);
        boolean result = false;
        if (this.preservedData != null) {
            result = this.preservedData.containsKey(((Identifiable)o).getObjectId());
        }
        if (this.isLoaded) {
            return result;
        }
        DataQueryBuilder queryBuilder = DataQueryBuilder.create().setWhereClause(this.getQuery(((Identifiable)o).getObjectId()));
        return result |= this.iDataStore.getObjectCount(queryBuilder) != 0;
    }

    @Override
    public T[] toArray() {
        if (this.preservedData != null && this.isLoaded) {
            return this.preservedData.values().toArray((Identifiable[])Array.newInstance(this.entityType, this.preservedData.size()));
        }
        ArrayList list = new ArrayList(this);
        return (Identifiable[])list.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        Class<?> arrayType = a.getClass().getComponentType();
        if (this.entityType != arrayType) {
            throw new IllegalArgumentException(arrayType + " is not a type objects of which are contained in this collection.");
        }
        return this.toArray();
    }

    @Override
    public boolean add(T t) {
        DataQueryBuilder queryBuilder;
        this.checkObjectType(t);
        Identifiable savedEntity = (Identifiable)this.iDataStore.save(t);
        if (this.slice != null && this.iDataStore.getObjectCount(queryBuilder = DataQueryBuilder.create().setWhereClause(this.getQuery(savedEntity.getObjectId()))) == 0) {
            this.iDataStore.remove(this.getQuery(savedEntity.getObjectId()));
            return false;
        }
        if (this.preservedData != null) {
            this.preservedData.put(savedEntity.getObjectId(), savedEntity);
        }
        ++this.size;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object element : c) {
            this.checkObjectTypeAndId(element);
        }
        Collection<?> collection = c;
        if (this.preservedData != null && this.isLoaded) {
            HashSet<String> listId = new HashSet<String>();
            for (Identifiable obj : collection) {
                listId.add(obj.getObjectId());
            }
            return this.preservedData.keySet().containsAll(listId);
        }
        DataQueryBuilder queryBuilder = DataQueryBuilder.create().setWhereClause(this.getQuery(collection, false));
        return this.iDataStore.getObjectCount(queryBuilder) == c.size();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        DataQueryBuilder queryBuilder;
        for (T element : c) {
            this.checkObjectType(element);
        }
        List<String> listId = this.iDataStore.create((List)c);
        if (this.slice != null && this.iDataStore.getObjectCount(queryBuilder = DataQueryBuilder.create().setWhereClause(this.getQueryByIds(listId, false))) != listId.size()) {
            this.iDataStore.remove(this.getQueryByIds(listId, false));
            return false;
        }
        if (this.preservedData != null) {
            for (int i = 0; i < c.size(); ++i) {
                Identifiable obj = (Identifiable)((List)c).get(i);
                obj.setObjectId(listId.get(i));
                this.preservedData.put(obj.getObjectId(), obj);
            }
        }
        this.size += listId.size();
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result;
        for (Object element : c) {
            this.checkObjectTypeAndId(element);
        }
        HashSet<String> listId = new HashSet<String>();
        for (Identifiable obj : c) {
            listId.add(obj.getObjectId());
        }
        boolean bl = result = this.iDataStore.remove(this.getQueryByIds(listId, true)) != 0;
        if (this.preservedData != null) {
            Iterator<String> idIterator = this.preservedData.keySet().iterator();
            while (idIterator.hasNext()) {
                if (listId.contains(idIterator.next())) continue;
                result = true;
                idIterator.remove();
            }
        }
        return result;
    }

    @Override
    public void clear() {
        this.iDataStore.remove(this.slice);
        this.invalidateState();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BackendlessDataCollection)) {
            return false;
        }
        BackendlessDataCollection that = (BackendlessDataCollection)o;
        return Objects.equals(this.entityType, that.entityType) && Objects.equals(this.slice, that.slice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.entityType, this.slice);
    }

    public class BackendlessDataCollectionIterator
    implements Iterator<T> {
        private static final int pageSize = 100;
        private DataQueryBuilder queryBuilder;
        private int currentPosition;
        private List<T> currentPageData;
        private List<T> nextPageData;
        private Iterator<T> persistedIterator;
        private T[] loadedData;

        private BackendlessDataCollectionIterator() {
            if (BackendlessDataCollection.this.size() < 1) {
                return;
            }
            if (BackendlessDataCollection.this.isLoaded) {
                this.persistedIterator = BackendlessDataCollection.this.preservedData.values().iterator();
                return;
            }
            this.currentPosition = 0;
            this.queryBuilder = DataQueryBuilder.create().setWhereClause(BackendlessDataCollection.this.slice).setPageSize(100);
            if (BackendlessDataCollection.this.preservedData == null) {
                this.currentPageData = BackendlessDataCollection.this.iDataStore.find(this.queryBuilder);
                this.nextPageData = BackendlessDataCollection.this.iDataStore.find(this.queryBuilder.prepareNextPage());
            } else {
                Identifiable[] array = (Identifiable[])Array.newInstance(BackendlessDataCollection.this.entityType, BackendlessDataCollection.this.preservedData.size());
                this.loadedData = BackendlessDataCollection.this.preservedData.values().toArray(array);
                this.currentPageData = new ArrayList();
                boolean fullPage = this.loadNextPageUsingLocalDataIfPresent(0, this.currentPageData);
                if (!fullPage) {
                    return;
                }
                this.nextPageData = new ArrayList();
                this.loadNextPageUsingLocalDataIfPresent(1, this.nextPageData);
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            if (this.persistedIterator != null) {
                hasNext = this.persistedIterator.hasNext();
            } else {
                boolean bl = hasNext = this.currentPageData != null && this.currentPosition % 100 < this.currentPageData.size() || this.nextPageData != null && !this.nextPageData.isEmpty();
            }
            if (!hasNext) {
                this.nextPageData = null;
                this.currentPageData = null;
                this.persistedIterator = null;
                this.queryBuilder = null;
            }
            return hasNext;
        }

        @Override
        public T next() {
            if (this.persistedIterator != null) {
                return (Identifiable)this.persistedIterator.next();
            }
            if (this.currentPageData == null) {
                throw new NoSuchElementException();
            }
            int indexOnPage = this.currentPosition++ % 100;
            Identifiable result = null;
            if (indexOnPage < this.currentPageData.size()) {
                result = (Identifiable)this.currentPageData.get(indexOnPage);
            }
            if (indexOnPage == this.currentPageData.size() - 1) {
                this.getNextPage();
            }
            return result;
        }

        private void getNextPage() {
            if (this.currentPageData == null || this.nextPageData == null || this.nextPageData.isEmpty()) {
                this.nextPageData = null;
                this.currentPageData = null;
                return;
            }
            this.currentPageData = this.nextPageData;
            if (this.currentPageData.size() < 100) {
                this.nextPageData = null;
                return;
            }
            if (BackendlessDataCollection.this.preservedData == null) {
                this.nextPageData = BackendlessDataCollection.this.iDataStore.find(this.queryBuilder.prepareNextPage());
                if (this.nextPageData.size() < 100) {
                    BackendlessDataCollection.this.size = this.currentPosition + this.currentPageData.size() + this.nextPageData.size();
                }
            } else {
                this.nextPageData = new ArrayList();
                int nextPageNumber = this.currentPosition / 100 + 1;
                this.loadNextPageUsingLocalDataIfPresent(nextPageNumber, this.nextPageData);
            }
        }

        private boolean loadNextPageUsingLocalDataIfPresent(int pageNumber, List<T> target) {
            int startLoadIndex = pageNumber * 100;
            int lastLoadIndex = startLoadIndex + 100;
            if (this.loadedData != null) {
                int tmpLastIndex = Math.min(this.loadedData.length, lastLoadIndex);
                for (int i = startLoadIndex; i < tmpLastIndex; ++i) {
                    target.add(this.loadedData[i]);
                }
                startLoadIndex = tmpLastIndex;
            }
            boolean fullPage = true;
            if (target.size() < 100) {
                this.loadedData = null;
                fullPage = this.loadPartialData(startLoadIndex, lastLoadIndex - startLoadIndex, target);
            }
            return fullPage;
        }

        private boolean loadPartialData(int pOffset, int pPageSize, List<T> target) {
            boolean fullPage;
            this.queryBuilder.setOffset(pOffset).setPageSize(pPageSize);
            List lackingObjects = BackendlessDataCollection.this.iDataStore.find(this.queryBuilder);
            this.queryBuilder.setPageSize(100);
            target.addAll(lackingObjects);
            for (Identifiable obj : lackingObjects) {
                BackendlessDataCollection.this.preservedData.put(obj.getObjectId(), obj);
            }
            boolean bl = fullPage = lackingObjects.size() == pPageSize;
            if (!fullPage) {
                BackendlessDataCollection.this.size = pOffset + pPageSize - 1;
                BackendlessDataCollection.this.isLoaded = true;
            }
            return fullPage;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    public static interface Identifiable<T> {
        public String getObjectId();

        public void setObjectId(String var1);
    }
}

