/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.persistence.AbstractBackendlessQuery;
import com.backendless.persistence.QueryOptions;
import java.util.ArrayList;
import java.util.List;

public class BackendlessDataQuery
extends AbstractBackendlessQuery {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_OFFSET = 0;
    private boolean distinct = false;
    private final ArrayList<String> properties = new ArrayList();
    private final ArrayList<String> excludeProperties = new ArrayList();
    private String whereClause;
    private QueryOptions queryOptions;
    private final List<String> groupBy = new ArrayList<String>();
    private String havingClause = "";

    public BackendlessDataQuery() {
    }

    public BackendlessDataQuery(List<String> properties) {
        this.properties.addAll(properties);
    }

    public BackendlessDataQuery(String whereClause) {
        this.whereClause = whereClause;
    }

    public BackendlessDataQuery(QueryOptions queryOptions) {
        this.queryOptions = queryOptions;
    }

    public BackendlessDataQuery(List<String> properties, String whereClause, QueryOptions queryOptions, List<String> groupBy, String havingClause) {
        this.setProperties(properties);
        this.whereClause = whereClause;
        this.queryOptions = queryOptions;
        this.setGroupBy(groupBy);
        this.havingClause = havingClause;
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public BackendlessDataQuery setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public List<String> getProperties() {
        return (List)this.properties.clone();
    }

    public void setProperties(List<String> properties) {
        this.properties.clear();
        if (properties != null) {
            for (String prop : properties) {
                this.addProperty(prop);
            }
        }
    }

    public void addProperties(String ... properties) {
        if (properties != null) {
            for (String prop : properties) {
                this.addProperty(prop);
            }
        }
    }

    public void addProperty(String property) {
        if (property != null && !property.equals("")) {
            this.properties.add(property);
        }
    }

    public ArrayList<String> getExcludeProperties() {
        return (ArrayList)this.excludeProperties.clone();
    }

    public void setExcludeProperties(ArrayList<String> excludeProperties) {
        this.excludeProperties.clear();
        if (excludeProperties != null) {
            for (String exclProp : excludeProperties) {
                this.setExcludeProperty(exclProp);
            }
        }
    }

    public void setExcludeProperties(String ... excludeProperties) {
        this.excludeProperties.clear();
        if (excludeProperties != null) {
            for (String exclProp : excludeProperties) {
                this.setExcludeProperty(exclProp);
            }
        }
    }

    public void setExcludeProperty(String excludeProperty) {
        if (excludeProperty != null && !excludeProperty.isEmpty()) {
            this.excludeProperties.add(excludeProperty);
        }
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(String whereClause) {
        this.whereClause = whereClause;
    }

    public QueryOptions getQueryOptions() {
        if (this.queryOptions == null) {
            return null;
        }
        return this.queryOptions.newInstance();
    }

    public void setQueryOptions(QueryOptions queryOptions) {
        this.queryOptions = queryOptions;
    }

    public List<String> getGroupBy() {
        return new ArrayList<String>(this.groupBy);
    }

    public void setGroupBy(List<String> groupBy) {
        this.groupBy.clear();
        for (String grb : groupBy) {
            if (grb == null || grb.equals("")) continue;
            this.groupBy.add(grb);
        }
    }

    public String getHavingClause() {
        return this.havingClause;
    }

    public void setHavingClause(String havingClause) {
        this.havingClause = havingClause;
    }

    @Override
    public BackendlessDataQuery newInstance() {
        BackendlessDataQuery result = new BackendlessDataQuery();
        result.setDistinct(this.getDistinct());
        result.setProperties(this.getProperties());
        result.setWhereClause(this.whereClause);
        result.setQueryOptions(this.getQueryOptions());
        result.setGroupBy(this.groupBy);
        result.setHavingClause(this.havingClause);
        return result;
    }
}

