/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.persistence.GeoJSONParser;
import com.backendless.persistence.Geometry;
import com.backendless.persistence.GeometryDTO;
import com.backendless.persistence.WKTParser;
import java.lang.reflect.Type;
import java.util.Map;
import weborb.reader.AnonymousObject;
import weborb.reader.CacheableAdaptingTypeWrapper;
import weborb.reader.NamedObject;
import weborb.reader.NullType;
import weborb.reader.ReferenceCache;
import weborb.reader.StringType;
import weborb.types.IAdaptingType;
import weborb.util.IArgumentObjectFactory;

public class BackendlessGeometryFactory
implements IArgumentObjectFactory {
    public Object createObject(IAdaptingType adaptingType) {
        if (adaptingType instanceof CacheableAdaptingTypeWrapper) {
            adaptingType = ((CacheableAdaptingTypeWrapper)adaptingType).getType();
        }
        if (adaptingType instanceof NamedObject) {
            adaptingType = ((NamedObject)adaptingType).getTypedObject();
        }
        if (adaptingType.getClass() == NullType.class) {
            return null;
        }
        ReferenceCache refCache = ReferenceCache.getInstance();
        if (refCache.hasObject(adaptingType, GeometryDTO.class)) {
            return refCache.getObject(adaptingType, GeometryDTO.class);
        }
        if (adaptingType instanceof AnonymousObject) {
            Map properties = (Map)adaptingType.defaultAdapt();
            String geoJson = (String)properties.get("geoJson");
            String javaType = (String)properties.get("___class");
            if (geoJson == null) {
                if (javaType == null) {
                    return null;
                }
                return new GeoJSONParser().read(properties);
            }
            String geomClass = (String)properties.get("geomClass");
            Integer srsId = (Integer)properties.get("srsId");
            Geometry geometry = new GeometryDTO(geomClass, srsId, geoJson).toGeometry();
            refCache.addObject(adaptingType, GeometryDTO.class, (Object)geometry);
            return geometry;
        }
        if (adaptingType instanceof StringType) {
            String wkt = ((StringType)adaptingType).getValue();
            return new WKTParser().read(wkt);
        }
        throw new RuntimeException("Can not create BackendlessGeometry from type " + adaptingType.getClass().getName());
    }

    public boolean canAdapt(IAdaptingType adaptingType, Type type) {
        return false;
    }
}

