/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.BackendlessInjector;
import com.backendless.BackendlessUser;
import com.backendless.FootprintsManager;
import com.backendless.exceptions.BackendlessException;
import com.backendless.persistence.DefaultSerializer;
import com.backendless.persistence.Geometry;
import com.backendless.persistence.IObjectSerializer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weborb.util.CacheUtils;
import weborb.util.ObjectInspector;

public abstract class BackendlessSerializer {
    private static final HashMap<Class, IObjectSerializer> serializers = new HashMap();
    private static final IObjectSerializer DEFAULT_SERIALIZER = new DefaultSerializer();

    public abstract boolean shouldTraverse();

    public static void addSerializer(Class clazz, IObjectSerializer serializer) {
        serializers.put(clazz, serializer);
    }

    public static Map<String, Object> serializeToMap(Object entity) {
        IObjectSerializer serializer = BackendlessSerializer.getSerializer(entity.getClass());
        return (Map)serializer.serializeToMap(entity, new HashMap<Object, Map<String, Object>>());
    }

    public static String getSimpleName(Class clazz) {
        IObjectSerializer serializer = BackendlessSerializer.getSerializer(clazz);
        return serializer.getClassName(clazz);
    }

    public static Class getClassForDeserialization(Class clazz) {
        IObjectSerializer serializer = BackendlessSerializer.getSerializer(clazz);
        return serializer.getSerializationFriendlyClass(clazz);
    }

    public Object serializeToMap(Object entity, Map<Object, Map<String, Object>> serializedCache) {
        if (entity.getClass().isArray()) {
            return this.serializeArray(entity, serializedCache);
        }
        if (entity.getClass().isEnum()) {
            return ((Enum)entity).name();
        }
        Map<Object, Object> serializedEntity = new HashMap();
        if (entity.getClass() == BackendlessUser.class) {
            serializedEntity = ((BackendlessUser)entity).getProperties();
        } else {
            CacheUtils.cacheStaticField((String)entity.getClass().getName(), (String)"serialVersionUID");
            ObjectInspector.getObjectProperties(entity.getClass(), (Object)entity, serializedEntity, new ArrayList(), (boolean)true, (boolean)this.shouldTraverse());
        }
        serializedCache.put(entity, serializedEntity);
        FootprintsManager.getInstance().Inner.putMissingPropsToEntityMap(entity, serializedEntity);
        serializedEntity.put("___class", BackendlessSerializer.getSimpleName(entity.getClass()));
        Iterator<Map.Entry<Object, Object>> entityIterator = serializedEntity.entrySet().iterator();
        while (entityIterator.hasNext()) {
            ArrayList<Object> newCollection;
            Map.Entry<Object, Object> entityEntry = entityIterator.next();
            if (((String)entityEntry.getKey()).contains("$")) {
                entityIterator.remove();
                continue;
            }
            if (BackendlessInjector.getInstance().isAndroid() && ((String)entityEntry.getKey()).equals("CREATOR")) {
                entityIterator.remove();
                continue;
            }
            Object entityEntryValue = entityEntry.getValue();
            if (entityEntryValue == null) continue;
            if (entityEntryValue.getClass().isAnonymousClass()) {
                throw new BackendlessException(String.format("Anonymous class properties are prohibited: %s", entityEntry.getKey()));
            }
            if (entityEntryValue instanceof List) {
                List listEntry = (List)entityEntryValue;
                if (listEntry.isEmpty()) {
                    if (serializedEntity.containsKey("objectId") && serializedEntity.get("objectId") != null) continue;
                    entityIterator.remove();
                    continue;
                }
                if (listEntry.iterator().next().getClass().isAnonymousClass()) {
                    throw new BackendlessException(String.format("Anonymous class properties are prohibited: %s", entityEntry.getKey()));
                }
                newCollection = new ArrayList<Object>();
                for (Object listEntryItem : listEntry) {
                    if (!BackendlessSerializer.isBelongsJdk(listEntryItem.getClass())) {
                        newCollection.add(this.getOrMakeSerializedObject(listEntryItem, serializedCache));
                        continue;
                    }
                    newCollection.add(listEntryItem);
                }
                entityEntry.setValue(newCollection);
                continue;
            }
            if (entityEntryValue instanceof Object[]) {
                Object[] arrayEntry = (Object[])entityEntryValue;
                if (arrayEntry.length == 0) continue;
                if (arrayEntry[0].getClass().isAnonymousClass()) {
                    throw new BackendlessException(String.format("Anonymous class properties are prohibited: %s", entityEntry.getKey()));
                }
                newCollection = new ArrayList();
                for (Object arrayEntryItem : arrayEntry) {
                    if (!BackendlessSerializer.isBelongsJdk(arrayEntryItem.getClass())) {
                        newCollection.add(this.getOrMakeSerializedObject(arrayEntryItem, serializedCache));
                        continue;
                    }
                    newCollection.add(arrayEntryItem);
                }
                entityEntry.setValue(newCollection);
                continue;
            }
            if (entityEntryValue instanceof Geometry || BackendlessSerializer.isBelongsJdk(entityEntryValue.getClass())) continue;
            entityEntry.setValue(this.getOrMakeSerializedObject(entityEntryValue, serializedCache));
        }
        return serializedEntity;
    }

    private Object serializeArray(Object entity, Map<Object, Map<String, Object>> serializedCache) {
        int length = Array.getLength(entity);
        Object[] objects = new Object[length];
        for (int i = 0; i < length; ++i) {
            objects[i] = this.getOrMakeSerializedObject(Array.get(entity, i), serializedCache);
        }
        return objects;
    }

    private Object getOrMakeSerializedObject(Object entityEntryValue, Map<Object, Map<String, Object>> serializedCache) {
        if (serializedCache.containsKey(entityEntryValue)) {
            return serializedCache.get(entityEntryValue);
        }
        return this.serializeToMap(entityEntryValue, serializedCache);
    }

    public static void serializeUserProperties(BackendlessUser user) {
        Map<String, Object> serializedProperties = user.getProperties();
        Set<Map.Entry<String, Object>> properties = serializedProperties.entrySet();
        for (Map.Entry<String, Object> property : properties) {
            Object propertyValue = property.getValue();
            if (propertyValue == null || propertyValue.getClass().isArray() || propertyValue.getClass().isEnum() || BackendlessSerializer.isBelongsJdk(propertyValue.getClass())) continue;
            property.setValue(BackendlessSerializer.serializeToMap(propertyValue));
        }
        user.setProperties(serializedProperties);
    }

    public static boolean isBelongsJdk(Class clazz) {
        return clazz.getClassLoader() == "".getClass().getClassLoader();
    }

    private static IObjectSerializer getSerializer(Class clazz) {
        Iterator<Map.Entry<Class, IObjectSerializer>> iterator = serializers.entrySet().iterator();
        IObjectSerializer serializer = DEFAULT_SERIALIZER;
        while (iterator.hasNext()) {
            Map.Entry<Class, IObjectSerializer> entry = iterator.next();
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            serializer = entry.getValue();
            break;
        }
        return serializer;
    }
}

