/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.persistence.BackendlessDataQuery;
import com.backendless.persistence.PagedQueryBuilder;
import com.backendless.persistence.QueryOptionsBuilder;
import java.util.ArrayList;
import java.util.List;

public class DataQueryBuilder {
    private final PagedQueryBuilder<DataQueryBuilder> pagedQueryBuilder;
    private final QueryOptionsBuilder<DataQueryBuilder> queryOptionsBuilder;
    private boolean distinct = false;
    private final ArrayList<String> properties = new ArrayList();
    private final ArrayList<String> excludeProperties = new ArrayList();
    private String whereClause;
    private final List<String> groupBy;
    private String havingClause = "";

    private DataQueryBuilder() {
        this.pagedQueryBuilder = new PagedQueryBuilder<DataQueryBuilder>(this);
        this.queryOptionsBuilder = new QueryOptionsBuilder<DataQueryBuilder>(this);
        this.groupBy = new ArrayList<String>();
    }

    public static DataQueryBuilder create() {
        return new DataQueryBuilder();
    }

    public BackendlessDataQuery build() {
        BackendlessDataQuery dataQuery = this.pagedQueryBuilder.build();
        dataQuery.setDistinct(this.getDistinct());
        dataQuery.setQueryOptions(this.queryOptionsBuilder.build());
        dataQuery.setProperties(this.properties);
        dataQuery.setExcludeProperties(this.excludeProperties);
        dataQuery.setWhereClause(this.whereClause);
        dataQuery.setGroupBy(this.groupBy);
        dataQuery.setHavingClause(this.havingClause);
        return dataQuery;
    }

    public DataQueryBuilder setPageSize(int pageSize) {
        return this.pagedQueryBuilder.setPageSize(pageSize);
    }

    public DataQueryBuilder setOffset(int offset) {
        return this.pagedQueryBuilder.setOffset(offset);
    }

    public DataQueryBuilder prepareNextPage() {
        return this.pagedQueryBuilder.prepareNextPage();
    }

    public DataQueryBuilder preparePreviousPage() {
        return this.pagedQueryBuilder.preparePreviousPage();
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public DataQueryBuilder setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public List<String> getProperties() {
        return (List)this.properties.clone();
    }

    public DataQueryBuilder setProperties(List<String> properties) {
        this.properties.clear();
        if (properties != null) {
            for (String prop : properties) {
                this.addProperty(prop);
            }
        }
        return this;
    }

    public DataQueryBuilder setProperties(String ... properties) {
        this.properties.clear();
        this.addProperties(properties);
        return this;
    }

    public DataQueryBuilder addProperties(String ... properties) {
        if (properties != null) {
            for (String prop : properties) {
                this.addProperty(prop);
            }
        }
        return this;
    }

    public DataQueryBuilder addProperty(String property) {
        if (property != null && !property.equals("")) {
            this.properties.add(property);
        }
        return this;
    }

    public DataQueryBuilder addAllProperties() {
        this.addProperty("*");
        return this;
    }

    public ArrayList<String> getExcludedProperties() {
        return (ArrayList)this.excludeProperties.clone();
    }

    public DataQueryBuilder excludeProperties(ArrayList<String> excludeProperties) {
        this.excludeProperties.clear();
        if (excludeProperties != null) {
            for (String exclProp : excludeProperties) {
                this.excludeProperty(exclProp);
            }
        }
        return this;
    }

    public DataQueryBuilder excludeProperties(String ... excludeProperties) {
        this.excludeProperties.clear();
        if (excludeProperties != null) {
            for (String exclProp : excludeProperties) {
                this.excludeProperty(exclProp);
            }
        }
        return this;
    }

    public DataQueryBuilder excludeProperty(String excludeProperty) {
        if (excludeProperty != null && !excludeProperty.isEmpty()) {
            this.excludeProperties.add(excludeProperty);
        }
        return this;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public DataQueryBuilder setWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public List<String> getSortBy() {
        return this.queryOptionsBuilder.getSortBy();
    }

    public DataQueryBuilder setSortBy(List<String> sortBy) {
        return this.queryOptionsBuilder.setSortBy(sortBy);
    }

    public DataQueryBuilder setSortBy(String ... sortBy) {
        return this.queryOptionsBuilder.setSortBy(sortBy);
    }

    public DataQueryBuilder addSortBy(String sortBy) {
        return this.queryOptionsBuilder.addSortBy(sortBy);
    }

    public List<String> getRelated() {
        return this.queryOptionsBuilder.getRelated();
    }

    public DataQueryBuilder setRelated(List<String> related) {
        return this.queryOptionsBuilder.setRelated(related);
    }

    public DataQueryBuilder setRelated(String ... related) {
        return this.queryOptionsBuilder.setRelated(related);
    }

    public DataQueryBuilder setFileReferencePrefix(String fileReferencePrefix) {
        return this.queryOptionsBuilder.setFileReferencePrefix(fileReferencePrefix);
    }

    public DataQueryBuilder addRelated(List<String> related) {
        return this.queryOptionsBuilder.addRelated(related);
    }

    public DataQueryBuilder addRelated(String related) {
        return this.queryOptionsBuilder.addRelated(related);
    }

    public Integer getRelationsDepth() {
        return this.queryOptionsBuilder.getRelationsDepth();
    }

    public DataQueryBuilder setRelationsDepth(Integer relationsDepth) {
        return this.queryOptionsBuilder.setRelationsDepth(relationsDepth);
    }

    public List<String> getGroupBy() {
        return new ArrayList<String>(this.groupBy);
    }

    public DataQueryBuilder setGroupBy(String ... groupBy) {
        this.groupBy.clear();
        this.addGroupBy(groupBy);
        return this;
    }

    public DataQueryBuilder addGroupBy(String ... groupBy) {
        for (String grb : groupBy) {
            if (grb == null || grb.equals("")) continue;
            this.groupBy.add(grb);
        }
        return this;
    }

    public String getHavingClause() {
        return this.havingClause;
    }

    public DataQueryBuilder setHavingClause(String havingClause) {
        this.havingClause = havingClause;
        return this;
    }

    public DataQueryBuilder setRelationsPageSize(Integer relationsPageSize) {
        return this.queryOptionsBuilder.setRelationsPageSize(relationsPageSize);
    }

    public Integer getRelationPageSize() {
        return this.queryOptionsBuilder.getRelationsPageSize();
    }
}

