/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.commons.persistence.group.GroupingColumnValue;
import com.backendless.persistence.BackendlessGroupDataQuery;
import com.backendless.persistence.PagedGroupQueryBuilder;
import com.backendless.persistence.QueryOptionsBuilder;
import java.util.ArrayList;
import java.util.List;

public class GroupDataQueryBuilder {
    private final PagedGroupQueryBuilder<GroupDataQueryBuilder> pagedQueryBuilder;
    private final QueryOptionsBuilder<GroupDataQueryBuilder> queryOptionsBuilder;
    private boolean distinct = false;
    private List<GroupingColumnValue> groupPath;
    private int groupDepth;
    private final ArrayList<String> properties = new ArrayList();
    private final ArrayList<String> excludeProperties = new ArrayList();
    private String whereClause;
    private final List<String> groupBy;

    private GroupDataQueryBuilder() {
        this.pagedQueryBuilder = new PagedGroupQueryBuilder<GroupDataQueryBuilder>(this);
        this.queryOptionsBuilder = new QueryOptionsBuilder<GroupDataQueryBuilder>(this);
        this.groupBy = new ArrayList<String>();
        this.groupPath = new ArrayList<GroupingColumnValue>();
    }

    public static GroupDataQueryBuilder create() {
        return new GroupDataQueryBuilder();
    }

    public BackendlessGroupDataQuery build() {
        BackendlessGroupDataQuery dataQuery = this.pagedQueryBuilder.build();
        dataQuery.setDistinct(this.getDistinct());
        dataQuery.setQueryOptions(this.queryOptionsBuilder.build());
        dataQuery.setProperties(this.properties);
        dataQuery.setExcludeProperties(this.excludeProperties);
        dataQuery.setWhereClause(this.whereClause);
        dataQuery.setGroupBy(this.groupBy);
        dataQuery.setGroupPath(this.groupPath);
        dataQuery.setGroupDepth(this.groupDepth);
        return dataQuery;
    }

    public GroupDataQueryBuilder setPageSize(int pageSize) {
        return this.pagedQueryBuilder.setPageSize(pageSize);
    }

    public GroupDataQueryBuilder setGroupPageSize(int groupPageSize) {
        return this.pagedQueryBuilder.setGroupPageSize(groupPageSize);
    }

    public GroupDataQueryBuilder setRecordsPageSize(int recordsPageSize) {
        return this.pagedQueryBuilder.setRecordsPageSize(recordsPageSize);
    }

    public GroupDataQueryBuilder setOffset(int offset) {
        return this.pagedQueryBuilder.setOffset(offset);
    }

    public GroupDataQueryBuilder prepareNextPage() {
        return this.pagedQueryBuilder.prepareNextPage();
    }

    public GroupDataQueryBuilder preparePreviousPage() {
        return this.pagedQueryBuilder.preparePreviousPage();
    }

    public boolean getDistinct() {
        return this.distinct;
    }

    public List<GroupingColumnValue> getGroupPath() {
        return new ArrayList<GroupingColumnValue>(this.groupPath);
    }

    public GroupDataQueryBuilder setGroupPath(List<GroupingColumnValue> groupPath) {
        this.groupPath = new ArrayList<GroupingColumnValue>(groupPath);
        return this;
    }

    public List<String> getProperties() {
        return (List)this.properties.clone();
    }

    public GroupDataQueryBuilder setProperties(List<String> properties) {
        this.properties.clear();
        if (properties != null) {
            for (String prop : properties) {
                this.addProperty(prop);
            }
        }
        return this;
    }

    public GroupDataQueryBuilder setProperties(String ... properties) {
        this.properties.clear();
        this.addProperties(properties);
        return this;
    }

    public GroupDataQueryBuilder addProperties(String ... properties) {
        if (properties != null) {
            for (String prop : properties) {
                this.addProperty(prop);
            }
        }
        return this;
    }

    public GroupDataQueryBuilder addProperty(String property) {
        if (property != null && !property.equals("")) {
            this.properties.add(property);
        }
        return this;
    }

    public GroupDataQueryBuilder addAllProperties() {
        this.addProperty("*");
        return this;
    }

    public ArrayList<String> getExcludedProperties() {
        return (ArrayList)this.excludeProperties.clone();
    }

    public GroupDataQueryBuilder excludeProperties(ArrayList<String> excludeProperties) {
        this.excludeProperties.clear();
        if (excludeProperties != null) {
            for (String exclProp : excludeProperties) {
                this.excludeProperty(exclProp);
            }
        }
        return this;
    }

    public GroupDataQueryBuilder excludeProperties(String ... excludeProperties) {
        this.excludeProperties.clear();
        if (excludeProperties != null) {
            for (String exclProp : excludeProperties) {
                this.excludeProperty(exclProp);
            }
        }
        return this;
    }

    public GroupDataQueryBuilder excludeProperty(String excludeProperty) {
        if (excludeProperty != null && !excludeProperty.isEmpty()) {
            this.excludeProperties.add(excludeProperty);
        }
        return this;
    }

    public List<String> getSortBy() {
        return this.queryOptionsBuilder.getSortBy();
    }

    public GroupDataQueryBuilder setSortBy(List<String> sortBy) {
        return this.queryOptionsBuilder.setSortBy(sortBy);
    }

    public GroupDataQueryBuilder setSortBy(String ... sortBy) {
        return this.queryOptionsBuilder.setSortBy(sortBy);
    }

    public GroupDataQueryBuilder addSortBy(String sortBy) {
        return this.queryOptionsBuilder.addSortBy(sortBy);
    }

    public List<String> getRelated() {
        return this.queryOptionsBuilder.getRelated();
    }

    public GroupDataQueryBuilder setRelated(List<String> related) {
        return this.queryOptionsBuilder.setRelated(related);
    }

    public GroupDataQueryBuilder setRelated(String ... related) {
        return this.queryOptionsBuilder.setRelated(related);
    }

    public GroupDataQueryBuilder setFileReferencePrefix(String fileReferencePrefix) {
        return this.queryOptionsBuilder.setFileReferencePrefix(fileReferencePrefix);
    }

    public GroupDataQueryBuilder addRelated(List<String> related) {
        return this.queryOptionsBuilder.addRelated(related);
    }

    public GroupDataQueryBuilder addRelated(String related) {
        return this.queryOptionsBuilder.addRelated(related);
    }

    public Integer getRelationsDepth() {
        return this.queryOptionsBuilder.getRelationsDepth();
    }

    public GroupDataQueryBuilder setRelationsDepth(Integer relationsDepth) {
        return this.queryOptionsBuilder.setRelationsDepth(relationsDepth);
    }

    public List<String> getGroupBy() {
        return new ArrayList<String>(this.groupBy);
    }

    public GroupDataQueryBuilder setGroupBy(String ... groupBy) {
        this.groupBy.clear();
        this.addGroupBy(groupBy);
        return this;
    }

    public GroupDataQueryBuilder addGroupBy(String ... groupBy) {
        for (String grb : groupBy) {
            if (grb == null || grb.equals("")) continue;
            if (!grb.startsWith("'") && !grb.endsWith("'")) {
                grb = "'" + grb + "'";
            }
            this.groupBy.add(grb);
        }
        return this;
    }

    public GroupDataQueryBuilder setRelationsPageSize(Integer relationsPageSize) {
        return this.queryOptionsBuilder.setRelationsPageSize(relationsPageSize);
    }

    public Integer getRelationPageSize() {
        return this.queryOptionsBuilder.getRelationsPageSize();
    }

    public GroupDataQueryBuilder setDistinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }

    public GroupDataQueryBuilder setGroupDepth(int groupDepth) {
        this.groupDepth = groupDepth;
        return this;
    }

    public int getGroupDepth() {
        return this.groupDepth;
    }

    public GroupDataQueryBuilder setWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public String getWhereClause() {
        return this.whereClause;
    }
}

