/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.persistence.JsonDTO;
import com.backendless.util.JSONUtil;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import weborb.exceptions.AdaptingException;
import weborb.reader.ReferenceCache;
import weborb.types.ICacheableAdaptingType;

public class JsonDTOAdaptingType
implements ICacheableAdaptingType {
    private String rawJsonString;

    public JsonDTOAdaptingType() {
    }

    public JsonDTOAdaptingType(String rawJsonString) {
        this.rawJsonString = rawJsonString;
    }

    public String getRawJsonString() {
        return this.rawJsonString;
    }

    public void setRawJsonString(String value) {
        this.rawJsonString = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonDTO)) {
            return false;
        }
        JsonDTOAdaptingType jsonDTO = (JsonDTOAdaptingType)o;
        return Objects.equals(this.rawJsonString, jsonDTO.rawJsonString);
    }

    public int hashCode() {
        return Objects.hash(this.rawJsonString);
    }

    public Class getDefaultType() {
        return Map.class;
    }

    public Object defaultAdapt() {
        return this.defaultAdapt(null);
    }

    public Object adapt(Type type) throws AdaptingException {
        return this.adapt(type, null);
    }

    public boolean canAdaptTo(Type type) {
        return true;
    }

    public Object defaultAdapt(ReferenceCache referenceCache) {
        try {
            return this.adapt((Type)((Object)Object.class), referenceCache);
        }
        catch (AdaptingException exception) {
            throw new RuntimeException("unable to adapt JSON value to HashMap");
        }
    }

    public Object adapt(Type type, ReferenceCache referenceCache) throws AdaptingException {
        if (this.getRawJsonString() == null) {
            return null;
        }
        Object result = JSONUtil.getJsonConverter().readObject(this.getRawJsonString(), type);
        return result;
    }
}

