/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.exceptions.ExceptionMessage;
import com.backendless.persistence.BackendlessDataQuery;
import com.backendless.persistence.PagedQueryBuilder;
import com.backendless.persistence.QueryOptions;
import com.backendless.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class LoadRelationsQueryBuilder<R> {
    private String relationName;
    private final Class<R> relationType;
    private final PagedQueryBuilder<LoadRelationsQueryBuilder<R>> pagedQueryBuilder = new PagedQueryBuilder<LoadRelationsQueryBuilder>(this);
    private List<String> properties;
    private List<String> sortBy;

    private LoadRelationsQueryBuilder(Class<R> relationType) {
        this.relationType = relationType;
        this.properties = new ArrayList<String>();
        this.sortBy = new ArrayList<String>();
    }

    public static LoadRelationsQueryBuilder<Map<String, Object>> ofMap() {
        LoadRelationsQueryBuilder<Map<String, Object>> queryBuilder = new LoadRelationsQueryBuilder<Map<String, Object>>(Map.class);
        return queryBuilder;
    }

    public static <R> LoadRelationsQueryBuilder<R> of(Class<R> relationType) {
        return new LoadRelationsQueryBuilder<R>(relationType);
    }

    public BackendlessDataQuery build() {
        StringUtils.checkEmpty(this.relationName, ExceptionMessage.NULL_FIELD("relationName"));
        BackendlessDataQuery dataQuery = this.pagedQueryBuilder.build();
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setRelated(Collections.singletonList(this.relationName));
        queryOptions.setSortBy(this.sortBy);
        dataQuery.setQueryOptions(queryOptions);
        dataQuery.setProperties(this.properties);
        return dataQuery;
    }

    public LoadRelationsQueryBuilder<R> setRelationName(String relationName) {
        this.relationName = relationName;
        return this;
    }

    public LoadRelationsQueryBuilder<R> setPageSize(int pageSize) {
        return this.pagedQueryBuilder.setPageSize(pageSize);
    }

    public LoadRelationsQueryBuilder<R> setOffset(int offset) {
        return this.pagedQueryBuilder.setOffset(offset);
    }

    public LoadRelationsQueryBuilder<R> prepareNextPage() {
        return this.pagedQueryBuilder.prepareNextPage();
    }

    public LoadRelationsQueryBuilder<R> preparePreviousPage() {
        return this.pagedQueryBuilder.preparePreviousPage();
    }

    public Class<R> getRelationType() {
        return this.relationType;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public LoadRelationsQueryBuilder<R> setProperties(List<String> properties) {
        this.properties = properties;
        return this;
    }

    public LoadRelationsQueryBuilder<R> setProperties(String ... properties) {
        this.properties = new ArrayList<String>();
        Collections.addAll(this.properties, properties);
        return this;
    }

    public LoadRelationsQueryBuilder<R> addProperty(List<String> properties) {
        this.properties.addAll(properties);
        return this;
    }

    public LoadRelationsQueryBuilder<R> addProperty(String ... properties) {
        Collections.addAll(this.properties, properties);
        return this;
    }

    public LoadRelationsQueryBuilder<R> addProperty(String property) {
        this.properties.add(property);
        return this;
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    public LoadRelationsQueryBuilder<R> setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public LoadRelationsQueryBuilder<R> setSortBy(String ... sortBy) {
        this.sortBy = new ArrayList<String>();
        Collections.addAll(this.sortBy, sortBy);
        return this;
    }

    public LoadRelationsQueryBuilder<R> addSortBy(List<String> sortBy) {
        this.sortBy.addAll(sortBy);
        return this;
    }

    public LoadRelationsQueryBuilder<R> addSortBy(String ... sortBy) {
        Collections.addAll(this.sortBy, sortBy);
        return this;
    }

    public LoadRelationsQueryBuilder<R> addSortBy(String sortBy) {
        this.sortBy.add(sortBy);
        return this;
    }
}

