/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.IDataStore;
import com.backendless.Invoker;
import com.backendless.Persistence;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.commons.persistence.GroupResult;
import com.backendless.core.responder.AdaptingResponder;
import com.backendless.exceptions.BackendlessException;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.exceptions.ExceptionMessage;
import com.backendless.persistence.BackendlessDataQuery;
import com.backendless.persistence.BackendlessGroupDataQuery;
import com.backendless.persistence.DataQueryBuilder;
import com.backendless.persistence.GroupDataQueryBuilder;
import com.backendless.persistence.LoadRelationsQueryBuilder;
import com.backendless.rt.data.EventHandler;
import com.backendless.utils.ResponderHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weborb.client.Fault;
import weborb.client.IChainedResponder;
import weborb.client.IRawResponder;
import weborb.client.IResponder;
import weborb.exceptions.AdaptingException;
import weborb.reader.AnonymousObject;
import weborb.reader.NamedObject;
import weborb.types.IAdaptingType;
import weborb.v3types.ErrMessage;

public class MapDrivenDataStore
implements IDataStore<Map> {
    private final String tableName;
    private final Persistence persistence;
    private final EventHandler<Map> eventHandler;

    public MapDrivenDataStore(String tableName, Persistence persistence, EventHandler<Map> eventHandler) {
        this.tableName = tableName;
        this.persistence = persistence;
        this.eventHandler = eventHandler;
    }

    @Override
    public List<String> create(List<Map> objects) throws BackendlessException {
        return this.create(objects, null, false);
    }

    @Override
    public void create(List<Map> objects, AsyncCallback<List<String>> responder) {
        this.create(objects, responder, true);
    }

    private List<String> create(List<Map> objects, AsyncCallback<List<String>> responder, boolean async) throws BackendlessException {
        if (objects == null) {
            throw new IllegalArgumentException("Object array for bulk operations cannot be null");
        }
        if (objects.isEmpty()) {
            return new ArrayList<String>();
        }
        Object[] args = new Object[]{this.tableName, objects};
        if (!async) {
            return (List)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "createBulk", args, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(String.class));
        }
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "createBulk", args, responder, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(String.class));
        return null;
    }

    @Override
    public Map save(Map entity) throws BackendlessException {
        return this.save(entity, false);
    }

    @Override
    public Map save(Map entity, boolean isUpsert) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        Object[] args = new Object[]{this.tableName, entity};
        String methodName = isUpsert ? "upsert" : "save";
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", methodName, args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public void save(Map entity, AsyncCallback<Map> responder) {
        this.save(entity, false, responder);
    }

    @Override
    public void save(Map entity, boolean isUpsert, AsyncCallback<Map> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Object[] args = new Object[]{this.tableName, entity};
                String methodName = isUpsert ? "upsert" : "save";
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", methodName, args, responder, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public Map deepSave(Map entity) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        Object[] args = new Object[]{this.tableName, entity};
        Map newEntity = (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "deepSave", args, (IChainedResponder)new MapDrivenResponder());
        return newEntity;
    }

    @Override
    public void deepSave(Map entity, AsyncCallback<Map> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Object[] args = new Object[]{this.tableName, entity};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "deepSave", args, responder, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public Long remove(Map entity) throws BackendlessException {
        if (entity == null) {
            throw new IllegalArgumentException("Entity cannot be null.");
        }
        Object[] args = new Object[]{this.tableName, entity};
        Object result = Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "remove", args);
        return ((Number)result).longValue();
    }

    @Override
    public void remove(Map entity, final AsyncCallback<Long> responder) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                AsyncCallback<Object> removalCallback = new AsyncCallback<Object>(){

                    @Override
                    public void handleResponse(Object response) {
                        responder.handleResponse(((Number)response).longValue());
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                };
                Object[] args = new Object[]{this.tableName, entity};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "remove", args, removalCallback);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public int remove(String whereClause) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, whereClause};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "removeBulk", args);
    }

    @Override
    public void remove(String whereClause, AsyncCallback<Integer> responder) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, whereClause};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "removeBulk", args, responder);
    }

    @Override
    public int update(String whereClause, Map<String, Object> changes) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, whereClause, changes};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "updateBulk", args);
    }

    @Override
    public void update(String whereClause, Map<String, Object> changes, AsyncCallback<Integer> responder) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, whereClause, changes};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "updateBulk", args, responder);
    }

    @Override
    public Map findFirst() throws BackendlessException {
        Object[] args = new Object[]{this.tableName};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "first", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public Map findFirst(Integer relationsDepth) throws BackendlessException {
        return this.findFirst(Collections.emptyList(), relationsDepth, (Integer)null);
    }

    @Override
    public Map findFirst(List<String> relations) throws BackendlessException {
        return this.findFirst((List)relations, (Integer)null, (Integer)null);
    }

    @Override
    public Map findFirst(List<String> relations, Integer relationsDepth, Integer relationsPageSize) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, relations, relationsDepth, relationsPageSize};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "first", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public void findFirst(AsyncCallback<Map> callback) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "first", args, callback, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (callback == null) break block2;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public void findFirst(Integer relationsDepth, AsyncCallback<Map> callback) {
        this.findFirst(Collections.emptyList(), relationsDepth, (Integer)null, callback);
    }

    @Override
    public void findFirst(List<String> relations, AsyncCallback<Map> callback) {
        this.findFirst(relations, (Integer)null, (Integer)null, callback);
    }

    @Override
    public void findFirst(List<String> relations, Integer relationsDepth, Integer relationsPageSize, AsyncCallback<Map> callback) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName, relations, relationsDepth, relationsPageSize};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "first", args, callback, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (callback == null) break block2;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public Map findLast() throws BackendlessException {
        Object[] args = new Object[]{this.tableName};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "last", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public Map findLast(Integer relationsDepth) throws BackendlessException {
        return this.findLast(Collections.emptyList(), relationsDepth, (Integer)null);
    }

    @Override
    public Map findLast(List<String> relations) throws BackendlessException {
        return this.findLast((List)relations, (Integer)null, (Integer)null);
    }

    @Override
    public Map findLast(List<String> relations, Integer relationsDepth, Integer relationsPageSize) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, relations, relationsDepth, relationsPageSize};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "last", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public void findLast(AsyncCallback<Map> callback) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "last", args, callback, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (callback == null) break block2;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public void findLast(Integer relationsDepth, AsyncCallback<Map> callback) {
        this.findLast(Collections.emptyList(), relationsDepth, (Integer)null, callback);
    }

    @Override
    public void findLast(List<String> relations, AsyncCallback<Map> callback) {
        this.findLast(relations, (Integer)null, (Integer)null, callback);
    }

    @Override
    public void findLast(List<String> relations, Integer relationsDepth, Integer relationPageSize, AsyncCallback<Map> callback) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName, relations, relationsDepth};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "last", args, callback, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (callback == null) break block2;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public List<Map> find() throws BackendlessException {
        return this.find(DataQueryBuilder.create());
    }

    @Override
    public List<Map> find(DataQueryBuilder dataQuery) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, dataQuery.build()};
        return (List)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "find", args, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(HashMap.class));
    }

    @Override
    public void find(AsyncCallback<List<Map>> callback) {
        this.find(DataQueryBuilder.create(), callback);
    }

    @Override
    public void find(DataQueryBuilder dataQuery, AsyncCallback<List<Map>> callback) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName, dataQuery.build()};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "find", args, callback, (IChainedResponder)ResponderHelper.getCollectionAdaptingResponder(HashMap.class));
            }
            catch (Throwable e) {
                if (callback == null) break block2;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public GroupResult<?, Map> group(GroupDataQueryBuilder dataQuery) {
        Object[] args = new Object[]{this.tableName, dataQuery.build()};
        return (GroupResult)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "group", args, (IChainedResponder)ResponderHelper.getGroupResultAdaptingResponder(HashMap.class));
    }

    @Override
    public void group(GroupDataQueryBuilder dataQuery, AsyncCallback<GroupResult<?, Map>> callback) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName, dataQuery.build()};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "group", args, callback, (IChainedResponder)ResponderHelper.getGroupResultAdaptingResponder(HashMap.class));
            }
            catch (Throwable e) {
                if (callback == null) break block2;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public Map findById(String id) throws BackendlessException {
        return this.findById(id, Collections.emptyList());
    }

    @Override
    public Map findById(String id, List<String> relations) throws BackendlessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null or empty.");
        }
        Object[] args = new Object[]{this.tableName, id, relations};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "findById", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public Map findById(String id, Integer relationsDepth) throws BackendlessException {
        return this.findById(id, Collections.emptyList(), relationsDepth);
    }

    @Override
    public Map findById(String id, List<String> relations, Integer relationsDepth) throws BackendlessException {
        if (id == null) {
            throw new IllegalArgumentException("Id cannot be null or empty.");
        }
        Object[] args = new Object[]{this.tableName, id, relations, relationsDepth};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "findById", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public Map findById(Map entity) throws BackendlessException {
        return this.findById(entity, Collections.emptyList(), (Integer)null);
    }

    @Override
    public Map findById(Map entity, List<String> relations) throws BackendlessException {
        return this.findById(entity, relations, (Integer)null);
    }

    @Override
    public Map findById(Map entity, Integer relationsDepth) throws BackendlessException {
        return this.findById(entity, Collections.emptyList(), relationsDepth);
    }

    @Override
    public Map findById(Map entity, List<String> relations, Integer relationsDepth) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, entity, relations, relationsDepth};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "findById", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public void findById(String id, AsyncCallback<Map> callback) {
        this.findById(id, Collections.emptyList(), callback);
    }

    @Override
    public void findById(String id, List<String> relations, AsyncCallback<Map> callback) {
        this.findById(id, relations, (Integer)null, callback);
    }

    @Override
    public void findById(String id, Integer relationsDepth, AsyncCallback<Map> callback) {
        this.findById(id, Collections.emptyList(), relationsDepth, callback);
    }

    @Override
    public void findById(String id, List<String> relations, Integer relationsDepth, AsyncCallback<Map> callback) {
        block3: {
            try {
                if (id == null) {
                    throw new IllegalArgumentException("Id cannot be null or empty.");
                }
                Object[] args = new Object[]{this.tableName, id, relations, relationsDepth};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "findById", args, callback, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (callback == null) break block3;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public void findById(Map entity, AsyncCallback<Map> callback) {
        this.findById(entity, Collections.emptyList(), callback);
    }

    @Override
    public void findById(Map entity, List<String> relations, AsyncCallback<Map> callback) {
        this.findById(entity, relations, (Integer)null, callback);
    }

    @Override
    public void findById(Map entity, Integer relationsDepth, AsyncCallback<Map> callback) {
        this.findById(entity, Collections.emptyList(), relationsDepth, callback);
    }

    @Override
    public void findById(Map entity, List<String> relations, Integer relationsDepth, AsyncCallback<Map> callback) {
        block3: {
            try {
                if (entity == null) {
                    throw new IllegalArgumentException("Entity cannot be null.");
                }
                Object[] args = new Object[]{this.tableName, entity, relations, relationsDepth};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "findById", args, callback, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (callback == null) break block3;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public Map findById(String id, DataQueryBuilder queryBuilder) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, id, queryBuilder.build()};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "findById", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public Map findById(Map entity, DataQueryBuilder queryBuilder) throws BackendlessException {
        Object[] args = new Object[]{this.tableName, entity, queryBuilder.build()};
        return (Map)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "findById", args, (IChainedResponder)new MapDrivenResponder());
    }

    @Override
    public void findById(String id, DataQueryBuilder queryBuilder, AsyncCallback<Map> callback) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName, id, queryBuilder.build()};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "findById", args, callback, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (callback == null) break block2;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public void findById(Map entity, DataQueryBuilder queryBuilder, AsyncCallback<Map> callback) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName, entity, queryBuilder.build()};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "findById", args, callback, (IChainedResponder)new MapDrivenResponder());
            }
            catch (Throwable e) {
                if (callback == null) break block2;
                callback.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public <R> List<R> loadRelations(String objectId, LoadRelationsQueryBuilder<R> queryBuilder) {
        return this.persistence.loadRelations(this.tableName, objectId, queryBuilder, queryBuilder.getRelationType());
    }

    @Override
    public <R> void loadRelations(String objectId, LoadRelationsQueryBuilder<R> queryBuilder, AsyncCallback<List<R>> callback) {
        this.persistence.loadRelations(this.tableName, objectId, queryBuilder, queryBuilder.getRelationType(), callback);
    }

    @Override
    public int getObjectCount() {
        Object[] args = new Object[]{this.tableName};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "count", args);
    }

    @Override
    public int getObjectCount(DataQueryBuilder dataQueryBuilder) {
        if (dataQueryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("dataQueryBuilder"));
        }
        BackendlessDataQuery dataQuery = dataQueryBuilder.build();
        Object[] args = new Object[]{this.tableName, dataQuery};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "count", args);
    }

    @Override
    public int getObjectCountInGroup(GroupDataQueryBuilder dataQueryBuilder) {
        if (dataQueryBuilder == null) {
            throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("dataQueryBuilder"));
        }
        BackendlessGroupDataQuery dataQuery = dataQueryBuilder.build();
        Object[] args = new Object[]{this.tableName, dataQuery};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "countInGroup", args);
    }

    @Override
    public void getObjectCount(AsyncCallback<Integer> responder) {
        block2: {
            try {
                Object[] args = new Object[]{this.tableName};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "count", args, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block2;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public void getObjectCount(DataQueryBuilder dataQueryBuilder, AsyncCallback<Integer> responder) {
        block3: {
            try {
                if (dataQueryBuilder == null) {
                    throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("dataQueryBuilder"));
                }
                BackendlessDataQuery dataQuery = dataQueryBuilder.build();
                Object[] args = new Object[]{this.tableName, dataQuery};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "count", args, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public void getObjectCountInGroup(GroupDataQueryBuilder dataQueryBuilder, AsyncCallback<Integer> responder) {
        block3: {
            try {
                if (dataQueryBuilder == null) {
                    throw new IllegalArgumentException(ExceptionMessage.NULL_FIELD("dataQueryBuilder"));
                }
                BackendlessGroupDataQuery dataQuery = dataQueryBuilder.build();
                Object[] args = new Object[]{this.tableName, dataQuery};
                Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "countInGroup", args, responder);
            }
            catch (Throwable e) {
                if (responder == null) break block3;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    @Override
    public <R> int addRelation(Map parent, String relationColumnName, Collection<R> children) {
        String parentObjectId = (String)parent.get("objectId");
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = child instanceof Map ? (String)((Map)child).get("objectId") : Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        return this.addRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds);
    }

    @Override
    public <R> void addRelation(Map parent, String relationColumnName, Collection<R> children, AsyncCallback<Integer> callback) {
        String parentObjectId = (String)parent.get("objectId");
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = child instanceof Map ? (String)((Map)child).get("objectId") : Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        this.addRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds, callback);
    }

    @Override
    public int addRelation(Map parent, String relationColumnName, String whereClause) {
        String parentObjectId = (String)parent.get("objectId");
        return this.addRelation(parentObjectId, relationColumnName, whereClause);
    }

    @Override
    public void addRelation(Map parent, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentObjectId = (String)parent.get("objectId");
        this.addRelation(parentObjectId, relationColumnName, whereClause, callback);
    }

    @Override
    public <R> int setRelation(Map parent, String relationColumnName, Collection<R> children) {
        String parentObjectId = (String)parent.get("objectId");
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = child instanceof Map ? (String)((Map)child).get("objectId") : Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        return this.setRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds);
    }

    @Override
    public <R> void setRelation(Map parent, String relationColumnName, Collection<R> children, AsyncCallback<Integer> callback) {
        String parentObjectId = (String)parent.get("objectId");
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = child instanceof Map ? (String)((Map)child).get("objectId") : Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        this.setRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds, callback);
    }

    @Override
    public int setRelation(Map parent, String relationColumnName, String whereClause) {
        String parentObjectId = (String)parent.get("objectId");
        return this.setRelation(parentObjectId, relationColumnName, whereClause);
    }

    @Override
    public void setRelation(Map parent, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentObjectId = (String)parent.get("objectId");
        this.setRelation(parentObjectId, relationColumnName, whereClause, callback);
    }

    @Override
    public <R> int deleteRelation(Map parent, String relationColumnName, Collection<R> children) {
        String parentObjectId = (String)parent.get("objectId");
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = child instanceof Map ? (String)((Map)child).get("objectId") : Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        return this.deleteRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds);
    }

    @Override
    public <R> void deleteRelation(Map parent, String relationColumnName, Collection<R> children, AsyncCallback<Integer> callback) {
        String parentObjectId = (String)parent.get("objectId");
        ArrayList<String> childrenObjectIds = new ArrayList<String>();
        for (R child : children) {
            String childObjectId = child instanceof Map ? (String)((Map)child).get("objectId") : Persistence.getEntityId(child);
            childrenObjectIds.add(childObjectId);
        }
        this.deleteRelation(parentObjectId, relationColumnName, (Collection<String>)childrenObjectIds, callback);
    }

    @Override
    public int deleteRelation(Map parent, String relationColumnName, String whereClause) {
        String parentObjectId = (String)parent.get("objectId");
        return this.deleteRelation(parentObjectId, relationColumnName, whereClause);
    }

    @Override
    public void deleteRelation(Map parent, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        String parentObjectId = (String)parent.get("objectId");
        this.deleteRelation(parentObjectId, relationColumnName, whereClause, callback);
    }

    @Override
    public <R> int addRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, childrenObjectIds};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "addRelation", args);
    }

    @Override
    public <R> void addRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds, AsyncCallback<Integer> callback) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, childrenObjectIds};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "addRelation", args, callback);
    }

    @Override
    public int addRelation(String parentObjectId, String relationColumnName, String whereClause) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, whereClause};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "addRelation", args);
    }

    @Override
    public void addRelation(String parentObjectId, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, whereClause};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "addRelation", args, callback);
    }

    @Override
    public <R> int setRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, childrenObjectIds};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "setRelation", args);
    }

    @Override
    public <R> void setRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds, AsyncCallback<Integer> callback) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, childrenObjectIds};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "setRelation", args, callback);
    }

    @Override
    public int setRelation(String parentObjectId, String relationColumnName, String whereClause) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, whereClause};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "setRelation", args);
    }

    @Override
    public void setRelation(String parentObjectId, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, whereClause};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "setRelation", args, callback);
    }

    @Override
    public <R> int deleteRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, childrenObjectIds};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "deleteRelation", args);
    }

    @Override
    public <R> void deleteRelation(String parentObjectId, String relationColumnName, Collection<String> childrenObjectIds, AsyncCallback<Integer> callback) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, childrenObjectIds};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "deleteRelation", args, callback);
    }

    @Override
    public int deleteRelation(String parentObjectId, String relationColumnName, String whereClause) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, whereClause};
        return (Integer)Invoker.invokeSync("com.backendless.services.persistence.PersistenceService", "deleteRelation", args);
    }

    @Override
    public void deleteRelation(String parentObjectId, String relationColumnName, String whereClause, AsyncCallback<Integer> callback) {
        Object[] args = new Object[]{this.tableName, relationColumnName, parentObjectId, whereClause};
        Invoker.invokeAsync("com.backendless.services.persistence.PersistenceService", "deleteRelation", args, callback);
    }

    @Override
    public EventHandler<Map> rt() {
        return this.eventHandler;
    }

    private static class MapDrivenResponder
    implements IRawResponder {
        private IResponder nextResponder;

        private MapDrivenResponder() {
        }

        public void setNextResponder(IResponder iResponder) {
            this.nextResponder = iResponder;
        }

        public void responseHandler(Object adaptingType) {
            IAdaptingType type = (IAdaptingType)adaptingType;
            IAdaptingType bodyHolder = ((NamedObject)type).getTypedObject();
            if (((IAdaptingType)adaptingType).getDefaultType().equals(ErrMessage.class)) {
                if (this.nextResponder != null) {
                    this.nextResponder.errorHandler((Fault)AdaptingResponder.adaptFault((AnonymousObject)bodyHolder));
                }
            } else {
                IAdaptingType entity = (IAdaptingType)((AnonymousObject)bodyHolder).getProperties().get("body");
                try {
                    Object adaptedEntity = entity.adapt(HashMap.class);
                    if (this.nextResponder != null) {
                        this.nextResponder.responseHandler(adaptedEntity);
                    }
                }
                catch (AdaptingException e) {
                    this.errorHandler(new BackendlessFault(e));
                }
            }
        }

        public void errorHandler(Fault fault) {
            this.nextResponder.errorHandler(fault);
        }
    }
}

