/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.persistence.BackendlessDataQuery;

class PagedQueryBuilder<Builder> {
    private int pageSize = 10;
    private int offset = 0;
    private Builder builder;

    PagedQueryBuilder(Builder builder) {
        this.builder = builder;
    }

    Builder setPageSize(int pageSize) {
        this.validatePageSize(pageSize);
        this.pageSize = pageSize;
        return this.builder;
    }

    Builder setOffset(int offset) {
        this.validateOffset(offset);
        this.offset = offset;
        return this.builder;
    }

    Builder prepareNextPage() {
        int offset = this.offset + this.pageSize;
        this.validateOffset(offset);
        this.offset = offset;
        return this.builder;
    }

    Builder preparePreviousPage() {
        int offset = this.offset - this.pageSize;
        this.validateOffset(offset);
        this.offset = offset;
        return this.builder;
    }

    BackendlessDataQuery build() {
        this.validateOffset(this.offset);
        this.validatePageSize(this.pageSize);
        BackendlessDataQuery dataQuery = new BackendlessDataQuery();
        dataQuery.setPageSize(this.pageSize);
        dataQuery.setOffset(this.offset);
        return dataQuery;
    }

    private void validateOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException("Offset cannot have a negative value.");
        }
    }

    private void validatePageSize(int pageSize) {
        if (pageSize <= 0) {
            throw new IllegalArgumentException("Pagesize cannot have a negative value.");
        }
    }
}

