/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import java.util.ArrayList;
import java.util.List;

public class QueryOptions {
    private List<String> sortBy = new ArrayList<String>();
    private List<String> related = new ArrayList<String>();
    private Integer relationsDepth;
    private Integer relationsPageSize;
    private String fileReferencePrefix;

    public QueryOptions(String sortBy) {
        this.addSortByOption(sortBy);
    }

    public void addSortByOption(String sortBy) {
        if (sortBy == null || sortBy.equals("")) {
            return;
        }
        if (this.sortBy == null) {
            this.sortBy = new ArrayList<String>();
        }
        this.sortBy.add(sortBy);
    }

    public void addRelated(String related) {
        if (related == null || related.equals("")) {
            return;
        }
        if (this.related == null) {
            this.related = new ArrayList<String>();
        }
        this.related.add(related);
    }

    public List<String> getSortBy() {
        if (this.sortBy == null) {
            this.sortBy = new ArrayList<String>();
            return this.sortBy;
        }
        return new ArrayList<String>(this.sortBy);
    }

    public List<String> getRelated() {
        if (this.related == null) {
            this.related = new ArrayList<String>();
            return this.related;
        }
        return new ArrayList<String>(this.related);
    }

    public QueryOptions newInstance() {
        QueryOptions result = new QueryOptions();
        result.setSortBy(this.sortBy);
        result.setRelated(this.related);
        result.setRelationsDepth(this.relationsDepth);
        result.setRelationsPageSize(this.relationsPageSize);
        result.setFileReferencePrefix(this.fileReferencePrefix);
        return result;
    }

    public QueryOptions() {
    }

    public void setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
    }

    public void setRelated(List<String> related) {
        this.related = related;
    }

    public Integer getRelationsDepth() {
        return this.relationsDepth;
    }

    public void setRelationsDepth(Integer relationsDepth) {
        this.relationsDepth = relationsDepth;
    }

    public Integer getRelationsPageSize() {
        return this.relationsPageSize;
    }

    public void setRelationsPageSize(Integer relationsPageSize) {
        this.relationsPageSize = relationsPageSize;
    }

    public String getFileReferencePrefix() {
        return this.fileReferencePrefix;
    }

    public void setFileReferencePrefix(String fileReferencePrefix) {
        this.fileReferencePrefix = fileReferencePrefix;
    }
}

