/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.persistence;

import com.backendless.persistence.QueryOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class QueryOptionsBuilder<Builder> {
    private List<String> sortBy = new ArrayList<String>();
    private List<String> related = new ArrayList<String>();
    private Integer relationsDepth;
    private Integer relationsPageSize;
    private String fileReferencePrefix;
    private final Builder builder;

    QueryOptionsBuilder(Builder builder) {
        this.builder = builder;
    }

    QueryOptions build() {
        QueryOptions queryOptions = new QueryOptions();
        queryOptions.setRelated(this.related);
        queryOptions.setRelationsDepth(this.relationsDepth);
        queryOptions.setSortBy(this.sortBy);
        queryOptions.setRelationsPageSize(this.relationsPageSize);
        queryOptions.setFileReferencePrefix(this.fileReferencePrefix);
        return queryOptions;
    }

    public Builder setSortBy(List<String> sortBy) {
        this.sortBy = sortBy;
        return this.builder;
    }

    public Builder setSortBy(String ... sortBy) {
        this.sortBy = new ArrayList<String>(Arrays.asList(sortBy));
        return this.builder;
    }

    public Builder addSortBy(String sortBy) {
        this.sortBy.add(sortBy);
        return this.builder;
    }

    public Builder setRelated(List<String> related) {
        this.related = related;
        return this.builder;
    }

    public Builder setRelated(String ... related) {
        this.related = new ArrayList<String>(Arrays.asList(related));
        return this.builder;
    }

    public Builder addRelated(List<String> related) {
        this.related.addAll(related);
        return this.builder;
    }

    public Builder addRelated(String related) {
        this.related.add(related);
        return this.builder;
    }

    public Builder setRelationsDepth(Integer relationsDepth) {
        this.relationsDepth = relationsDepth;
        return this.builder;
    }

    public Builder setRelationsPageSize(Integer relationPageSize) {
        this.relationsPageSize = relationPageSize;
        return this.builder;
    }

    public Builder setFileReferencePrefix(String fileReferencePrefix) {
        this.fileReferencePrefix = fileReferencePrefix;
        return this.builder;
    }

    public List<String> getSortBy() {
        return this.sortBy;
    }

    public List<String> getRelated() {
        return this.related;
    }

    public Integer getRelationsDepth() {
        return this.relationsDepth;
    }

    public Integer getRelationsPageSize() {
        return this.relationsPageSize;
    }

    public String getFileReferencePrefix() {
        return this.fileReferencePrefix;
    }
}

