/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.push;

import com.backendless.BackendlessInjector;
import com.backendless.BackendlessPrefs;
import com.backendless.DeviceRegistration;
import com.backendless.Invoker;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessFault;
import java.util.Date;
import java.util.List;

public class DeviceRegistrationUtil {
    static final String DEVICE_REGISTRATION_MANAGER_SERVER_ALIAS = "com.backendless.services.messaging.DeviceRegistrationService";
    private static final DeviceRegistrationUtil instance = new DeviceRegistrationUtil();
    private final BackendlessPrefs prefs = BackendlessInjector.getInstance().getPrefs();

    private DeviceRegistrationUtil() {
    }

    public static DeviceRegistrationUtil getInstance() {
        return instance;
    }

    public static String getDeviceRegistrationManagerServerAlias() {
        return DEVICE_REGISTRATION_MANAGER_SERVER_ALIAS;
    }

    public String registerDeviceOnServer(String deviceToken, List<String> channels, long expiration) {
        if (deviceToken == null) {
            throw new IllegalArgumentException("Null device token received");
        }
        DeviceRegistration deviceRegistration = new DeviceRegistration();
        deviceRegistration.setDeviceId(this.prefs.getDeviceId());
        deviceRegistration.setOs(this.prefs.getOs());
        deviceRegistration.setOsVersion(this.prefs.getOsVersion());
        deviceRegistration.setDeviceToken(deviceToken);
        deviceRegistration.setChannels(channels);
        if (expiration != 0L) {
            deviceRegistration.setExpiration(new Date(expiration));
        }
        return (String)Invoker.invokeSync(DEVICE_REGISTRATION_MANAGER_SERVER_ALIAS, "registerDevice", new Object[]{deviceRegistration});
    }

    public void registerDeviceOnServer(String deviceToken, List<String> channels, long expiration, final AsyncCallback<String> responder) {
        block4: {
            try {
                if (deviceToken == null) {
                    throw new IllegalArgumentException("Null device token received");
                }
                DeviceRegistration deviceRegistration = new DeviceRegistration();
                deviceRegistration.setDeviceId(this.prefs.getDeviceId());
                deviceRegistration.setOs(this.prefs.getOs());
                deviceRegistration.setOsVersion(this.prefs.getOsVersion());
                deviceRegistration.setDeviceToken(deviceToken);
                deviceRegistration.setChannels(channels);
                if (expiration != 0L) {
                    deviceRegistration.setExpiration(new Date(expiration));
                }
                Invoker.invokeAsync(DEVICE_REGISTRATION_MANAGER_SERVER_ALIAS, "registerDevice", new Object[]{deviceRegistration}, new AsyncCallback<String>(){

                    @Override
                    public void handleResponse(String response) {
                        if (responder != null) {
                            responder.handleResponse(response);
                        }
                    }

                    @Override
                    public void handleFault(BackendlessFault fault) {
                        if (responder != null) {
                            responder.handleFault(fault);
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (responder == null) break block4;
                responder.handleFault(new BackendlessFault(e));
            }
        }
    }

    public boolean unregisterDeviceOnServer() {
        return (Boolean)Invoker.invokeSync(DEVICE_REGISTRATION_MANAGER_SERVER_ALIAS, "unregisterDevice", new Object[]{this.prefs.getDeviceId()});
    }

    public void unregisterDeviceOnServer(AsyncCallback<Boolean> responder) {
        Invoker.invokeAsync(DEVICE_REGISTRATION_MANAGER_SERVER_ALIAS, "unregisterDevice", new Object[]{this.prefs.getDeviceId()}, responder);
    }

    public int unregisterDeviceOnServer(List<String> channels) {
        return (Integer)Invoker.invokeSync(DEVICE_REGISTRATION_MANAGER_SERVER_ALIAS, "unregisterDevice", new Object[]{this.prefs.getDeviceId(), channels});
    }

    public void unregisterDeviceOnServer(List<String> channels, AsyncCallback<Integer> responder) {
        Invoker.invokeAsync(DEVICE_REGISTRATION_MANAGER_SERVER_ALIAS, "unregisterDevice", new Object[]{this.prefs.getDeviceId(), channels}, responder);
    }
}

