/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt;

import com.backendless.BackendlessInjector;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.rt.AbstractRequest;
import com.backendless.rt.RTCallback;
import com.backendless.rt.RTClient;
import com.backendless.rt.RTSubscription;
import java.util.concurrent.CopyOnWriteArrayList;
import weborb.types.IAdaptingType;

public abstract class ConnectListener<T extends RTSubscription> {
    private final CopyOnWriteArrayList<AsyncCallback<Void>> connectedCallbacks = new CopyOnWriteArrayList();
    private final RTClient rtClient = BackendlessInjector.getInstance().getRtClient();
    private volatile boolean connected;
    private final T connectSubscription;

    public ConnectListener(String subject) {
        this.connectSubscription = this.createConnectSubscription(subject);
    }

    public void connect() {
        this.rtClient.subscribe((RTSubscription)this.connectSubscription);
    }

    private T createConnectSubscription(String subject) {
        return this.createSubscription(new RTCallback(){

            @Override
            public AsyncCallback usersCallback() {
                return null;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                ConnectListener.this.connected = true;
                for (AsyncCallback connectedCallback : ConnectListener.this.connectedCallbacks) {
                    connectedCallback.handleResponse(null);
                }
                ConnectListener.this.connected();
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                ConnectListener.this.connected = false;
                for (AsyncCallback connectedCallback : ConnectListener.this.connectedCallbacks) {
                    connectedCallback.handleFault(fault);
                }
            }
        });
    }

    public void disconnect() {
        this.rtClient.unsubscribe(((AbstractRequest)this.connectSubscription).getId());
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void addConnectListener(AsyncCallback<Void> callback) {
        if (this.connected) {
            callback.handleResponse(null);
        }
        this.connectedCallbacks.add(callback);
    }

    public void removeConnectListener(AsyncCallback<Void> callback) {
        this.connectedCallbacks.remove(callback);
    }

    public void removeConnectListeners() {
        this.connectedCallbacks.clear();
    }

    public abstract void connected();

    public abstract T createSubscription(RTCallback var1);
}

