/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt;

import com.backendless.BackendlessInjector;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.rt.ConnectListener;
import com.backendless.rt.RTCallback;
import com.backendless.rt.RTCallbackWithFault;
import com.backendless.rt.RTClient;
import com.backendless.rt.RTMethodRequest;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Level;
import java.util.logging.Logger;
import weborb.exceptions.AdaptingException;
import weborb.types.IAdaptingType;

public abstract class MethodRequestHelper {
    private static final Logger logger = Logger.getLogger("MethodRequestHelper");
    private final RTClient rtClient = BackendlessInjector.getInstance().getRtClient();
    private final ConcurrentLinkedDeque<RTMethodRequest> methodsToSend = new ConcurrentLinkedDeque();
    private final ConnectListener connectListener;

    protected MethodRequestHelper(ConnectListener connectListener) {
        this.connectListener = connectListener;
    }

    public abstract RTMethodRequest createMethodRequest(RTCallback var1);

    public void connected() {
        RTMethodRequest methodRequest = this.methodsToSend.poll();
        while (methodRequest != null) {
            this.rtClient.invoke(methodRequest);
            methodRequest = this.methodsToSend.poll();
        }
    }

    public void invoke(final AsyncCallback<Void> callback) {
        logger.log(Level.FINE, "Send invocation with options");
        RTMethodRequest rtMethodRequest = this.createMethodRequest(new RTCallbackWithFault(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                logger.info("invocation sent");
                if (callback != null) {
                    callback.handleResponse(null);
                }
            }
        });
        this.invoke(rtMethodRequest);
    }

    public <T> void invoke(final Class<T> tClass, final AsyncCallback<T> callback) {
        logger.log(Level.FINE, "Send invocation with options");
        RTMethodRequest rtMethodRequest = this.createMethodRequest(new RTCallbackWithFault(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                logger.info("got result");
                if (callback != null) {
                    if (response == null) {
                        callback.handleResponse(null);
                    } else {
                        try {
                            callback.handleResponse(response.adapt((Type)tClass));
                        }
                        catch (AdaptingException e) {
                            callback.handleFault(new BackendlessFault(e.getMessage()));
                        }
                    }
                }
            }
        });
        this.invoke(rtMethodRequest);
    }

    public void invokeWithDefaultAdapt(final AsyncCallback<Object> callback) {
        logger.log(Level.FINE, "Send invocation with options");
        RTMethodRequest rtMethodRequest = this.createMethodRequest(new RTCallbackWithFault(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                logger.info("got result");
                if (callback != null) {
                    if (response == null) {
                        callback.handleResponse(null);
                    } else {
                        callback.handleResponse(response.defaultAdapt());
                    }
                }
            }
        });
        this.invoke(rtMethodRequest);
    }

    private void invoke(RTMethodRequest rtMethodRequest) {
        if (this.isConnected()) {
            this.rtClient.invoke(rtMethodRequest);
        } else {
            this.methodsToSend.addFirst(rtMethodRequest);
        }
    }

    private boolean isConnected() {
        return this.connectListener.isConnected();
    }
}

