/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt;

import com.backendless.BackendlessInjector;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.async.callback.Fault;
import com.backendless.async.callback.Result;
import com.backendless.async.message.AsyncMessage;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.rt.MethodTypes;
import com.backendless.rt.RTCallbackWithFault;
import com.backendless.rt.RTClient;
import com.backendless.rt.RTMethodRequest;
import com.backendless.rt.RTRequest;
import com.backendless.rt.RTSubscription;
import com.backendless.rt.ReconnectAttempt;
import com.backendless.rt.SocketIOConnectionManager;
import com.backendless.utils.WeborbSerializationHelper;
import io.socket.emitter.Emitter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.logging.Logger;
import weborb.reader.AnonymousObject;
import weborb.types.IAdaptingType;

class RTClientSocketIO
implements RTClient {
    private static final Logger logger = Logger.getLogger("RTClient");
    private final BackendlessInjector injector = BackendlessInjector.getInstance();
    private final Map<String, RTSubscription> subscriptions = new ConcurrentHashMap<String, RTSubscription>();
    private final Map<String, RTMethodRequest> sentRequests = new ConcurrentHashMap<String, RTMethodRequest>();
    private final ConcurrentLinkedDeque<RTMethodRequest> methodsToSend = new ConcurrentLinkedDeque();
    private final SocketIOConnectionManager connectionManager = new SocketIOConnectionManager(){

        @Override
        void connected() {
            RTClientSocketIO.this.resubscribe();
            RTClientSocketIO.this.connectCallback.handle(null);
        }

        @Override
        void reconnectAttempt(int attempt, int timeout) {
            RTClientSocketIO.this.reconnectAttemptCallback.handle(new ReconnectAttempt(attempt, timeout));
        }

        @Override
        void connectError(String error) {
            RTClientSocketIO.this.connectErrorCallback.handle(new BackendlessFault(error));
        }

        @Override
        void disconnected(String error) {
            RTClientSocketIO.this.disconnectCallback.handle(null);
        }

        @Override
        void subscriptionResult(Object ... args) {
            logger.info("subscription result " + Arrays.toString(args));
            RTClientSocketIO.this.handleResult(args, RTClientSocketIO.this.subscriptions, "data");
        }

        @Override
        void invocationResult(Object ... args) {
            logger.info("invocation result " + Arrays.toString(args));
            RTRequest request = RTClientSocketIO.this.handleResult(args, RTClientSocketIO.this.sentRequests, "result");
            if (request != null) {
                RTClientSocketIO.this.sentRequests.remove(request.getId());
            }
        }
    };
    private Result<Void> connectCallback;
    private Fault connectErrorCallback;
    private Result<String> disconnectCallback;
    private Result<ReconnectAttempt> reconnectAttemptCallback;

    RTClientSocketIO() {
    }

    private RTRequest handleResult(Object[] args, Map<String, ? extends RTRequest> requestMap, String resultKey) {
        if (args == null || args.length < 1) {
            logger.warning("subscription result is null or empty");
            return null;
        }
        AnonymousObject result = (AnonymousObject)WeborbSerializationHelper.deserializeNotAdapt(args[0]);
        String id = WeborbSerializationHelper.asString(result, "id");
        logger.info("Got result for subscription " + id);
        RTRequest request = requestMap.get(id);
        if (request == null) {
            logger.info("There is no handler for subscription " + id);
            return null;
        }
        Object error = WeborbSerializationHelper.asObject(result, "error");
        if (error != null) {
            logger.severe("got error " + error);
            BackendlessFault fault = new BackendlessFault(error.toString());
            this.injector.getHandleCarrier().deliverMessage(new AsyncMessage<IAdaptingType>(fault, request.getCallback()));
            return request;
        }
        IAdaptingType data = WeborbSerializationHelper.asAdaptingType(result, resultKey);
        this.injector.getHandleCarrier().deliverMessage(new AsyncMessage<IAdaptingType>(data, request.getCallback()));
        return request;
    }

    @Override
    public void subscribe(RTSubscription subscription) {
        logger.info("try to subscribe " + subscription);
        this.subscriptions.put(subscription.getId(), subscription);
        if (this.connectionManager.get().connected()) {
            this.subOn(subscription);
        }
    }

    @Override
    public void unsubscribe(String subscriptionId) {
        logger.info("unsubscribe for " + subscriptionId + " subscrition called");
        if (!this.subscriptions.containsKey(subscriptionId)) {
            logger.info("subscriber " + subscriptionId + " is not subscribed");
            return;
        }
        this.subOff(subscriptionId);
        this.subscriptions.remove(subscriptionId);
        logger.info("subscription removed");
        if (this.subscriptions.isEmpty() && this.sentRequests.isEmpty()) {
            this.connectionManager.disconnect();
        }
    }

    @Override
    public void userLoggedIn(String userToken) {
        if (this.connectionManager.isConnected()) {
            RTMethodRequest methodRequest = new RTMethodRequest(MethodTypes.SET_USER_TOKEN, new RTCallbackWithFault(){

                @Override
                public AsyncCallback usersCallback() {
                    return null;
                }

                @Override
                public void handleResponse(IAdaptingType response) {
                    logger.fine("user logged in/out success");
                }
            });
            methodRequest.putOption("userToken", userToken);
            this.invoke(methodRequest);
        }
    }

    @Override
    public void userLoggedOut() {
        this.userLoggedIn(null);
    }

    @Override
    public void invoke(RTMethodRequest methodRequest) {
        this.sentRequests.put(methodRequest.getId(), methodRequest);
        if (this.connectionManager.isConnected()) {
            this.metReq(methodRequest);
        } else {
            this.methodsToSend.addLast(methodRequest);
        }
    }

    @Override
    public void setConnectEventListener(Result<Void> callback) {
        this.connectCallback = callback;
    }

    @Override
    public void setReconnectAttemptEventListener(Result<ReconnectAttempt> callback) {
        this.reconnectAttemptCallback = callback;
    }

    @Override
    public void setConnectErrorEventListener(Fault fault) {
        this.connectErrorCallback = fault;
    }

    @Override
    public void setDisconnectEventListener(Result<String> callback) {
        this.disconnectCallback = callback;
    }

    @Override
    public boolean isConnected() {
        return this.connectionManager.isConnected();
    }

    @Override
    public void connect() {
        this.connectionManager.get();
    }

    @Override
    public void disconnect() {
        this.connectionManager.disconnect();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    private void resubscribe() {
        for (RTSubscription rtSubscription : this.subscriptions.values()) {
            this.subOn(rtSubscription);
        }
        RTMethodRequest methodRequest = this.methodsToSend.poll();
        while (methodRequest != null) {
            this.metReq(methodRequest);
            methodRequest = this.methodsToSend.poll();
        }
    }

    private Emitter subOn(RTSubscription subscription) {
        Emitter emitter = this.connectionManager.get().emit("SUB_ON", new Object[]{WeborbSerializationHelper.serialize(subscription.toArgs())});
        logger.info("subOn called");
        return emitter;
    }

    private Emitter subOff(String subscriptionId) {
        HashMap<String, String> request = new HashMap<String, String>();
        request.put("id", subscriptionId);
        Emitter emitter = this.connectionManager.get().emit("SUB_OFF", new Object[]{WeborbSerializationHelper.serialize(request)});
        logger.info("subOff called");
        return emitter;
    }

    private Emitter metReq(RTMethodRequest methodRequest) {
        Emitter emitter = this.connectionManager.get().emit("MET_REQ", new Object[]{WeborbSerializationHelper.serialize(methodRequest.toArgs())});
        logger.info("subOn called");
        return emitter;
    }
}

