/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt;

import com.backendless.BackendlessInjector;
import com.backendless.rt.RTClient;
import com.backendless.rt.RTListener;
import com.backendless.rt.RTSubscription;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RTListenerImpl
implements RTListener {
    private final Map<String, RTSubscription> subscriptions = new ConcurrentHashMap<String, RTSubscription>();
    private RTClient rt = BackendlessInjector.getInstance().getRtClient();

    protected void addEventListener(RTSubscription subscription) {
        this.subscriptions.put(subscription.getId(), subscription);
        this.rt.subscribe(subscription);
    }

    protected void removeEventListener(final RTSubscription subscription) {
        this.removeEventListener(new RTListener.Predicate(){

            @Override
            public boolean test(RTSubscription other) {
                return other.equals(subscription);
            }
        });
    }

    protected void removeEventListener(RTListener.Predicate criteria) {
        Iterator<RTSubscription> iterator = this.subscriptions.values().iterator();
        while (iterator.hasNext()) {
            RTSubscription rtSubscription = iterator.next();
            if (!criteria.test(rtSubscription)) continue;
            this.rt.unsubscribe(rtSubscription.getId());
            iterator.remove();
        }
    }
}

