/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt;

import com.backendless.Invoker;
import com.backendless.async.callback.Result;
import com.backendless.exceptions.BackendlessException;
import com.backendless.rt.ReconnectAttempt;
import com.backendless.utils.timeout.TimeOutManager;
import java.util.logging.Logger;

class RTLookupService {
    private static final Logger logger = Logger.getLogger("RTLookupService");
    private final Result<ReconnectAttempt> reconnectAttemptListener;
    private final TimeOutManager timeOutManager;

    RTLookupService(Result<ReconnectAttempt> reconnectAttemptListener, TimeOutManager timeOutManager) {
        this.reconnectAttemptListener = reconnectAttemptListener;
        this.timeOutManager = timeOutManager;
    }

    synchronized String lookup() {
        try {
            String rtServer = (String)Invoker.invokeSync("com.backendless.rt.RTService", "lookup", new Object[0]);
            return rtServer;
        }
        catch (BackendlessException e) {
            logger.severe("Lookup failed " + e);
            int retryTimeout = this.timeOutManager.nextTimeout();
            logger.info("Wait before lookup for " + retryTimeout);
            try {
                Thread.sleep(retryTimeout);
            }
            catch (InterruptedException e1) {
                throw new RuntimeException(e1);
            }
            if (this.reconnectAttemptListener != null) {
                this.reconnectAttemptListener.handle(new ReconnectAttempt(this.timeOutManager.repeatedTimes(), retryTimeout, e.toString()));
            }
            return this.lookup();
        }
    }
}

