/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt;

import com.backendless.BackendlessInjector;
import com.backendless.async.callback.Fault;
import com.backendless.async.callback.Result;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.rt.RTClient;
import com.backendless.rt.RTService;
import com.backendless.rt.ReconnectAttempt;
import java.util.concurrent.CopyOnWriteArrayList;

public class RTServiceImpl
implements RTService {
    private static final RTServiceImpl instance = new RTServiceImpl();
    private final RTClient rtClient = BackendlessInjector.getInstance().getRtClient();
    private final CopyOnWriteArrayList<Result<Void>> connectListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Result<String>> disconnectListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Result<ReconnectAttempt>> reconnectListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Fault> connectErrorListeners = new CopyOnWriteArrayList();

    public static RTServiceImpl getInstance() {
        return instance;
    }

    private RTServiceImpl() {
        if (this.rtClient.isAvailable()) {
            this.rtClient.setConnectEventListener(new Result<Void>(){

                @Override
                public void handle(Void result) {
                    RTServiceImpl.this.handle(result, RTServiceImpl.this.connectListeners);
                }
            });
            this.rtClient.setDisconnectEventListener(new Result<String>(){

                @Override
                public void handle(String result) {
                    RTServiceImpl.this.handle(result, RTServiceImpl.this.disconnectListeners);
                }
            });
            this.rtClient.setConnectErrorEventListener(new Fault(){

                @Override
                public void handle(BackendlessFault fault) {
                    RTServiceImpl.this.handle((Object)fault, RTServiceImpl.this.connectErrorListeners);
                }
            });
            this.rtClient.setReconnectAttemptEventListener(new Result<ReconnectAttempt>(){

                @Override
                public void handle(ReconnectAttempt result) {
                    RTServiceImpl.this.handle(result, RTServiceImpl.this.reconnectListeners);
                }
            });
        }
    }

    @Override
    public void addConnectListener(Result<Void> callback) {
        if (this.rtClient.isConnected()) {
            callback.handle(null);
        }
        this.connectListeners.add(callback);
    }

    @Override
    public void addReconnectAttemptListener(Result<ReconnectAttempt> callback) {
        this.reconnectListeners.add(callback);
    }

    @Override
    public void addConnectErrorListener(Fault fault) {
        this.connectErrorListeners.add(fault);
    }

    @Override
    public void removeConnectionListeners() {
        this.connectListeners.clear();
    }

    @Override
    public void addDisconnectListener(Result<String> callback) {
        this.disconnectListeners.add(callback);
    }

    @Override
    public <T extends Result> void removeListener(T callback) {
        if (this.connectErrorListeners.contains(callback)) {
            this.removeEventListeners((Fault)callback, this.connectErrorListeners);
        } else if (this.disconnectListeners.contains(callback)) {
            this.removeEventListeners(callback, this.disconnectListeners);
        } else if (this.connectListeners.contains(callback)) {
            this.removeEventListeners(callback, this.connectListeners);
        } else if (this.reconnectListeners.contains(callback)) {
            this.removeEventListeners(callback, this.reconnectListeners);
        }
    }

    @Override
    public void connect() {
        this.rtClient.connect();
    }

    @Override
    public void disconnect() {
        this.rtClient.disconnect();
    }

    private <T extends Result> void removeEventListeners(T callback, CopyOnWriteArrayList<T> listeners) {
        listeners.remove(callback);
    }

    private <T, E extends Result> void handle(T result, CopyOnWriteArrayList<E> listeners) {
        for (Result listener : listeners) {
            listener.handle(result);
        }
    }
}

