/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt;

import com.backendless.BackendlessInjector;
import com.backendless.IHeadersManager;
import com.backendless.async.callback.Result;
import com.backendless.rt.RTLookupService;
import com.backendless.rt.ReconnectAttempt;
import com.backendless.utils.timeout.TimeOutManager;
import com.backendless.utils.timeout.TimeOutManagerImpl;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.logging.Logger;

abstract class SocketIOConnectionManager {
    private static final Logger logger = Logger.getLogger("SocketIOConnectionManager");
    private final BackendlessInjector injector = BackendlessInjector.getInstance();
    private final Object lock = new Object();
    private final RTLookupService rtLookupService;
    private final TimeOutManager timeOutManager = new TimeOutManagerImpl();
    private Socket socket;

    SocketIOConnectionManager() {
        this.rtLookupService = new RTLookupService(new Result<ReconnectAttempt>(){

            @Override
            public void handle(ReconnectAttempt result) {
                SocketIOConnectionManager.this.reconnectAttempt(result.getAttempt(), result.getTimeout());
                SocketIOConnectionManager.this.connectError(result.getError());
            }
        }, this.timeOutManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Socket get() {
        if (this.socket != null || this.isConnected()) {
            logger.info("Socket is connected");
            return this.socket;
        }
        logger.info("Socket not connected. Try to get lock");
        Object object = this.lock;
        synchronized (object) {
            logger.info("Got lock");
            if (this.socket != null || this.isConnected()) {
                logger.info("Socket is connected");
                return this.socket;
            }
            IO.Options opts = new IO.Options();
            opts.reconnection = false;
            opts.path = "/" + this.injector.getPrefs().getApplicationIdOrDomain();
            opts.query = "apiKey=" + this.injector.getPrefs().getApiKey() + "&clientId=" + this.injector.getPrefs().getDeviceId() + "&binary=true";
            String host = this.rtLookupService.lookup() + opts.path;
            logger.info("Looked up for server " + host);
            String userToken = this.injector.getHeadersManager().getHeader(IHeadersManager.HeadersEnum.USER_TOKEN_KEY);
            if (userToken != null && !userToken.isEmpty()) {
                opts.query = opts.query + "&userToken=" + userToken;
            }
            logger.info("try to connect with to host with query: " + opts.query);
            try {
                this.socket = IO.socket((String)host, (IO.Options)opts);
                logger.info("Socket object created");
            }
            catch (RuntimeException | URISyntaxException e) {
                this.connectError(e.getMessage());
                logger.severe(e.getMessage());
                return this.get();
            }
            this.socket.on("connect", new Emitter.Listener(){

                public void call(Object ... args) {
                    logger.info("Connected event");
                    SocketIOConnectionManager.this.timeOutManager.reset();
                    SocketIOConnectionManager.this.connected();
                }
            }).on("disconnect", new Emitter.Listener(){

                public void call(Object ... args) {
                    String error = Arrays.toString(args);
                    logger.info("Disconnected event " + error);
                    SocketIOConnectionManager.this.disconnected(error);
                    SocketIOConnectionManager.this.reconnect();
                }
            }).on("connect_error", new Emitter.Listener(){

                public void call(Object ... args) {
                    String error = Arrays.toString(args);
                    logger.severe("Connection failed " + error);
                    SocketIOConnectionManager.this.connectError(error);
                    SocketIOConnectionManager.this.reconnect();
                }
            }).on("SUB_RES", new Emitter.Listener(){

                public void call(Object ... args) {
                    logger.info("Got sub res");
                    SocketIOConnectionManager.this.subscriptionResult(args);
                }
            }).on("MET_RES", new Emitter.Listener(){

                public void call(Object ... args) {
                    logger.info("Got met res");
                    SocketIOConnectionManager.this.invocationResult(args);
                }
            }).on("error", new Emitter.Listener(){

                public void call(Object ... args) {
                    String error = Arrays.toString(args);
                    logger.severe("ERROR from rt sever: " + error);
                    SocketIOConnectionManager.this.connectError(error);
                    SocketIOConnectionManager.this.reconnect();
                }
            });
            this.socket.connect();
        }
        return this.socket;
    }

    private void reconnect() {
        if (this.socket == null) {
            return;
        }
        this.disconnect();
        int retryConnectTimeout = this.timeOutManager.nextTimeout();
        logger.info("Wait for " + retryConnectTimeout + " before reconnect");
        try {
            Thread.sleep(retryConnectTimeout);
        }
        catch (InterruptedException e1) {
            throw new RuntimeException(e1);
        }
        this.reconnectAttempt(this.timeOutManager.repeatedTimes(), retryConnectTimeout);
        this.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        logger.info("Try to disconnect");
        Object object = this.lock;
        synchronized (object) {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.connected();
    }

    abstract void connected();

    abstract void reconnectAttempt(int var1, int var2);

    abstract void connectError(String var1);

    abstract void disconnected(String var1);

    abstract void subscriptionResult(Object ... var1);

    abstract void invocationResult(Object ... var1);
}

