/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt.command;

import com.backendless.rt.users.UserInfo;
import java.util.Map;

public class Command<T> {
    private final transient Class<T> dataType;
    private String type;
    private T data;
    private UserInfo userInfo;

    public static <T> Command<T> of(Class<T> dataType) {
        return new Command<T>(dataType);
    }

    public static Command<String> string() {
        return new Command<String>(String.class);
    }

    public static Command<Map> map() {
        return new Command<Map>(Map.class);
    }

    private Command(Class<T> dataType) {
        this.dataType = dataType;
    }

    public String getType() {
        return this.type;
    }

    public Command setType(String type) {
        this.type = type;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public Command setData(T data) {
        this.data = data;
        return this;
    }

    public UserInfo getUserInfo() {
        return this.userInfo;
    }

    public Command setUserInfo(UserInfo userInfo) {
        this.userInfo = userInfo;
        return this;
    }

    public String toString() {
        return "RTCommand{dataType=" + this.dataType + ", type='" + this.type + '\'' + ", data=" + this.data + ", userInfo=" + this.userInfo + '}';
    }
}

