/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt.command;

import com.backendless.BackendlessInjector;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.rt.RTCallback;
import com.backendless.rt.RTClient;
import com.backendless.rt.RTMethodRequest;
import com.backendless.rt.RTSubscription;
import com.backendless.rt.command.Command;
import com.backendless.rt.command.CommandRequest;
import com.backendless.rt.users.UserInfo;
import com.backendless.utils.WeborbSerializationHelper;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import weborb.exceptions.AdaptingException;
import weborb.types.IAdaptingType;

public abstract class CommandListener<T extends RTSubscription, R extends CommandRequest> {
    private static final Logger logger = Logger.getLogger("CommandListener");
    private final RTClient rtClient = BackendlessInjector.getInstance().getRtClient();
    private final ConcurrentLinkedDeque<RTMethodRequest> commandsToSend = new ConcurrentLinkedDeque();

    public abstract CopyOnWriteArrayList<T> getSubscriptionHolder();

    public abstract T createSubscription(RTCallback var1);

    public abstract R createCommandRequest(RTCallback var1);

    public abstract boolean isConnected();

    public void connected() {
        RTMethodRequest methodRequest = this.commandsToSend.poll();
        while (methodRequest != null) {
            this.rtClient.invoke(methodRequest);
            methodRequest = this.commandsToSend.poll();
        }
    }

    public <T> void addCommandListener(final Class<T> dataType, final AsyncCallback<Command<T>> callback) {
        RTCallback rtCallback = new RTCallback(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                try {
                    Command<Object> command = Command.of(dataType);
                    UserInfo userInfo = new UserInfo();
                    command.setUserInfo(userInfo);
                    userInfo.setConnectionId(WeborbSerializationHelper.asString(response, "connectionId"));
                    userInfo.setUserId(WeborbSerializationHelper.asString(response, "userId"));
                    command.setType(WeborbSerializationHelper.asString(response, "type"));
                    IAdaptingType data = WeborbSerializationHelper.asAdaptingType(response, "data");
                    command.setData(data.adapt((Type)dataType));
                    callback.handleResponse(command);
                }
                catch (AdaptingException e) {
                    callback.handleFault(new BackendlessFault(e.getMessage()));
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                callback.handleFault(fault);
            }
        };
        this.addCommandListener(rtCallback);
    }

    public void sendCommand(String type, Object data, final AsyncCallback<Void> callback) {
        logger.fine("Send command with type" + type);
        CommandRequest rtMethodRequest = ((CommandRequest)this.createCommandRequest(new RTCallback(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                logger.info("command sent");
                if (callback != null) {
                    callback.handleResponse(null);
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                logger.info("command fault " + (Object)((Object)fault));
                if (callback != null) {
                    callback.handleFault(fault);
                }
            }
        })).setData(data).setType(type);
        if (this.isConnected()) {
            this.rtClient.invoke(rtMethodRequest);
        } else {
            this.commandsToSend.addLast(rtMethodRequest);
        }
    }

    public void removeCommandListener(AsyncCallback<Command> callback) {
        CopyOnWriteArrayList<T> subscriptionHolder = this.getSubscriptionHolder();
        for (RTSubscription messagingSubscription : subscriptionHolder) {
            if (messagingSubscription.getCallback().usersCallback() != callback) continue;
            subscriptionHolder.remove(messagingSubscription);
            if (!this.isConnected()) continue;
            this.rtClient.unsubscribe(messagingSubscription.getId());
        }
    }

    private void addCommandListener(RTCallback rtCallback) {
        logger.fine("try to add command listener");
        T subscription = this.createSubscription(rtCallback);
        logger.log(Level.FINE, "subscription object {0}", new Object[]{subscription});
        this.getSubscriptionHolder().add(subscription);
        if (this.isConnected()) {
            logger.fine("subscription is connected try to subscribe");
            this.rtClient.subscribe((RTSubscription)subscription);
        }
    }
}

