/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt.data;

import com.backendless.rt.RTCallback;
import com.backendless.rt.RTSubscription;
import com.backendless.rt.SubscriptionNames;
import com.backendless.rt.data.ObjectEvents;
import com.backendless.rt.data.RelationEvents;
import java.util.List;

class DataSubscription
extends RTSubscription {
    DataSubscription(ObjectEvents objectEvent, String tableName, RTCallback callback) {
        super(SubscriptionNames.OBJECTS_CHANGES, callback);
        this.putOption("event", objectEvent.eventName());
        this.putOption("tableName", tableName);
    }

    DataSubscription(RelationEvents relationEvent, String tableName, String relationColumnName, RTCallback callback) {
        super(SubscriptionNames.RELATIONS_CHANGES, callback);
        this.putOption("event", relationEvent.eventName());
        this.putOption("tableName", tableName);
        this.putOption("relationColumnName", relationColumnName);
    }

    DataSubscription withWhere(String where) {
        this.putOption("whereClause", where);
        return this;
    }

    DataSubscription withParentObjects(List<String> parentObjects) {
        this.putOption("parentObjects", parentObjects);
        return this;
    }

    ObjectEvents getObjectEvent() {
        String eventStr = (String)this.getOption("event");
        return eventStr == null ? null : ObjectEvents.forName(eventStr);
    }

    RelationEvents getRelationEvent() {
        String eventStr = (String)this.getOption("event");
        return eventStr == null ? null : RelationEvents.forName(eventStr);
    }

    String getTableName() {
        return (String)this.getOption("tableName");
    }

    String getWhereClause() {
        return (String)this.getOption("whereClause");
    }
}

