/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt.data;

import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.persistence.BackendlessSerializer;
import com.backendless.rt.RTCallback;
import com.backendless.rt.RTEvent;
import com.backendless.rt.RTListener;
import com.backendless.rt.RTListenerImpl;
import com.backendless.rt.RTSubscription;
import com.backendless.rt.SubscriptionNames;
import com.backendless.rt.data.BulkEvent;
import com.backendless.rt.data.DataSubscription;
import com.backendless.rt.data.EventHandler;
import com.backendless.rt.data.ObjectEvents;
import com.backendless.rt.data.RelationEvents;
import com.backendless.rt.data.RelationStatus;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import weborb.exceptions.AdaptingException;
import weborb.types.IAdaptingType;

public class EventHandlerImpl<T>
extends RTListenerImpl
implements EventHandler<T> {
    private final Class clazz;
    private final String tableName;

    EventHandlerImpl(Class<T> clazz) {
        this.clazz = clazz;
        this.tableName = BackendlessSerializer.getSimpleName(clazz);
    }

    EventHandlerImpl(String tableName) {
        this.clazz = HashMap.class;
        this.tableName = tableName;
    }

    @Override
    public void addCreateListener(AsyncCallback<T> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.created, this.tableName, this.createCallback(callback));
        this.addEventListener(subscription);
    }

    @Override
    public void addCreateListener(String whereClause, AsyncCallback<T> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.created, this.tableName, this.createCallback(callback)).withWhere(whereClause);
        this.addEventListener(subscription);
    }

    @Override
    public void removeCreateListeners() {
        this.removeListeners(ObjectEvents.created);
    }

    @Override
    public void removeCreateListener(String whereClause, AsyncCallback<T> callback) {
        this.removeListeners(ObjectEvents.created, whereClause, callback);
    }

    @Override
    public void removeCreateListener(AsyncCallback<T> callback) {
        this.removeListeners((RTEvent)ObjectEvents.created, callback);
    }

    @Override
    public void removeCreateListeners(String whereClause) {
        this.removeListeners((RTEvent)ObjectEvents.created, whereClause);
    }

    @Override
    public void addUpdateListener(AsyncCallback<T> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.updated, this.tableName, this.createCallback(callback));
        this.addEventListener(subscription);
    }

    @Override
    public void addUpdateListener(String whereClause, AsyncCallback<T> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.updated, this.tableName, this.createCallback(callback)).withWhere(whereClause);
        this.addEventListener(subscription);
    }

    @Override
    public void removeUpdateListeners() {
        this.removeListeners(ObjectEvents.updated);
    }

    @Override
    public void removeUpdateListener(String whereClause, AsyncCallback<T> callback) {
        this.removeListeners(ObjectEvents.updated, whereClause, callback);
    }

    @Override
    public void removeUpdateListener(AsyncCallback<T> callback) {
        this.removeListeners((RTEvent)ObjectEvents.updated, callback);
    }

    @Override
    public void removeUpdateListeners(String whereClause) {
        this.removeListeners((RTEvent)ObjectEvents.updated, whereClause);
    }

    @Override
    public void addUpsertListener(AsyncCallback<T> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.upserted, this.tableName, this.createCallback(callback));
        this.addEventListener(subscription);
    }

    @Override
    public void addUpsertListener(String whereClause, AsyncCallback<T> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.upserted, this.tableName, this.createCallback(callback)).withWhere(whereClause);
        this.addEventListener(subscription);
    }

    @Override
    public void removeUpsertListeners() {
        this.removeListeners(ObjectEvents.upserted);
    }

    @Override
    public void removeUpsertListener(AsyncCallback<T> callback) {
        this.removeListeners((RTEvent)ObjectEvents.upserted, callback);
    }

    @Override
    public void removeUpsertListeners(String whereClause) {
        this.removeListeners((RTEvent)ObjectEvents.upserted, whereClause);
    }

    @Override
    public void removeUpsertListener(String whereClause, AsyncCallback<T> callback) {
        this.removeListeners(ObjectEvents.upserted, whereClause, callback);
    }

    @Override
    public void addDeleteListener(AsyncCallback<T> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.deleted, this.tableName, this.createCallback(callback));
        this.addEventListener(subscription);
    }

    @Override
    public void addDeleteListener(String whereClause, AsyncCallback<T> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.deleted, this.tableName, this.createCallback(callback)).withWhere(whereClause);
        this.addEventListener(subscription);
    }

    @Override
    public void removeDeleteListeners() {
        this.removeListeners(ObjectEvents.deleted);
    }

    @Override
    public void removeDeleteListener(String whereClause, AsyncCallback<T> callback) {
        this.removeListeners(ObjectEvents.deleted, whereClause, callback);
    }

    @Override
    public void removeDeleteListener(AsyncCallback<T> callback) {
        this.removeListeners((RTEvent)ObjectEvents.deleted, callback);
    }

    @Override
    public void removeDeleteListeners(String whereClause) {
        this.removeListeners((RTEvent)ObjectEvents.deleted, whereClause);
    }

    @Override
    public void addBulkCreateListener(AsyncCallback<List> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.bulk_created, this.tableName, this.createCallback(callback, List.class));
        this.addEventListener(subscription);
    }

    @Override
    public void removeBulkCreateListener(AsyncCallback<List<String>> callback) {
        this.removeListeners((RTEvent)ObjectEvents.bulk_created, callback);
    }

    @Override
    public void removeBulkCreateListeners() {
        this.removeListeners(ObjectEvents.bulk_created);
    }

    @Override
    public void addBulkUpdateListener(AsyncCallback<BulkEvent> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.bulk_updated, this.tableName, this.createCallback(callback, BulkEvent.class));
        this.addEventListener(subscription);
    }

    @Override
    public void addBulkUpdateListener(String whereClause, AsyncCallback<BulkEvent> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.bulk_updated, this.tableName, this.createCallback(callback, BulkEvent.class)).withWhere(whereClause);
        this.addEventListener(subscription);
    }

    @Override
    public void removeBulkUpdateListeners() {
        this.removeListeners(ObjectEvents.bulk_updated);
    }

    @Override
    public void removeBulkUpdateListener(String whereClause, AsyncCallback<BulkEvent> callback) {
        this.removeListeners(ObjectEvents.bulk_updated, whereClause, callback);
    }

    @Override
    public void removeBulkUpdateListener(AsyncCallback<BulkEvent> callback) {
        this.removeListeners((RTEvent)ObjectEvents.bulk_updated, callback);
    }

    @Override
    public void removeBulkUpdateListeners(String whereClause) {
        this.removeListeners((RTEvent)ObjectEvents.bulk_updated, whereClause);
    }

    @Override
    public void addBulkUpsertListener(AsyncCallback<List> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.bulk_upserted, this.tableName, this.createCallback(callback, List.class));
        this.addEventListener(subscription);
    }

    @Override
    public void removeBulkUpsertListeners() {
        this.removeListeners(ObjectEvents.bulk_upserted);
    }

    @Override
    public void removeBulkUpsertListener(AsyncCallback<List<String>> callback) {
        this.removeListeners((RTEvent)ObjectEvents.bulk_upserted, callback);
    }

    @Override
    public void addBulkDeleteListener(AsyncCallback<BulkEvent> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.bulk_deleted, this.tableName, this.createCallback(callback, BulkEvent.class));
        this.addEventListener(subscription);
    }

    @Override
    public void addBulkDeleteListener(String whereClause, AsyncCallback<BulkEvent> callback) {
        DataSubscription subscription = new DataSubscription(ObjectEvents.bulk_deleted, this.tableName, this.createCallback(callback, BulkEvent.class)).withWhere(whereClause);
        this.addEventListener(subscription);
    }

    @Override
    public void removeBulkDeleteListeners() {
        this.removeListeners(ObjectEvents.bulk_deleted);
    }

    @Override
    public void removeBulkDeleteListener(String whereClause, AsyncCallback<BulkEvent> callback) {
        this.removeListeners(ObjectEvents.bulk_deleted, whereClause, callback);
    }

    @Override
    public void removeBulkDeleteListener(AsyncCallback<BulkEvent> callback) {
        this.removeListeners((RTEvent)ObjectEvents.bulk_deleted, callback);
    }

    @Override
    public void removeBulkDeleteListeners(String whereClause) {
        this.removeListeners((RTEvent)ObjectEvents.bulk_deleted, whereClause);
    }

    @Override
    public void addSetRelationListener(String relationColumnName, AsyncCallback<RelationStatus> callback) {
        DataSubscription subscription = new DataSubscription(RelationEvents.relations_set, this.tableName, relationColumnName, this.createCallback(callback, RelationStatus.class));
        this.addEventListener(subscription);
    }

    @Override
    public void addSetRelationListener(String relationColumnName, List<String> parentObjects, AsyncCallback<RelationStatus> callback) {
        DataSubscription subscription = new DataSubscription(RelationEvents.relations_set, this.tableName, relationColumnName, this.createCallback(callback, RelationStatus.class)).withParentObjects(parentObjects);
        this.addEventListener(subscription);
    }

    @Override
    public void removeSetRelationListeners() {
        this.removeListeners(RelationEvents.relations_set);
    }

    @Override
    public void addAddRelationListener(String relationColumnName, AsyncCallback<RelationStatus> callback) {
        DataSubscription subscription = new DataSubscription(RelationEvents.relations_added, this.tableName, relationColumnName, this.createCallback(callback, RelationStatus.class));
        this.addEventListener(subscription);
    }

    @Override
    public void addAddRelationListener(String relationColumnName, List<String> parentObjects, AsyncCallback<RelationStatus> callback) {
        DataSubscription subscription = new DataSubscription(RelationEvents.relations_added, this.tableName, relationColumnName, this.createCallback(callback, RelationStatus.class)).withParentObjects(parentObjects);
        this.addEventListener(subscription);
    }

    @Override
    public void removeAddRelationListeners() {
        this.removeListeners(RelationEvents.relations_added);
    }

    @Override
    public void addDeleteRelationListener(String relationColumnName, AsyncCallback<RelationStatus> callback) {
        DataSubscription subscription = new DataSubscription(RelationEvents.relations_removed, this.tableName, relationColumnName, this.createCallback(callback, RelationStatus.class));
        this.addEventListener(subscription);
    }

    @Override
    public void addDeleteRelationListener(String relationColumnName, List<String> parentObjects, AsyncCallback<RelationStatus> callback) {
        DataSubscription subscription = new DataSubscription(RelationEvents.relations_removed, this.tableName, relationColumnName, this.createCallback(callback, RelationStatus.class)).withParentObjects(parentObjects);
        this.addEventListener(subscription);
    }

    @Override
    public void removeDeleteRelationListeners() {
        this.removeListeners(RelationEvents.relations_removed);
    }

    private void removeListeners(final RTEvent event) {
        this.removeEventListener(new RTListener.Predicate(){

            @Override
            public boolean test(RTSubscription subscription) {
                return EventHandlerImpl.this.isEventSubscription(subscription, event);
            }
        });
    }

    private void removeListeners(final RTEvent event, final AsyncCallback callback) {
        this.checkCallback(callback);
        this.removeEventListener(new RTListener.Predicate(){

            @Override
            public boolean test(RTSubscription subscription) {
                return EventHandlerImpl.this.isEventSubscription(subscription, event) && subscription.getCallback().usersCallback().equals(callback);
            }
        });
    }

    private void removeListeners(final RTEvent event, final String whereClause, final AsyncCallback callback) {
        this.checkCallback(callback);
        this.checkWhereClause(whereClause);
        this.removeEventListener(new RTListener.Predicate(){

            @Override
            public boolean test(RTSubscription subscription) {
                return EventHandlerImpl.this.isEventSubscription(subscription, event) && subscription.getCallback().usersCallback().equals(callback) && whereClause.equals(((DataSubscription)subscription).getWhereClause());
            }
        });
    }

    private void removeListeners(final RTEvent event, final String whereClause) {
        this.checkWhereClause(whereClause);
        this.removeEventListener(new RTListener.Predicate(){

            @Override
            public boolean test(RTSubscription subscription) {
                return EventHandlerImpl.this.isEventSubscription(subscription, event) && whereClause.equals(((DataSubscription)subscription).getWhereClause());
            }
        });
    }

    private boolean isEventSubscription(RTSubscription subscription, RTEvent event) {
        if (!(subscription instanceof DataSubscription)) {
            return false;
        }
        DataSubscription dataSubscription = (DataSubscription)subscription;
        if (event instanceof ObjectEvents) {
            return dataSubscription.getSubscriptionName() == SubscriptionNames.OBJECTS_CHANGES && dataSubscription.getObjectEvent() == event;
        }
        if (event instanceof RelationEvents) {
            return dataSubscription.getSubscriptionName() == SubscriptionNames.RELATIONS_CHANGES && dataSubscription.getRelationEvent() == event;
        }
        return false;
    }

    private RTCallback createCallback(AsyncCallback<T> callback) {
        return this.createCallback(callback, this.clazz);
    }

    private <Type> RTCallback createCallback(final AsyncCallback<Type> callback, final Class<Type> classType) {
        this.checkCallback(callback);
        return new RTCallback(){

            @Override
            public AsyncCallback<Type> usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                try {
                    Object adaptedResponse = response.adapt((Type)classType);
                    callback.handleResponse(adaptedResponse);
                }
                catch (AdaptingException e) {
                    callback.handleFault(new BackendlessFault(e.getMessage()));
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                callback.handleFault(fault);
            }
        };
    }

    private void checkCallback(AsyncCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback can not be null");
        }
    }

    private void checkWhereClause(String whereClause) {
        if (whereClause == null) {
            throw new IllegalArgumentException("whereClause can not be null");
        }
    }
}

