/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt.messaging;

import com.backendless.BackendlessInjector;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessException;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.messaging.PublishMessageInfo;
import com.backendless.rt.ConnectListener;
import com.backendless.rt.RTCallback;
import com.backendless.rt.RTClient;
import com.backendless.rt.RTListenerImpl;
import com.backendless.rt.SubscriptionNames;
import com.backendless.rt.command.Command;
import com.backendless.rt.command.CommandListener;
import com.backendless.rt.messaging.Channel;
import com.backendless.rt.messaging.MessageInfoCallback;
import com.backendless.rt.messaging.MessagingCommandRequest;
import com.backendless.rt.messaging.MessagingSubscription;
import com.backendless.rt.users.UserStatusResponse;
import com.backendless.utils.WeborbSerializationHelper;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import weborb.exceptions.AdaptingException;
import weborb.types.IAdaptingType;

public class ChannelImpl
extends RTListenerImpl
implements Channel {
    private static final Logger logger = Logger.getLogger("ChannelImpl");
    private final String channel;
    private final RTClient rtClient = BackendlessInjector.getInstance().getRtClient();
    private final CopyOnWriteArrayList<MessagingSubscription> messagingCallbacks = new CopyOnWriteArrayList();
    private final CommandListener<MessagingSubscription, MessagingCommandRequest> commandListener = new CommandListener<MessagingSubscription, MessagingCommandRequest>(){

        @Override
        public CopyOnWriteArrayList<MessagingSubscription> getSubscriptionHolder() {
            return ChannelImpl.this.messagingCallbacks;
        }

        @Override
        public MessagingSubscription createSubscription(RTCallback rtCallback) {
            return MessagingSubscription.command(ChannelImpl.this.channel, rtCallback);
        }

        @Override
        public MessagingCommandRequest createCommandRequest(RTCallback rtCallback) {
            return new MessagingCommandRequest(ChannelImpl.this.channel, rtCallback);
        }

        @Override
        public boolean isConnected() {
            return ChannelImpl.this.connectListener.isConnected();
        }
    };
    private final ConnectListener<MessagingSubscription> connectListener;

    ChannelImpl(final String channel) {
        this.channel = channel;
        this.connectListener = new ConnectListener<MessagingSubscription>(channel){

            @Override
            public void connected() {
                for (MessagingSubscription messagingCallback : ChannelImpl.this.messagingCallbacks) {
                    ChannelImpl.this.rtClient.subscribe(messagingCallback);
                }
                ChannelImpl.this.commandListener.connected();
            }

            @Override
            public MessagingSubscription createSubscription(RTCallback callback) {
                return MessagingSubscription.connect(channel, callback);
            }
        };
        this.join();
    }

    @Override
    public void join() {
        this.connectListener.connect();
    }

    @Override
    public void leave() {
        this.connectListener.disconnect();
    }

    @Override
    public boolean isJoined() {
        return this.connectListener.isConnected();
    }

    @Override
    public void addJoinListener(AsyncCallback<Void> callback) {
        this.connectListener.addConnectListener(callback);
    }

    @Override
    public void removeJoinListener(AsyncCallback<Void> callback) {
        this.connectListener.removeConnectListener(callback);
    }

    @Override
    public void addMessageListener(AsyncCallback<String> callback) {
        this.addMessageListener(null, callback, String.class);
    }

    @Override
    public <T> void addMessageListener(AsyncCallback<T> callback, Class<T> clazz) {
        this.addMessageListener(null, callback, clazz);
    }

    @Override
    public void addMessageListener(String selector, AsyncCallback<String> callback) {
        this.addMessageListener(selector, callback, String.class);
    }

    @Override
    public <T> void addMessageListener(String selector, final AsyncCallback<T> callback, final Class<T> clazz) {
        RTCallback rtCallback = new RTCallback(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                try {
                    IAdaptingType message = WeborbSerializationHelper.asAdaptingType(response, "message");
                    Object adaptedResponse = message.adapt((Type)clazz);
                    callback.handleResponse(adaptedResponse);
                }
                catch (AdaptingException e) {
                    callback.handleFault(new BackendlessFault(e.getMessage()));
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                callback.handleFault(fault);
            }
        };
        this.addMessageListener(selector, rtCallback);
    }

    @Override
    public void addMessageListener(String selector, final MessageInfoCallback callback) {
        RTCallback rtCallback = new RTCallback(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                try {
                    PublishMessageInfo adaptedResponse = (PublishMessageInfo)response.adapt(PublishMessageInfo.class);
                    callback.handleResponse(adaptedResponse);
                }
                catch (AdaptingException e) {
                    callback.handleFault(new BackendlessFault(e.getMessage()));
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                callback.handleFault(fault);
            }
        };
        this.addMessageListener(selector, rtCallback);
    }

    @Override
    public void addMessageListener(MessageInfoCallback callback) {
        this.addMessageListener((String)null, callback);
    }

    @Override
    public void removeMessageListeners(String selector) {
        for (MessagingSubscription messagingSubscription : this.messagingCallbacks) {
            if (messagingSubscription.getSelector() == null || !messagingSubscription.getSelector().equals(selector)) continue;
            this.removeSubscription(messagingSubscription);
        }
    }

    @Override
    public void removeMessageListener(AsyncCallback<?> callback) {
        for (MessagingSubscription messagingSubscription : this.messagingCallbacks) {
            if (messagingSubscription.getCallback().usersCallback() != callback) continue;
            this.removeSubscription(messagingSubscription);
        }
    }

    @Override
    public void removeMessageListeners(String selector, AsyncCallback<?> callback) {
        for (MessagingSubscription messagingSubscription : this.messagingCallbacks) {
            if (selector != null && !selector.equals(messagingSubscription.getSelector()) || callback != null && messagingSubscription.getCallback().usersCallback() != callback) continue;
            this.removeSubscription(messagingSubscription);
        }
    }

    @Override
    public void removeAllMessageListeners() {
        Iterator<MessagingSubscription> iterator = this.messagingCallbacks.iterator();
        this.messagingCallbacks.clear();
        while (iterator.hasNext()) {
            MessagingSubscription messagingSubscription = iterator.next();
            if (!this.isJoined()) continue;
            this.rtClient.unsubscribe(messagingSubscription.getId());
        }
    }

    @Override
    public <T> void addCommandListener(Class<T> dataType, AsyncCallback<Command<T>> callback) {
        this.commandListener.addCommandListener(dataType, callback);
    }

    @Override
    public void addCommandListener(AsyncCallback<Command<String>> callback) {
        this.addCommandListener(String.class, callback);
    }

    @Override
    public <T> void sendCommand(String type, Object data) {
        this.sendCommand(type, data, null);
    }

    @Override
    public <T> void sendCommand(String type, Object data, AsyncCallback<Void> callback) {
        this.commandListener.sendCommand(type, data, callback);
    }

    @Override
    public void removeCommandListener(AsyncCallback<Command> callback) {
        this.removeMessageListener(callback);
    }

    @Override
    public void addUserStatusListener(final AsyncCallback<UserStatusResponse> callback) {
        if (callback == null) {
            throw new BackendlessException("Callback can not be null");
        }
        RTCallback rtCallback = new RTCallback(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                try {
                    UserStatusResponse userStatusResponse = (UserStatusResponse)response.adapt(UserStatusResponse.class);
                    callback.handleResponse(userStatusResponse);
                }
                catch (AdaptingException e) {
                    callback.handleFault(new BackendlessFault(e.getMessage()));
                }
            }

            @Override
            public void handleFault(BackendlessFault fault) {
                callback.handleFault(fault);
            }
        };
        this.addUserListener(rtCallback);
    }

    @Override
    public void removeUserStatusListeners() {
        for (MessagingSubscription messagingSubscription : this.messagingCallbacks) {
            if (messagingSubscription.getSubscriptionName() != SubscriptionNames.PUB_SUB_USERS) continue;
            this.removeSubscription(messagingSubscription);
        }
    }

    @Override
    public void removeUserStatusListener(AsyncCallback<UserStatusResponse> callback) {
        this.removeMessageListener(callback);
    }

    private void addMessageListener(String selector, RTCallback rtCallback) {
        MessagingSubscription subscription = selector == null ? MessagingSubscription.subscribe(this.channel, rtCallback) : MessagingSubscription.subscribe(this.channel, selector, rtCallback);
        this.messagingCallbacks.add(subscription);
        if (this.isJoined()) {
            this.rtClient.subscribe(subscription);
        }
    }

    private void addUserListener(RTCallback rtCallback) {
        MessagingSubscription subscription = MessagingSubscription.userStatus(this.channel, rtCallback);
        this.messagingCallbacks.add(subscription);
        if (this.isJoined()) {
            this.rtClient.subscribe(subscription);
        }
    }

    private void removeSubscription(MessagingSubscription messagingSubscription) {
        this.messagingCallbacks.remove(messagingSubscription);
        if (this.isJoined()) {
            this.rtClient.unsubscribe(messagingSubscription.getId());
        }
    }
}

