/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.rt.rso;

import com.backendless.BackendlessInjector;
import com.backendless.async.callback.AsyncCallback;
import com.backendless.exceptions.BackendlessException;
import com.backendless.exceptions.BackendlessFault;
import com.backendless.rt.ConnectListener;
import com.backendless.rt.MethodRequestHelper;
import com.backendless.rt.MethodTypes;
import com.backendless.rt.RTCallback;
import com.backendless.rt.RTCallbackWithFault;
import com.backendless.rt.RTClient;
import com.backendless.rt.RTMethodRequest;
import com.backendless.rt.SubscriptionNames;
import com.backendless.rt.command.Command;
import com.backendless.rt.command.CommandListener;
import com.backendless.rt.rso.InvocationHelper;
import com.backendless.rt.rso.RSOSubscription;
import com.backendless.rt.rso.SOCommandRequest;
import com.backendless.rt.rso.SOMethodRequest;
import com.backendless.rt.rso.SharedObject;
import com.backendless.rt.rso.SharedObjectChanges;
import com.backendless.rt.users.UserInfo;
import com.backendless.rt.users.UserStatus;
import com.backendless.utils.WeborbSerializationHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import weborb.exceptions.AdaptingException;
import weborb.reader.ArrayType;
import weborb.types.IAdaptingType;

public class SharedObjectImpl
implements SharedObject {
    private static final Logger logger = Logger.getLogger("SharedObject");
    private final String name;
    private final RTClient rtClient = BackendlessInjector.getInstance().getRtClient();
    private final CopyOnWriteArrayList<RSOSubscription> subscriptions = new CopyOnWriteArrayList();
    private Object invocationTarget;
    private AsyncCallback<Object> invocationCallback;
    private final ConnectListener<RSOSubscription> connectListener;
    private final CommandListener<RSOSubscription, SOCommandRequest> commandListener = new CommandListener<RSOSubscription, SOCommandRequest>(){

        @Override
        public CopyOnWriteArrayList<RSOSubscription> getSubscriptionHolder() {
            return SharedObjectImpl.this.subscriptions;
        }

        @Override
        public RSOSubscription createSubscription(RTCallback rtCallback) {
            return RSOSubscription.command(SharedObjectImpl.this.name, rtCallback);
        }

        @Override
        public SOCommandRequest createCommandRequest(RTCallback rtCallback) {
            return new SOCommandRequest(SharedObjectImpl.this.name, rtCallback);
        }

        @Override
        public boolean isConnected() {
            return SharedObjectImpl.this.connectListener.isConnected();
        }
    };

    SharedObjectImpl(final String name) {
        this.name = name;
        this.connectListener = new ConnectListener<RSOSubscription>(name){

            @Override
            public void connected() {
                for (RSOSubscription subscription : SharedObjectImpl.this.subscriptions) {
                    SharedObjectImpl.this.rtClient.subscribe(subscription);
                }
                SharedObjectImpl.this.commandListener.connected();
            }

            @Override
            public RSOSubscription createSubscription(RTCallback callback) {
                return RSOSubscription.connect(name, callback);
            }
        };
        RSOSubscription invocationSubscription = RSOSubscription.invoke(name, new RTCallbackWithFault(){

            @Override
            public AsyncCallback usersCallback() {
                return null;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                block6: {
                    logger.fine("handle invocation");
                    String methodName = WeborbSerializationHelper.asString(response, "method");
                    logger.fine("invocation for method - " + methodName);
                    ArrayType arg = (ArrayType)WeborbSerializationHelper.asAdaptingType(response, "args");
                    if (SharedObjectImpl.this.invocationTarget != null) {
                        try {
                            Object result = InvocationHelper.invoke(SharedObjectImpl.this.invocationTarget, methodName, arg);
                            logger.log(Level.FINE, "Invocation result {0}", new Object[]{result});
                            if (SharedObjectImpl.this.invocationCallback != null) {
                                SharedObjectImpl.this.invocationCallback.handleResponse(result);
                            }
                        }
                        catch (BackendlessException e) {
                            logger.warning("Invocation fault: " + e.getMessage());
                            if (SharedObjectImpl.this.invocationCallback != null) {
                                SharedObjectImpl.this.invocationCallback.handleFault(new BackendlessFault(e));
                            }
                        }
                        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | AdaptingException e) {
                            logger.warning("Invocation fault: " + e.getMessage());
                            if (SharedObjectImpl.this.invocationCallback == null) break block6;
                            SharedObjectImpl.this.invocationCallback.handleFault(new BackendlessFault(e.getMessage()));
                        }
                    }
                }
            }
        });
        this.addListener(invocationSubscription);
    }

    @Override
    public void addConnectListener(AsyncCallback<Void> callback) {
        this.connectListener.addConnectListener(callback);
    }

    @Override
    public void removeConnectListener(AsyncCallback<Void> callback) {
        this.connectListener.removeConnectListener(callback);
    }

    @Override
    public void removeConnectListeners() {
        this.connectListener.removeConnectListeners();
    }

    @Override
    public void addChangesListener(final AsyncCallback<SharedObjectChanges> callback) {
        this.checkCallback(callback);
        RTCallbackWithFault rtCallback = new RTCallbackWithFault(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                SharedObjectChanges sharedObjectChanges = new SharedObjectChanges();
                UserInfo userInfo = new UserInfo();
                sharedObjectChanges.setUserInfo(userInfo);
                userInfo.setConnectionId(WeborbSerializationHelper.asString(response, "connectionId"));
                userInfo.setUserId(WeborbSerializationHelper.asString(response, "userId"));
                String key = WeborbSerializationHelper.asString(response, "key");
                sharedObjectChanges.setKey(key);
                IAdaptingType data = WeborbSerializationHelper.asAdaptingType(response, "data");
                Object value = data.defaultAdapt();
                sharedObjectChanges.setValue(value);
                callback.handleResponse(sharedObjectChanges);
            }
        };
        this.addListener(RSOSubscription.changes(this.name, rtCallback));
    }

    private void checkCallback(AsyncCallback<?> callback) {
        if (callback == null) {
            throw new BackendlessException("calback can not be null");
        }
    }

    @Override
    public void removeChangesListener(AsyncCallback<SharedObjectChanges> callback) {
        this.removeSubscription(callback);
    }

    @Override
    public void removeChangesListeners() {
        this.removeSubscription(SubscriptionNames.RSO_CHANGES);
    }

    @Override
    public void addClearListener(final AsyncCallback<UserInfo> callback) {
        this.checkCallback(callback);
        RTCallbackWithFault rtCallback = new RTCallbackWithFault(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                UserInfo userInfo;
                try {
                    userInfo = (UserInfo)response.adapt(UserInfo.class);
                }
                catch (AdaptingException e) {
                    this.handleFault(new BackendlessFault(e.getMessage()));
                    return;
                }
                callback.handleResponse(userInfo);
            }
        };
        this.addListener(RSOSubscription.cleared(this.name, rtCallback));
    }

    @Override
    public void removeClearListener(AsyncCallback<UserInfo> callback) {
        this.removeSubscription(callback);
    }

    @Override
    public void removeClearListeners() {
        this.removeSubscription(SubscriptionNames.RSO_CLEARED);
    }

    @Override
    public void addCommandListener(AsyncCallback<Command<String>> callback) {
        this.commandListener.addCommandListener(String.class, callback);
    }

    @Override
    public <T> void addCommandListener(Class<T> dataType, AsyncCallback<Command<T>> callback) {
        this.commandListener.addCommandListener(dataType, callback);
    }

    @Override
    public void removeCommandListener(AsyncCallback<Command> callback) {
        this.commandListener.removeCommandListener(callback);
    }

    @Override
    public void removeCommandListeners() {
        this.removeSubscription(SubscriptionNames.RSO_COMMANDS);
    }

    @Override
    public void addUserStatusListener(final AsyncCallback<UserStatus> callback) {
        this.checkCallback(callback);
        RTCallbackWithFault rtCallback = new RTCallbackWithFault(){

            @Override
            public AsyncCallback usersCallback() {
                return callback;
            }

            @Override
            public void handleResponse(IAdaptingType response) {
                try {
                    UserStatus userStatus = (UserStatus)((Object)response.adapt(UserStatus.class));
                    callback.handleResponse(userStatus);
                }
                catch (AdaptingException e) {
                    callback.handleFault(new BackendlessFault(e.getMessage()));
                }
            }
        };
        this.addListener(RSOSubscription.userStatus(this.name, rtCallback));
    }

    @Override
    public void removeUserStatusListener(AsyncCallback<UserStatus> callback) {
        this.removeSubscription(callback);
    }

    @Override
    public void removeUserStatusListeners() {
        this.removeSubscription(SubscriptionNames.RSO_USERS);
    }

    @Override
    public void set(final String key, final Object value, AsyncCallback<Void> callback) {
        new MethodRequestHelper(this.connectListener){

            @Override
            public RTMethodRequest createMethodRequest(RTCallback rtCallback) {
                return new SOMethodRequest(SharedObjectImpl.this.name, MethodTypes.RSO_SET, rtCallback).putMethodOption("key", key).putMethodOption("data", value);
            }
        }.invoke(callback);
    }

    @Override
    public void set(String key, Object value) {
        this.set(key, value, null);
    }

    @Override
    public void get(String key, AsyncCallback<String> callback) {
        this.get(key, String.class, callback);
    }

    @Override
    public <T> void get(final String key, Class<T> dataType, AsyncCallback<T> callback) {
        new MethodRequestHelper(this.connectListener){

            @Override
            public RTMethodRequest createMethodRequest(RTCallback rtCallback) {
                return new SOMethodRequest(SharedObjectImpl.this.name, MethodTypes.RSO_GET, rtCallback).putMethodOption("key", key);
            }
        }.invoke(dataType, callback);
    }

    @Override
    public void clear(AsyncCallback<Void> callback) {
        new MethodRequestHelper(this.connectListener){

            @Override
            public RTMethodRequest createMethodRequest(RTCallback rtCallback) {
                return new SOMethodRequest(SharedObjectImpl.this.name, MethodTypes.RSO_CLEAR, rtCallback);
            }
        }.invoke(callback);
    }

    @Override
    public void clear() {
        this.clear(null);
    }

    @Override
    public void sendCommand(String type, Object value) {
        this.commandListener.sendCommand(type, value, null);
    }

    @Override
    public void sendCommand(String type, Object value, AsyncCallback<Void> callback) {
        this.commandListener.sendCommand(type, value, callback);
    }

    @Override
    public void invoke(String methodName, Object ... args) {
        this.invoke(methodName, args, null, null);
    }

    @Override
    public void invoke(String methodName, Object[] args, AsyncCallback<Void> callback) {
        this.invoke(methodName, args, null, callback);
    }

    @Override
    public void invoke(final String methodName, final Object[] args, final Collection<String> target, AsyncCallback<Void> callback) {
        new MethodRequestHelper(this.connectListener){

            @Override
            public RTMethodRequest createMethodRequest(RTCallback rtCallback) {
                return new SOMethodRequest(SharedObjectImpl.this.name, MethodTypes.RSO_INVOKE, rtCallback).putMethodOption("method", methodName).putMethodOption("args", args).putMethodOption("targets", target);
            }
        }.invoke(callback);
    }

    @Override
    public void setInvocationTarget(Object target) {
        this.invocationTarget = target;
    }

    @Override
    public void setInvocationTarget(Object target, AsyncCallback<Object> callback) {
        this.setInvocationTarget(target);
        this.invocationCallback = callback;
    }

    @Override
    public void connect() {
        this.connectListener.connect();
    }

    @Override
    public void disconnect() {
        this.connectListener.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.connectListener.isConnected();
    }

    private void addListener(RSOSubscription subscription) {
        this.subscriptions.add(subscription);
        if (this.isConnected()) {
            this.rtClient.subscribe(subscription);
        }
    }

    private void removeSubscription(AsyncCallback callback) {
        for (RSOSubscription subscription : this.subscriptions) {
            if (subscription.getCallback() != callback) continue;
            this.removeSubscription(subscription);
        }
    }

    private void removeSubscription(SubscriptionNames subscriptionName) {
        for (RSOSubscription subscription : this.subscriptions) {
            if (subscription.getSubscriptionName() != subscriptionName) continue;
            this.removeSubscription(subscription);
        }
    }

    private void removeSubscription(RSOSubscription subscription) {
        this.subscriptions.remove(subscription);
        if (this.isConnected()) {
            this.rtClient.unsubscribe(subscription.getId());
        }
    }
}

