/*
 * Decompiled with CFR 0.152.
 */
package com.backendless.transaction;

import com.backendless.transaction.OpResultValueReference;
import com.backendless.transaction.Operation;
import com.backendless.transaction.OperationType;
import com.backendless.transaction.UnitOfWork;
import java.util.HashMap;
import java.util.Map;

public class OpResult {
    private final String tableName;
    private final OperationType operationType;
    private String opResultId;

    OpResult(String tableName, OperationType operationType, String opResultId) {
        this.tableName = tableName;
        this.operationType = operationType;
        this.opResultId = opResultId;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getOpResultId() {
        return this.opResultId;
    }

    public OpResultValueReference resolveTo(int resultIndex, String propName) {
        return new OpResultValueReference(this, resultIndex, propName);
    }

    public OpResultValueReference resolveTo(int resultIndex) {
        return new OpResultValueReference(this, resultIndex);
    }

    public OpResultValueReference resolveTo(String propName) {
        return new OpResultValueReference(this, propName);
    }

    Map<String, Object> makeReference() {
        HashMap<String, Object> referenceMap = new HashMap<String, Object>();
        referenceMap.put("___ref", true);
        referenceMap.put("opResultId", this.opResultId);
        return referenceMap;
    }

    public void setOpResultId(UnitOfWork unitOfWork, String newOpResultId) {
        if (unitOfWork.getOpResultIdStrings().contains(newOpResultId)) {
            throw new IllegalArgumentException("This opResultId already present. OpResultId must be unique");
        }
        for (Operation operation : unitOfWork.getOperations()) {
            if (!operation.getOpResultId().equals(this.opResultId)) continue;
            operation.setOpResultId(newOpResultId);
            break;
        }
        this.opResultId = newOpResultId;
    }
}

